;==============================================================================
; This is an example for a binary module that can be loaded with the BLOAD-
; word from My4TH. Binary modules can contain driver code for external devices
; or they can provide more (speed optimized) words to the FORTH system.
;
; Assemble this module with the myca command
;   $ myca examplemod.asm -o examplemod.bin
;
; Upload the binary module to My4TH with the my4th tool
; (for example. See "my4th --help" for details):
;   $ my4th write /dev/ttyS0 binary 15 examplemod.bin
;
;==============================================================================

#include <my4th/binmod.hsm>


;------------------------------------------------------------------------------
; Exported Words
;------------------------------------------------------------------------------

EXPORTS:  ;List of exported words.
          ;The list must be terminated with EEND.
          ;An empty list contains nothing but the end marker EEND.

          EXPORT  within_func, "new-within"
          EXPORT  mul4_func,   "*4"
          EXPORTI c_dots,      "[.s]"   ; export an immediate word
          EEND


;------------------------------------------------------------------------------
; Imported Words
;------------------------------------------------------------------------------

IMPORTS:  ;List of imported words.
          ;Each line starts with a label that can be called from the
          ;assembly program. The list must be terminated with IEND.
          ;An empty list contains nothing but the end marker IEND.

c_over    IMPORT  "over"
c_sub16   IMPORT  "-"
c_tor     IMPORT  ">r"
c_rfrom   IMPORT  "r>"
c_uless   IMPORT  "u<"
c_dots    IMPORT  ".s"
          IEND


;------------------------------------------------------------------------------
; Data Section
;------------------------------------------------------------------------------

; Important note:
; Everything in this section must be referenced with a pair of
; LD PTR_L,# / LD PTR_H,# instructions. Otherwise, the BLOAD word cannot
; translate the memory addresses correctly, which can lead to incorrect
; runtime behavior of this module.

infotext  DB "\nThis module implements the words 'new-within', '*4' and '[.s]'\n",0


;------------------------------------------------------------------------------
; Code Section. This section must be placed last, after all other sections.
;------------------------------------------------------------------------------

CODE:  ; marker for start of program code


init_module:
          ;This function is mandatory, it initializes this module.
          PHL

          ;You can add init-code here (or leave this function empty)
          LD   PTR_L,#<infotext
          LD   PTR_H,#>infotext
          JSR  rom_print_str

          RTS


within_func:   ;implemented as " over - >r - r> u< "
          PHL
          JSR  c_over
          JSR  c_sub16
          JSR  c_tor
          JSR  c_sub16
          JSR  c_rfrom
          JSR  c_uless
          RTS


mul4_func:     ; *4  ( d -- d )
          PHL
          JSR  rom_pop_data_R4   ;pull R4 from FORTH data stack
          CLC
          RWL  R4                ;R4 = R4 * 2 + 0
          CLC
          RWL  R4                ;R4 = R4 * 2 + 0
          JSR  rom_push_data_R4  ;push new R4 back to FORTH data stack
          RTS


;------------------------------------------------------------------------------
END_MODULE  ; This line terminates the code section of this binary module
