;------------------------------------------------------------------------------
; Delay - routines to delay program execution, used by the FORTH word "msec"
;------------------------------------------------------------------------------


;Put UART code into a special segment so it never crosses a 256-byte boundary
delay_functions Segment Code
ORG ROM_HI


;Delay routine for 8 MHz CPU clock frequency:
#if CPUCLOCK == 8
#ifdef PLATFORM_XS
delay_ms:
          ; Delay program execution for several milliseconds.
          ; In: ACCU = number of milliseconds to delay.
          LD   R0,#28
_dlms01   JLP  _dlms01
          DEC  R0
          INC  R0
          DEC
          TST
          JNF  delay_ms
          RET
#else
delay_ms:
          ; Delay program execution for several milliseconds.
          ; In: ACCU = number of milliseconds to delay.
          LD   R0,#38
_dlms01   JLP  _dlms01
          ROL  R0
          CLC
          DEC
          TST
          JNF  delay_ms
          RET
#endif
#endif


;Delay routine for 10 MHz CPU clock frequency:
#if CPUCLOCK == 10
delay_ms:
          ; Delay program execution for several milliseconds.
          ; In: ACCU = number of milliseconds to delay.
          LD   R0,#49
_dlms01   JLP  _dlms01
          LDA  ACCU
          DEC
          TST
          JNF  delay_ms
          RET
#endif


;Delay routine for 12 MHz CPU clock frequency:
#if CPUCLOCK == 12
delay_ms:
          ; Delay program execution for several milliseconds.
          ; In: ACCU = number of milliseconds to delay.
          LD   R0,#59
_dlms01   JLP  _dlms01
          CLC
          INC PAR1
          DEC
          TST
          JNF  delay_ms
          RET
#endif


;Delay routine for >=14 MHz CPU clock frequency:
#if CPUCLOCK >= 14
delay_ms:
          ; Delay program execution for several milliseconds.
          ; In: ACCU = number of milliseconds to delay.
          LD   R0,#(CPUCLOCK*5)
_dlms01   JLP  _dlms01
          CLC
          DEC
          TST
          JNF  delay_ms
          RET
#endif

delay_end: