

#ifdef WORDS_LEN_1

;------------------------------------------------------------------------------
;  Words with names that have a length of 1 characters
;------------------------------------------------------------------------------

            ; [  Stop compilation
            DW   e_cstop
            DB   1+FL_IMMEDIATE,"["
c_cstop     LD   STATE,#0
            RET
e_cstop     ;------------------------------------------------------------------


            ; ]  Restart compilation
            DW   e_cstart
            DB   1,"]"
c_cstart    LD   STATE,#1
            RET
e_cstart    ;------------------------------------------------------------------


            ; '  Interpret next word and get its code address on the stack
            DW   e_tick
            DB   1,"'"
c_tick      PHL
            JSR  search_word_ex
            JPF  Error_Word ;word not found
            ;LD   R5_L,PTR_L
            ;LD   R5_H,PTR_H            
            ;JMP__push_data_R5_ret
			JMP__push_data_PTR_ret            
e_tick      ;------------------------------------------------------------------


            ; @  ( addr -- x )  Fetch memory contents at addr
            DW   e_at
            DB   1,"@"
c_at        PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
            JSR__lap_inc_ptr
            STA  R4_L
            LAP
            STA  R4_H
            JMP__push_data_R4_ret
#endif
_c_at       JSR__pop_data_R4
c_at_ldpret JSR  ld_ptr_r4
c_at_ldret  JSR__lap_inc_ptr
            STA  R4_L
            LAP
            STA  R4_H
            JMP__push_data_R4_ret
e_at        ;------------------------------------------------------------------


            ; !  ( x addr -- )  Store x at addr
            DW   e_store
            DB   1,"!"
c_store     PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
            PLD  R4
#else
            JSR__pop_data_R5_R4
            JSR  ld_ptr_r5
#endif
_c_store_2  LDA  R4_L
            JSR__sap_inc_ptr
            LDA  R4_H
            SAP
            RTS
e_store     ;------------------------------------------------------------------


            ; <  ( x y -- flag )  Return true if x is less than y
            DW   e_lessthan
            DB   1,"<"
c_lessthan  PHL
_c_lessthan JSR__pop_data_R5_R4
_c_lthan_1  ROL  R4_H
            INC  FLAG
            ROR  R4_H
            ROL  R5_H
            INC  FLAG
            ROR  R5_H
_c_lthan_2  LDA  R4_L
            SU   R5_L
            LDA  R4_H
            SUB  R5_H
            JMP  _c_noteq_1
e_lessthan  ;------------------------------------------------------------------


            ; >  ( x y -- flag )  Return true if x is greater than y
            DW   e_grtrthan
            DB   1,">"
c_grtrthan  PHL
            JSR__pop_data_R4_R5
            JMP  _c_lthan_1
e_grtrthan  ;------------------------------------------------------------------


            ; =  ( x y -- flag )  Return true if x is equal to y
            DW   e_equal
            DB   1,"="
c_equal     PHL
            JSR__pop_data_R4_R5
            LDA  R4_L
            CMP  R5_L
            JNF  ret_false
            LDA  R4_H
_c_equal_2  CMP  R5_H
_c_equal_1  JNF  ret_false
ret_true    LD   R4_L,#0xFF
            JMP  _rettf
e_equal     ;------------------------------------------------------------------


            ; +  ( x y -- z )  Sum the two numbers at the top of the stack
            DW   e_sum16
            DB   1,"+"
c_sum16     PHL
_c_sum16    JSR__pop_data_R4_R5
            LDA  R4_L
            AD   R5_L
            STA  R4_L
            LDA  R4_H
            ADD  R5_H
            STA  R4_H
            JMP__push_data_R4_ret
e_sum16     ;------------------------------------------------------------------


            ; -  ( x y -- z )  Subtract the two numbers at the top of the stack
            DW   e_sub16
            DB   1,"-"
c_sub16     PHL
            JSR__pop_data_R5_R4
            LDA  R4_L
            SU   R5_L
            STA  R4_L
            LDA  R4_H
            SUB  R5_H
            STA  R4_H
            JMP__push_data_R4_ret
e_sub16     ;------------------------------------------------------------------


            ; *  ( x y -- z )  Multiply the two numbers at the top of the stack
            DW   e_mul16
            DB   1,"*"
c_mul16     PHL
            JSR__pop_data_R4_R5
            JSR  multiply_u
            JMP__push_data_R4_ret
e_mul16     ;------------------------------------------------------------------


            ; /  ( x y -- z )  Divide the two numbers at the top of the stack
            DW   e_div16
            DB   1,"/"
c_div16     PHL
            JSR__pop_data_R5_R4
            JSR  divide_s
            JMP__push_data_R4_ret
e_div16     ;------------------------------------------------------------------


            ; .  ( x -- )  Display signed number
            DW   e_dot
            DB   1,"."
c_dot       PHL
_c_dot      JSR  print_integer
p_space_rts JSR  print_space
            RTS
e_dot       ;------------------------------------------------------------------


            ; ?  ( addr -- )  Display content of a cell
            DW   e_qmark
            DB   1,"?"
c_qmark     PHL
            JSR  c_at
            JMP  _c_dot
e_qmark     ;------------------------------------------------------------------


            ; ,  ( x -- )  Writes the number on stack to the next free memory place
            DW   e_comma
            DB   1,","
c_comma     PHL
            JSR__pop_data_R4
emit_R4_ret:  ;emit R4 to position of CP and return
            JSR  emit_code_R4L
            LDA  R4_H
            JMP  emit_code_ret
e_comma     ;------------------------------------------------------------------


            ; I  ( -- i1 )  Get the loop index of the inner loop
            DW   e_i
            DB   1,"i"
c_i         PHL
            ;get the index from the control flow stack
            LD   PTR_L,LCFSP
_c_i_1      INC__PTR_L
            INC__PTR_L
            LD   PTR_H,#>LCTLFLOWSTACK
            LAP
            INC__PTR_L
            STA  R4_L
            LAP
            STA  R4_H
            JMP__push_data_R4_ret
e_i         ;------------------------------------------------------------------


            ; J  ( -- i2 )  Get the loop index of the outer loop
            DW   e_j
            DB   1,"j"
c_j         ;get the index from the control flow stack
            LD   R0,#1
_c_j_1      LD   PTR_L,LCFSP
_c_j_2      INC__PTR_L
            INC__PTR_L
            INC__PTR_L
            INC__PTR_L
            JLP  _c_j_2
            PHL
            JMP  _c_i_1
e_j         ;------------------------------------------------------------------


            ; K  ( -- i3 )  Get the loop index of the 2nd outer loop
            DW   e_k
            DB   1,"k"
c_k         ;get the index from the control flow stack
            LD   R0,#2
            JMP  _c_j_1
e_k         ;------------------------------------------------------------------


            ; L  ( -- i4 )  Get the loop index of the 3rd outer loop
            DW   e_l
            DB   1,"l"
c_l         ;get the index from the control flow stack
            LD   R0,#3
            JMP  _c_j_1
e_l         ;------------------------------------------------------------------


            ; #  ( ud1 -- ud2 )  Formatted number output.
            DW   e_ns
            DB   1,"#"
c_ns        PHL
            JSR__pop_data_R5_R4
            LD   R6_L,BASE
            LD   R6_H,BASE+1
            JSR  div_u32u16
            JSR__push_data_R4
            JSR__push_data_R5
            LDA  #<tab_num2asc
            OR   R6_L
            STA  PTR_L
            LD   PTR_H,#>tab_num2asc
            LAP
_c_ns_1     JSR  _outnumchr
            RTS
_outnumchr  DEC  NB_L
            LD   PTR_L,NB_L
            LD   PTR_H,NB_H
            SAP
            RET
e_ns        ;------------------------------------------------------------------


            ; :  enter compilation mode
            DW   e_colon
            DB   1,":"
c_colon     PHL
            ;TST  STATE
            ;JNF  Error_Syntax  ; can't happen, because : is not an immediate word
            JSR  start_new_word
            INC  STATE
            JMP  add_word_entry_code_ret
e_colon     ;------------------------------------------------------------------

  
            ; ";"  finish compilation
            DW   e_semicolon
            DB   1+FL_IMMEDIATE,0x3B
c_semicolon PHL
            TST  STATE
            JPF  Error_Syntax
            LD   STATE,#0
            ;add word to words list
            JSR  finish_new_word
            ;add function exit code (JMP return)
            JMP  add_JmpReturn_ret
e_semicolon ;------------------------------------------------------------------


#endif ;WORDS_LEN_1


;------------------------------------------------------------------------------
;  Words with names that have a length of 2 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_2

            ; +!  ( x addr -- )  Add the value x to the cell at addr
            DW   e_plusstore
            DB   2,"+!"
c_plusstore PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
            JSR__pop_data_R4
            LAP
            AD   R4_L
            SAP
            PSH  FLAG
            JSR__inc_ptr_lap
            POP  FLAG
            ADD  R4_H
            SAP
            RTS
e_plusstore ;------------------------------------------------------------------


            ; 0=  ( x -- flag )  -1 if top of stack is 0, 0 otherwise
            DW   e_test0
            DB   2,"0="
c_test0     PHL
            JSR__pop_data_R4
_c_test01   TST  R4_L
            JNF  ret_false
            TST  R4_H
            JMP  _c_equal_1
e_test0     ;------------------------------------------------------------------


            ; <>  ( x1 x2 -- flag )  flag is true if and only if x1 is not bit-for-bit the same as x2.
            DW   e_noteq
            DB   2,"<>"
c_noteq     PHL
            JSR__pop_data_R4_R5
            LDA  R4_L
            CMP  R5_L
            JNF  ret_true
            LDA  R4_H
            CMP  R5_H
_c_noteq_1  JNF  ret_true
ret_false   LD   R4_L,#0x00
_rettf      LD   R4_H,R4_L
            JMP__push_data_R4_ret
e_noteq     ;------------------------------------------------------------------


            ; 0<  ( x -- flag )  test if number is less than zero
            DW   e_zeroless
            DB   2,"0<"
c_zeroless  PHL
            JSR__pop_data_R4
c_zeroless1 ROL  R4_H
            JMP  _c_equal_1
e_zeroless  ;------------------------------------------------------------------


            ; 0>  ( x -- flag )  test if number is greater than zero
            DW   e_zerogt
            DB   2,"0>"
c_zerogt    PHL
            JSR__pop_data_R4
            TST  R4_L
            JNF  _c_zerogt_1
            TST  R4_H
            JPF  ret_false
_c_zerogt_1 ROL  R4_H
            JMP  _c_noteq_1
e_zerogt    ;------------------------------------------------------------------


            ; u<  ( x y -- flag )  Return true if x is less than y
            DW   e_ulessthan
            DB   2,"u<"
c_ulessthan PHL
            JSR__pop_data_R5_R4
            JMP  _c_lthan_2
e_ulessthan ;------------------------------------------------------------------


            ; u>  ( x y -- flag )  Return true if x is greater than y
            DW   e_ugrtrthan
            DB   2,"u>"
c_ugrtrthan PHL
            JSR__pop_data_R4_R5
            JMP  _c_lthan_2
e_ugrtrthan ;------------------------------------------------------------------


            ; 1+  ( x -- z )  Add 1 to the value on the stack
            DW   e_1plus
            DB   2,"1+"
c_1plus     PHL
            JSR__pop_data_R4
            JSR  inc_r4
            JMP__push_data_R4_ret
e_1plus     ;------------------------------------------------------------------


            ; 1-  ( x -- z )  Subtract 1 from the value on the stack
            DW   e_1minus
            DB   2,"1-"
c_1minus    PHL
_c_1minus   JSR__pop_data_R4
            JSR  dec_r4
            JMP__push_data_R4_ret
e_1minus     ;------------------------------------------------------------------


            ; or  ( x y -- z )  OR the two numbers at the top of the stack
            DW   e_or16
            DB   2,"or"
c_or16      PHL
            JSR__pop_data_R4_R5
            LDA  R4_L
            OR   R5_L
            STA  R4_L
            LDA  R4_H
            OR   R5_H
            JMP  _c_xor16_1
e_or16      ;------------------------------------------------------------------


            ; 2*  ( x -- z )  Shift the value on the stack 1 bit left
            DW   e_2star
            DB   2,"2*"
c_2star     PHL
            JSR__pop_data_R4
            CLC
            RWL  R4_L
            JMP__push_data_R4_ret
e_2star     ;------------------------------------------------------------------


            ; 2/  ( x -- z )  Divide the value on the stack by 2
            DW   e_2slash
            DB   2,"2/"
c_2slash    PHL
            JSR__pop_data_R4
            LDA  R4_H
            ROL
            ROR  R4_H
            ROR  R4_L
            JMP__push_data_R4_ret
e_2slash    ;------------------------------------------------------------------


            ; u.  ( x -- )  Display unsigned number
            DW   e_udot
            DB   2,"u."
c_udot      PHL
            JSR  print_unsigned
            JMP  p_space_rts
e_udot      ;------------------------------------------------------------------


            ; cr ( -- )  Print CR and LF
            DW   e_cr
            DB   2,"cr"
c_cr        JMP  print_nl
e_cr        ;------------------------------------------------------------------


            ; ."  Print a string
            DW   e_prstr
            DB   2+FL_IMMEDIATE,".",0x22
c_prstr     LD   R7_L,#<print_str
            LD   R7_H,#>print_str
_prstr_common:  ;common code for storing and printing a string or testing for abort
            PHL
            PSH  CP_L
            PSH  CP_H
            TST  STATE
            JPF  _ccprstr04
            LDA  #OPCODE_JMP
            JSR  add_JmpOrJsr
            ;copy all characters, stop at ["] or [)]
_ccprstr04  JSR  ld_ptr_inptr
_ccprstr01  JSR  lap_incptr_qchk
            CMP  #0x22 ; "
            JPF  _ccprstr03
            JSR  _cpremit
            JMP  _ccprstr01
_ccprstr03  ; " found and remove it from the input buffer
            JSR  ld_inptr_ptr
            JSR  pop_ptr  ;get CP from stack
            ;quit here if in interpreter mode
            TST  STATE
            JPF  return
            ;write terminating zero
            LDA  #0
            JSR  emit_code
            ;set target address for jmp instruction
            JSR__inc_ptr
            LDA  CP_L
            JSR__sap_inc_ptr
            LDA  CP_H
            JSR__sap_inc_ptr
            JSR  psh_ptr
            JSR  emit_code_ldi
            LDA  #PTR_H
            JSR  emit_code
            POP
            JSR  emit_code
            JSR  emit_code_ldi
            LDA  #PTR_L
            JSR  emit_code
            POP
            JSR  emit_code
            LDA  #OPCODE_JSR
            JMP  emit_opaadr_ret
_cpremit    TST  STATE
            JNF  emit_code
            JMP  print_char
e_prstr     ;------------------------------------------------------------------


            ; .(  Print a string immediately
            DW   e_dotparen
            DB   2+FL_IMMEDIATE,".("
c_dotparen  PHL
            LDA  #')'
            JSR  push_data_accu
            JSR  c_parse
            JMP  _c_type_ret
e_dotparen  ;------------------------------------------------------------------


            ; s"  ( -- addr len )  Insert string and return address and length on stack
            DW   e_squote
            DB   2+FL_IMMEDIATE,"s",0x22
c_squote    PHL
            ;emit code that jumps over the string
            JSR  scquote_cm1
            ;copy the string into memory
            JSR  scquote_cm2
scquote_cm3 ;emit code that pushes the string length to the stack
            LD   R4_L,R5_L
            LD   R4_H,#0
            TST  STATE
            JPF  push_data_R4_ret   ; in interpreter mode simply put the string length onto the stack
            JMP  add_16bit_literal_ret
scquote_cm1 ;common code1 for c", s" and s\"
            PHL
            LD   MATH_BUF+0,CP_L
            LD   MATH_BUF+1,CP_H
            LDA  #OPCODE_JMP
            JSR  emit_code
            LD   R6_L,CP_L
            LD   R6_H,CP_H
            JSR  emit_code
            JSR  emit_code
            JSR  ld_r4_cp
            RTS
scquote_cm2 ;common code2 for c" and s"
            PHL
            LD   R5_L,#0
            ;copy all characters, stop at ["]
            JSR  ld_ptr_inptr
_csqcp01    JSR  lap_incptr_qchk
            CMP  #0x22
            JPF  scquote_cm4
            JSR  emit_code
            INC  R5_L
            JMP  _csqcp01
scquote_cm4 ; " found and remove it from the input buffer
            JSR  ld_inptr_ptr
            ;set jump address
            JSR  ld_ptr_r6
            LDA  CP_L
            JSR__sap_inc_ptr
            LDA  CP_H
            SAP
            ;test compilation state, restore CP if in interpreter state and push ptr to string onto stack
            TST  STATE
            JNF  add_16bit_literal_ret  ;emit code that pushes the string address to the stack
            LD   CP_L,MATH_BUF+0
            LD   CP_H,MATH_BUF+1
            JMP__push_data_R4_ret
lap_incptr_qchk:
            PHL
            JSR__lap_inc_ptr
            TST
            JPF  Error_Quote
            RTS
e_squote    ;------------------------------------------------------------------


            ; c"  ( -- addr )  Insert a counted string and return address on stack
            DW   e_cquote
            DB   2+FL_IMMEDIATE,"c",0x22
c_cquote    PHL
            ;emit code that jumps over the string
            JSR  scquote_cm1
            JSR  emit_code    ;place holder for string length
            ;copy the string into memory and do some more, share code with s"
            JSR  scquote_cm2
            ;store string length
            JSR  ld_ptr_r4
            LDA  R5_L
            SAP
            RTS
e_cquote    ;------------------------------------------------------------------


            ; IF  (x -- )  Begin an IF-ELSE-THEN construct
            DW   e_if
            DB   2+FL_IMMEDIATE,"if"
c_if        LD   R7_L,#<if_check
            LD   R7_H,#>if_check
_c_ifof     PHL
            JSR  emit_jsr
            LDA  #OPCODE_JPF
            JSR  emit_code
            JSR  ccfs_push_cp
            JMP  _c_do_2
e_if        ;------------------------------------------------------------------


            ; DO  ( end idx -- )  Start a definite loop
            DW   e_do
            DB   2+FL_IMMEDIATE,"do"
c_do        LD   R7_L,#<do_code
            LD   R7_H,#>do_code
_c_do_1     PHL
            JSR  emit_jsr
            LDA  #OPCODE_JNF  ; insert an conditional jump to the code behind DO
            JSR  emit_code
            LDA  #5
            AD   CP_L
            STA  R4_L
            LDA  #0
            ADD  CP_H
            STA  R4_H
            JSR  emit_code_R4L
            LDA  R4_H
            JSR  emit_code
            LDA  #OPCODE_JMP  ; insert an unconditional jump to the word behind the loop word
            JSR  emit_code
            JSR  ld_r4_cp
            JSR  lcfs_push
_c_do_2     JSR  inc_cp
            JSR  inc_cp
            RTS
e_do        ;------------------------------------------------------------------


            ; C!  ( char c-addr -- )  Store one byte ('character') at addr
            DW   e_cstore
            DB   2,"c!"
c_cstore    PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
            PLD  R4
#else
            JSR__pop_data_R5_R4
            JSR  ld_ptr_r5
#endif
            LDA  R4_L
            SAP
            RTS
e_cstore    ;------------------------------------------------------------------


            ; C,  ( char -- )  Reserve space for one character in the data space and store char in the space.
            DW   e_ccomma
            DB   2,"c,"
c_ccomma    PHL
            JSR__pop_data_R4
            LDA  R4_L
            JMP  emit_code_ret
e_ccomma    ;------------------------------------------------------------------


            ; C@  ( c-addr -- char )  Fetch the character stored at c-addr.
            DW   e_c_at
            DB   2,"c@"
c_c_at      PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
            LAP
            JMP  push_data_accu_ret
e_c_at      ;------------------------------------------------------------------


            ; 2!  ( x1 x2 a-addr -- )   Store the cell pair x1 x2 at a-addr, with x2 at a-addr and x1 at the next consecutive cell.
            DW   e_2store
            DB   2,"2!"
c_2store    PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
_c_2store_1 JSR__pop_data_R4
            LDA  R4_L
            JSR__sap_inc_ptr
            LDA  R4_H
            JSR__sap_inc_ptr
_c_2store_2 JSR__pop_data_R4
            JMP  _c_store_2
e_2store    ;------------------------------------------------------------------


            ; 2@  ( a-addr -- x1 x2 )  Fetch the cell pair x1 x2 stored at a-addr. x2 is stored at a-addr and x1 at the next consecutive cell. 
            DW   e_2at
            DB   2,"2@"
c_2at       PHL
            JSR__pop_data_R4
_c_2at_1    JSR  ld_ptr_r4
            JSR__lap_inc_ptr
            STA  R5_L
            JSR__lap_inc_ptr
            STA  R5_H
            JSR__lap_inc_ptr
            STA  R4_L
            LAP
            STA  R4_H
            JMP__push_data_R4_R5_ret
e_2at       ;------------------------------------------------------------------


            ; */  ( n1 n2 n3 -- n4 )  Multiply n1 by n2 producing the intermediate double-cell result d.
            DW   e_starsl
            DB   2,"*/"
c_starsl    PHL
            JSR__pop_data_R4
            LD   R6_L,R4_L
            LD   R6_H,R4_H
            JSR__pop_data_R4_R5
            JSR  multiply_s
            JSR  div_i32i16
            JMP__push_data_R4_ret
e_starsl    ;------------------------------------------------------------------


            ; M*  ( n1 n2 -- d )
            DW   e_mstar
            DB   2,"m*"
c_mstar     PHL
            JSR__pop_data_R4_R5
            JSR  multiply_s
            JMP__push_data_R4_R5_ret
e_mstar     ;------------------------------------------------------------------


            ; >R  ( x -- )  ( R:  -- x )  Move x to the return stack.
            DW   e_tor
            DB   2,">r"
c_tor       PHL
            JSR__pop_data_R4
            JSR  retstk_push
            RTS
e_tor       ;------------------------------------------------------------------


            ; R>  ( -- x )  ( R:  x -- )  Move x from the return stack to the data stack.
            DW   e_rfrom
            DB   2,"r>"
c_rfrom     PHL
            JSR  retstk_pop
            JMP__push_data_R4_ret
e_rfrom     ;------------------------------------------------------------------


            ; R@  ( -- x )  ( R:  x -- x )  Copy x from the return stack to the data stack.
            DW   e_rat
            DB   2,"r@"
c_rat       PHL
            JSR  retstk_pop
            JSR  retstk_push
            JMP__push_data_R4_ret
e_rat       ;------------------------------------------------------------------


            ; OF  ( x1 x2 --   | x1 )
            DW   e_of
            DB   2+FL_IMMEDIATE,"of"
c_of        LD   R7_L,#<of_check
            LD   R7_H,#>of_check
            JMP  _c_ifof
e_of        ;------------------------------------------------------------------


            ; <#
            DW   e_lns
            DB   2,"<#"
c_lns       LD   NB_L,#<(NUM_BUF+NUMBUF_SZ)
            LD   NB_H,#>NUM_BUF
            RET
e_lns       ;------------------------------------------------------------------


            ; #>  ( xd -- c-addr u )
            DW   e_nsg
            DB   2,"#>"
c_nsg       PHL
            JSR__pop_data_R4_R5
            LD   R4_L,NB_L
            LD   R4_H,NB_H
            JSR__push_data_R4
            LDA  #<(NUM_BUF+NUMBUF_SZ)
            SU   NB_L
            JMP  push_data_accu_ret
e_nsg       ;------------------------------------------------------------------


            ; #S  ( ud1 -- ud2 )  Formatted number output.
            DW   e_nss
            DB   2,"#s"
c_nss       PHL
            JSR__pop_data_R5_R4
_c_nss1     LD   R6_L,BASE
            LD   R6_H,BASE+1
            JSR  div_u32u16
            LDA  #<tab_num2asc
            OR   R6_L
            STA  PTR_L
            LD   PTR_H,#>tab_num2asc
            LAP
            JSR  _outnumchr
            TST  R4_L
            JNF  _c_nss1
            TST  R4_H
            JNF  _c_nss1
            TST  R5_L
            JNF  _c_nss1
            TST  R5_H
            JNF  _c_nss1
            JMP__push_data_R4_R5_ret
e_nss       ;------------------------------------------------------------------


            ; .R  ( n1 n2 -- )  Display n1 right aligned in a field n2 characters wide.
            DW   e_dotr
            DB   2,".r"
c_dotr      PHL
            JSR__pop_data_R5_R4
            LDA  R4_H ; get the sign
            STA  R0  
            ROL
            JNF  _c_dotr1
            JSR  inv_r4
            JSR  inc_r4
_c_dotr1    JSR__push_data_R4
            ;R5_L = aligned length
            ;R0.7 = sign
            JMP  _c_udotri   ;use 2nd half of U.R
e_dotr      ;------------------------------------------------------------------


            ; D.  ( d -- )  Display d in free field format.
            DW   e_ddot
            DB   2,"d."
c_ddot      PHL
            ;TUCK DABS <#  #S ROT SIGN  #>  TYPE SPACE
            JSR  c_tuck
            JSR  c_dabs
            JSR  c_lns
            JSR  c_nss
            JSR  c_rot
            JSR  c_sign
            JSR  c_nsg
            JSR  c_type
            JMP  p_space_rts
e_ddot      ;------------------------------------------------------------------


            ; D+  ( d1|ud1 d2|ud2 -- d3|ud3 )   Add d2|ud2 to d1|ud1, giving the sum d3|ud3.
            DW   e_sum32
            DB   2,"d+"
c_sum32     PHL
            JSR  _popBufpop
_c_sum321   LDA  LIB_BUF+0
            AD   R4_L
            STA  R4_L
            LDA  LIB_BUF+1
            ADD  R4_H
            STA  R4_H
            LDA  LIB_BUF+2
            ADD  R5_L
            STA  R5_L
            LDA  LIB_BUF+3
            ADD  R5_H
            STA  R5_H
            JMP__push_data_R4_R5_ret
_popBufpop  PHL
            JSR__pop_data_R5_R4
            LD   LIB_BUF+0,R4_L
            LD   LIB_BUF+1,R4_H
            LD   LIB_BUF+2,R5_L
            LD   LIB_BUF+3,R5_H
            JSR__pop_data_R5_R4
            RTS
e_sum32     ;------------------------------------------------------------------


            ; M+  ( d1|ud1 n -- d2|ud2 )   Add n to d1|ud1, giving the sum d2|ud2.
            DW   e_msum32
            DB   2,"m+"
c_msum32    PHL
            JSR__pop_data_R4
            LD   LIB_BUF+0,R4_L
            LD   LIB_BUF+1,R4_H
            LDA  #0
            ROL  R4_H
            JNF  _c_msum321
            DEC
_c_msum321  STA  LIB_BUF+2
            STA  LIB_BUF+3
            JSR__pop_data_R5_R4
            JMP  _c_sum321
e_msum32    ;------------------------------------------------------------------


            ; D-  ( d1|ud1 d2|ud2 -- d3|ud3 )   Subtract d2|ud2 from d1|ud1, giving the difference d3|ud3.
            DW   e_sub32
            DB   2,"d-"
c_sub32     PHL
            LD   R0,#0
            JSR  _c_sub32
            JMP__push_data_R4_R5_ret
_c_sub32    PHL
            JSR  _popBufpop
            TST  R0
            JPF  _c_sub321
            ROL  LIB_BUF+3
            INC  FLAG
            ROR  LIB_BUF+3
            ROL  R5_H
            INC  FLAG
            ROR  R5_H
_c_sub321   LDA  R4_L
            SU   LIB_BUF+0
            STA  R4_L
            LDA  R4_H
            SUB  LIB_BUF+1
            STA  R4_H
            LDA  R5_L
            SUB  LIB_BUF+2
            STA  R5_L
            LDA  R5_H
            SUB  LIB_BUF+3
            STA  R5_H
            RTS
e_sub32     ;------------------------------------------------------------------


            ; D<  ( d1 d2 -- flag )  flag is true if and only if d1 is less than d2.
            DW   e_dless
            DB   2,"d<"
c_dless     PHL
            LD   R0,#1
            JSR  _c_sub32
            JMP  _c_noteq_1
e_dless     ;------------------------------------------------------------------


            ; D=  ( d1 d2 -- flag )  flag is true if and only if d1 is bit-for-bit the same as d2.
            DW   e_dequals
            DB   2,"d="
c_dequals   PHL
            JSR  _popBufpop
            LDA  LIB_BUF+0
            CMP  R4_L
            JNF  ret_false
            LDA  LIB_BUF+1
            CMP  R4_H
            JNF  ret_false
            LDA  LIB_BUF+2
            CMP  R5_L
            JNF  ret_false
            LDA  LIB_BUF+3
            JMP  _c_equal_2
e_dequals   ;------------------------------------------------------------------


            ; TO  ( x "<spaces>name" -- )
            DW   e_to
            DB   2+FL_IMMEDIATE,"to"
c_to        PHL
            JSR  c_tick
            JSR  c_tobody
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
            JSR__lap_inc_ptr
            TST  STATE
            JPF  _c_to_1
            ;compilation mode
            PSH
            JSR  ld_r4_ptr
            JSR  add_16bit_literal
            POP
            LD   PTR_L,#<c_2store
            LD   PTR_H,#>c_2store
            TST
            JNF  add_word_call_ret ;store 32-bit value
            LD   PTR_L,#<c_store
            LD   PTR_H,#>c_store
            JMP  add_word_call_ret ;store 16-bit value
_c_to_1     ;interpretation mode
            TST
            JNF  _c_2store_1 ;32-bit value
            JMP  _c_2store_2 ;16-bit value
e_to        ;------------------------------------------------------------------


            ; IS  ( xt "<spaces>name" -- )
            DW   e_is
            DB   2+FL_IMMEDIATE,"is"
c_is        PHL
            JSR  c_tick
            TST  STATE
            JPF  _c_defstor  ;interpretation mode
            ;compilation mode
            JSR  c_literal
            LD   PTR_L,#<c_deferstor
            LD   PTR_H,#>c_deferstor
            JMP  add_word_call_ret
e_is        ;------------------------------------------------------------------


            ; MS  ( milliseconds -- , delay )   delays for some milliseconds
            DW   e_ms
            DB   2,"ms"
c_ms        PHL
            JSR__pop_data_R4
            LDA  R4_L
            TST
            JPF  _cmsec2
_cmsec1     JSR  delay_ms
_cmsec2     TST  R4_H
            DEC  R4_H
            JNF  _cmsec1
            RTS
e_ms        ;------------------------------------------------------------------


            ; UP
            DW   e_up
            DB   2,"up"
c_up        LD   R4_L,#UP_L
            LD   R4_H,#REGPAGE_HI
            JMP__push_data_R4
e_up        ;------------------------------------------------------------------


            ; .s  ; print stack content, but leave stack unchanged
            DW   e_dots
            DB   2,".s"
c_dots      PHL
            LDA  #'<'
            JSR  print_char
            JSR  c_depth
            JSR  print_integer
            LDA  #'>'
            JSR  print_char
            LD   PTR_L,#0
            LD   PTR_H,#>STACK
_cdots2     LDA  fPSP
            CMP  PTR_L
            JPF  p_space_rts
            JSR__lap_inc_ptr
            STA  R4_L
            JSR__lap_inc_ptr
            STA  R4_H
            JSR  psh_ptr
            JSR__push_data_R4
            JSR  print_space
            JSR  print_integer
            JSR  pop_ptr
            JMP  _cdots2
e_dots      ;------------------------------------------------------------------


            ; BL
            DW   e_bl
            DB   2,"bl"
c_bl        PHL
            LDA  #32
            JMP  push_data_accu_ret
e_bl        ;------------------------------------------------------------------

#ifdef FAST_DSTACK
 
#ifndef NO_BLOCK_WORDS
            ; FH ( offset -- offset-block) "from here"
            DW   e_fh
            DB   2,"fh"
c_fh        PHL
			JSR  test_blk
			JPF  fh_scr	; if blk=0, push scr; else push blk
			PHD  BLK
			JMP  _c_sum16
fh_scr		PHD  SCR			
            JMP  _c_sum16
e_fh        ;------------------------------------------------------------------
#endif	; NO_BLOCK_WORDS

#endif	; FAST_DSTACK

#endif ;WORDS_LEN_2


;------------------------------------------------------------------------------
;  Words with names that have a length of 3 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_3

            ; dup ( x -- x x )
            DW   e_dup
            DB   3,"dup"
c_dup
#ifdef FAST_DSTACK
            PLD  R4
            PHD  R4
            PHD  R4
            RET
#else
            PHL
            JSR__pop_data_R4
#endif
_c_dup_1    JSR__push_data_R4
            JMP__push_data_R4_ret
e_dup       ;------------------------------------------------------------------


            ; rot ( x1 x2 x3 -- x2 x3 x1 )
            DW   e_rot
            DB   3,"rot"
c_rot
#ifdef FAST_DSTACK
            PLD  R4
            PLD  R5
            PLD  R6
            PHD  R5
            PHD  R4
            PHD  R6
            RET
#else
            PHL
            JSR__pop_data_R4
            JSR  psh_r4
            JSR__pop_data_R4_R5
            JSR__push_data_R4
            JSR  pop_r4
            JMP__push_data_R4_R5_ret
#endif
e_rot       ;------------------------------------------------------------------


            ; 0<>  ( x -- flag )  0 if top of stack is 0, -1 otherwise
            DW   e_testn0
            DB   3,"0<>"
c_testn0    PHL
            JSR__pop_data_R4
            TST  R4_L
            JNF  ret_true
            TST  R4_H
            JMP  _c_noteq_1
e_testn0    ;------------------------------------------------------------------


            ; mod  ( n1 n2 -- n3 )  Divide the two numbers at the top of the stack and return the reminder
            DW   e_mod16
            DB   3,"mod"
c_mod16     PHL
            JSR  c_dmod16
            JSR__pop_data_R4
            RTS
e_mod16     ;------------------------------------------------------------------


            ; um*  ( u1 u2 -- ud )  Multiply u1 by u2, giving the unsigned double-cell product ud.
            DW   e_umstar
            DB   3,"um*"
c_umstar    PHL
            JSR__pop_data_R4_R5
            JSR  multiply_u
            JMP__push_data_R4_R5_ret
e_umstar    ;------------------------------------------------------------------


            ; abs ( n -- u )  u is the absolute value of n
            DW   e_abs
            DB   3,"abs"
c_abs       PHL
            JSR__pop_data_R4
            LDA  R4_H
            ROL
            JPF  _c_negate_1
            JMP__push_data_R4_ret
e_abs       ;------------------------------------------------------------------


            ; and  ( x y -- z )  AND the two numbers at the top of the stack
            DW   e_and16
            DB   3,"and"
c_and16     PHL
            JSR__pop_data_R4_R5
            LDA  R4_L
            AND  R5_L
            STA  R4_L
            LDA  R4_H
            AND  R5_H
            JMP  _c_xor16_1
e_and16     ;------------------------------------------------------------------


            ; xor  ( x y -- z )  XOR the two numbers at the top of the stack
            DW   e_xor16
            DB   3,"xor"
c_xor16     PHL
            JSR__pop_data_R4_R5
            LDA  R4_L
            XOR  R5_L
            STA  R4_L
            LDA  R4_H
            XOR  R5_H
_c_xor16_1  STA  R4_H
            JMP__push_data_R4_ret
e_xor16     ;------------------------------------------------------------------


            ; key  ( -- x )  Read key stroke as ASCII character
            DW   e_key
            DB   3,"key"
c_key       PHL
            LDA  NEXTINCHR
            LD   NEXTINCHR,#0
            TST
            JNF  push_data_accu_ret
_ckey01     JSR  call_vect_input
            TST
            JPF  _ckey01
            JMP  push_data_accu_ret
e_key       ;------------------------------------------------------------------


            ; ?DO  ( end idx -- )  Start a definite loop
            DW   e_qmdo
            DB   3+FL_IMMEDIATE,"?do"
c_qmdo      LD   R7_L,#<qmdo_code
            LD   R7_H,#>qmdo_code
            JMP  _c_do_1      ; share the rest of the code with c_do
e_qmdo      ;------------------------------------------------------------------


            ; [']  Interpret next word and compile its code address (create a literal)
            DW   e_brtick
            DB   3+FL_IMMEDIATE,"[']"
c_brtick    PHL
            JSR  search_word_ex
            JPF  Error_Word ;word not found
            JSR  ld_r4_ptr
            JMP  add_16bit_literal_ret
e_brtick    ;------------------------------------------------------------------


            ; min  ( n1 n2 -- n3 )
            DW   e_min
            DB   3,"min"
c_min       PHL
            JSR  _mmcompare
            JPF  push_data_R5_ret
            JMP__push_data_R4_ret
_mmcompare  PHL
            JSR__pop_data_R4_R5
            LDA  #0x80
            XOR  R4_H
            STA  R6_H
            LDA  #0x80
            XOR  R5_H
            STA  R7_H
            LDA  R4_L
            SU   R5_L
            LDA  R6_H
            SUB  R7_H
            RTS
e_min       ;------------------------------------------------------------------


            ; max  ( n1 n2 -- n3 )
            DW   e_max
            DB   3,"max"
c_max       PHL
            JSR  _mmcompare
            JNF  push_data_R5_ret
            JMP__push_data_R4_ret
e_max       ;------------------------------------------------------------------


            ; S>D  ( n -- d )  Convert the number n to the double-cell number d with the same numerical value.
            DW   e_stod
            DB   3,"s>d"
c_stod      PHL
            JSR__pop_data_R4
            JSR__push_data_R4
            ROL  R4_H
            JMP  _c_equal_1
e_stod      ;------------------------------------------------------------------


            ; NIP  ( x1 x2 -- x2 )
            DW   e_nip
            DB   3,"nip"
c_nip
#ifdef FAST_DSTACK
            PLD  R4
            PLD  R5
            PHD  R4
            RET
#else
            PHL
            JSR__pop_data_R4_R5
            JMP__push_data_R4_ret
#endif
e_nip       ;------------------------------------------------------------------


            ; 2>R  ( x1 x2 -- ) ( R:  -- x1 x2 )  Transfer cell pair x1 x2 to the return stack.
            DW   e_2tor
            DB   3,"2>r"
c_2tor      PHL
_c_2tor     JSR__pop_data_R5_R4
            JSR  retstk_push
            LD   R4_L,R5_L
            LD   R4_H,R5_H
            JSR  retstk_push
            RTS
e_2tor      ;------------------------------------------------------------------


            ; 2R>  ( -- x1 x2 )  ( R:  x1 x2 -- )  Transfer cell pair x1 x2 from the return stack.
            DW   e_2rfrom
            DB   3,"2r>"
c_2rfrom    PHL
            JSR  retstk_pop
            LD   R5_L,R4_L
            LD   R5_H,R4_H
            JSR  retstk_pop
            JMP__push_data_R4_R5_ret
e_2rfrom    ;------------------------------------------------------------------


            ; 2R@  ( -- x1 x2 )  ( R:  x1 x2 -- x1 x2 )  Copy cell pair x1 x2 from the return stack.
            DW   e_2rat
            DB   3,"2r@"
c_2rat      PHL
            JSR  c_2rfrom
            JSR  c_2dup
            JMP  _c_2tor
e_2rat      ;------------------------------------------------------------------


            ; U.R  ( u n -- )  Display u right aligned in a field n characters wide.
            DW   e_udotr
            DB   3,"u.r"
c_udotr     PHL
            JSR__pop_data_R5
            LD   R0,#0
_c_udotri   JSR  push_data_zero
            ;R5_L = aligned length
            ;R0.7 = sign
            PSH  R5_L
_c_udotrd   PSH  R0
            JSR  c_lns
            JSR  c_nss
            POP  R0
            ROL  R0
            JNF  _c_udotr3
            LDA  #'-'
            JSR  _outnumchr
_c_udotr3   LDA  #<(NUM_BUF+NUMBUF_SZ)
            SU   NB_L
            STA  R0
            POP
            SU   R0
            JNF  _c_udotr1
            STA  R0
            LDA  #0x20
_c_udotr2   TST  R0
            JPF  _c_udotr1
            JSR  _outnumchr
            DEC  R0
            JMP  _c_udotr2
_c_udotr1   JSR  c_nsg
            JMP  _c_type_ret
e_udotr     ;------------------------------------------------------------------


            ; D.R  ( d n -- )  Display d right aligned in a field n characters wide.
            DW   e_ddotr
            DB   3,"d.r"
c_ddotr     PHL
            JSR__pop_data_R4
            PSH  R4_L  ;aligned length on stack
            JSR__pop_data_R5_R4
            LDA  R5_H ; get the sign
            STA  R0  
            ROL
            JNF  _c_ddotr1
            JSR  negate_R45
_c_ddotr1   JSR__push_data_R4
            JSR__push_data_R5
            ;stack = aligned length
            ;R0.7 = sign
            JMP  _c_udotrd   ;use 2nd half of U.R
e_ddotr     ;------------------------------------------------------------------


            ; HEX  ( -- ) 
            DW   e_hex
            DB   3,"hex"
c_hex       LD   BASE,#16
_c_hex1     LD   BASE+1,#0
            RET
e_hex       ;------------------------------------------------------------------


            ; PAD  ( -- c-addr )  c-addr is the address of a transient region for temporary data
            DW   e_pad
            DB   3,"pad"
c_pad       LD   R4_L,#<PAD_MEMORY
            LD   R4_H,#>PAD_MEMORY
            JMP__push_data_R4
e_pad       ;------------------------------------------------------------------


            ; D0<  ( d -- flag )  flag is true if and only if d is less than zero.
            DW   e_d0less
            DB   3,"d0<"
c_d0less    PHL
            JSR__pop_data_R4_R5
            JMP  c_zeroless1
e_d0less    ;------------------------------------------------------------------


            ; D0=  ( d -- flag )  flag is true if and only if d is equal to zero.
            DW   e_d0equals
            DB   3,"d0="
c_d0equals  PHL
            JSR__pop_data_R4_R5
            TST  R5_L
            JNF  ret_false
            TST  R5_H
            JNF  ret_false
            JMP  _c_test01
e_d0equals  ;------------------------------------------------------------------


            ; DU<  ( ud1 ud2 -- flag )  flag is true if and only if ud1 is less than ud2.
            DW   e_duless
            DB   3,"du<"
c_duless    PHL
            LD   R0,#0
            JSR  _c_sub32
            JMP  _c_noteq_1
e_duless    ;------------------------------------------------------------------


            ; D2*  ( xd1 -- xd2 )  multiply xd1 with 2
            DW   e_d2star
            DB   3,"d2*"
c_d2star    PHL
            JSR__pop_data_R5_R4
            CLC
            RWL  R4
            RWL  R5
            JMP__push_data_R4_R5_ret
e_d2star    ;------------------------------------------------------------------


            ; D2/  ( xd1 -- xd2 )  divide xd1 by 2
            DW   e_d2slash
            DB   3,"d2/"
c_d2slash   PHL
            JSR__pop_data_R5_R4
            LDA  R5_H
            ROL
            ROR  R5_H
            ROR  R5_L
            ROR  R4_H
            ROR  R4_L
            JMP__push_data_R4_R5_ret
e_d2slash   ;------------------------------------------------------------------


            ; M*/  ( d1 n1 +n2 -- d2 )   d2 = (d1 * n1) / +n2
            DW   e_mstsl
            DB   3,"m*/"
c_mstsl     PHL
#ifdef FAST_DSTACK
			PLD  LIB_BUF+8	; +n2
			JSR  c_over
			JSR  c_over			
			JSR  c_xor16
			PLD  LIB_BUF+10	; sign
			JSR  c_abs
			JSR  c_mrot
			JSR  c_dabs
			JSR  c_rot
			
			; T* ( ud un -- ut ) with triple-cell intermediate result
			JSR  c_dup		; dup
			JSR  c_rot		; rot
			JSR  c_umstar	; um*
			PLD  LIB_BUF+4	; 2>r	um* uses LIB_BUF+0...+3
			PLD  LIB_BUF+6
            	
            JSR  c_umstar
            JSR  push_data_zero	; 0
            PHD  LIB_BUF+6	; 2r>
            PHD  LIB_BUF+4
			JSR  c_sum32	; d+
			; end t*

			; T/ ( ut un -- ud )
			PHD  LIB_BUF+8  ; +n2		UM/MOD uses LIB_BUF+0...+5
			JSR  c_umsmod	; UM/MOD
			JSR  c_swap		; swap
			
			JSR  c_rot		; rot
			JSR  push_data_zero	; 0
			PHD  LIB_BUF+8  ; +n2
			JSR  c_umsmod	; UM/MOD
			JSR  c_swap		; swap
			
			JSR  c_rot		; rot
			PHD  LIB_BUF+8  ; +n2
			JSR  c_umsmod	; UM/MOD
			JSR  c_swap		; swap
			PLD  R4			; drop
			
			JSR  push_data_zero	; 0
			JSR  c_2swap	; 2swap
			JSR  c_swap		; 2swap			
			JSR  c_sum32	; d+
			; end t/
			
			ROL  LIB_BUF+11	; get sgn bit
			JNF  _c_mstsl2
			JSR  c_dnegate
_c_mstsl2   RTS			
#else
			; Warning: the result of (d1 * n1) is only 32 bit!
            JSR__pop_data_R5_R4
            PSH  R5_L
            PSH  R5_H
            LD   R6_L,R4_L
            LD   R6_H,R4_H
            JSR__pop_data_R5_R4
            TST  R6_H
            JNF  _c_mstsl2
            LDA  R6_L
            CMP  #1
            JPF  _c_mstsl3
_c_mstsl2   JSR  mul32s
_c_mstsl3   POP  R6_H
            POP  R6_L
            TST  R6_H
            JNF  _c_mstsl1
            LDA  R6_L
            CMP  #1
            JPF  push_data_R4_R5_ret
_c_mstsl1   JSR  div_i32i16
            JMP__push_data_R4_R5_ret
#endif	; FAST_DSTACK            
e_mstsl     ;------------------------------------------------------------------


            ; D>S  ( d -- n )
            DW   e_dtos
            DB   3,"d>s"
c_dtos      JMP  pop_data_R4
e_dtos      ;------------------------------------------------------------------


#ifndef NO_BLOCK_WORDS
            ; BLK  ( -- addr )
            DW   e_blk
            DB   3,"blk"
c_blk       LD   R4_L,#BLK
            JMP  ret_regadr
e_blk       ;------------------------------------------------------------------


            ; SCR  ( -- addr )
            DW   e_scr
            DB   3,"scr"
c_scr       LD   R4_L,#SCR
            JMP  ret_regadr
e_scr       ;------------------------------------------------------------------
#endif


#ifndef ROM_16KB
            ; >IN  ( -- addr )
            DW   e_toin
            DB   3,">in"
c_toin      LD   R4_L,#INPTR
            JMP  ret_regadr
e_toin      ;------------------------------------------------------------------


            ; s\"  ( -- addr len )  Insert string and return address and length on stack
            DW   e_sbsquote
            DB   3+FL_IMMEDIATE,'s',92,34
c_sbsquote  PHL
            ;emit code that jumps over the string
            JSR  scquote_cm1
            ;copy the string into memory
            JSR  _sbsquote
            ;emit code that pushes the string length to the stack
            JMP  scquote_cm3
_sbsquote   ;parse and translate the input string, and emit it to the code section
            PHL
            LD   R5_L,#0
            ;copy all characters, stop at ["]
            JSR  ld_ptr_inptr
_csbsq01    JSR  lap_incptr_qchk
            CMP  #0x22
            JPF  scquote_cm4
            CMP  #92
            JNF  _csbsq02
            ;evaluate the escape sequence
            JSR  lap_incptr_qchk
            CMP  #92
            JPF  _csbsq02
            CMP  #0x22
            JPF  _csbsq02
            JSR  psh_ptr
            AND  #0x1F
            OR   #<tab_formatstr
            STA  PTR_L
            LD   PTR_H,#>tab_formatstr
            LAP
            JSR  pop_ptr
            CMP  #'n'
            JNF  _csbsq03
            LDA  #13
            JSR  emit_code
            INC  R5_L
            LDA  #10
_csbsq03    CMP  #'x'
            JNF  _csbsq02
            JSR  lap_incptr_qchk
            JSR  is_hexchar
            ROL
            ROL
            ROL
            ROL
            STA  R0
            JSR  lap_incptr_qchk
            JSR  is_hexchar
            OR   R0
_csbsq02    ;output the character
            JSR  emit_code
            INC  R5_L
            JMP  _csbsq01
e_sbsquote  ;------------------------------------------------------------------
#endif

#ifdef INCLUDE_OPTIONAL_PRIMITIVES

            ; sp@  ( -- sp )  Get pointer to top of data stack
            DW   e_getdstk
            DB   3,"sp@"
c_getdstk   LD   R4_L,fPSP
            LD   R4_H,#>DATA_STACK
            DEC  R4_L
            DEC  R4_L
            JMP__push_data_R4
e_getdstk   ;------------------------------------------------------------------


            ; rp@  ( -- rp )  Get pointer to top of return stack
            DW   e_getrstk
            DB   3,"rp@"
c_getrstk   LD   R4_L,RETSP
            LD   R4_H,#>RETURNSTACK
            DEC  R4_L   ;adjust R4_L so R4 points to real data in memory.
            DEC  R4_L
            JMP__push_data_R4
e_getrstk   ;------------------------------------------------------------------

#endif

#ifndef NO_BLOCK_WORDS
            ; --> Load next screen
            DW   e_lnextscr
            DB   3+FL_IMMEDIATE,"-->"
c_lnextscr  PHL
			JSR  c_refill
			JSR  c_drop
			RTS
e_lnextscr  ;------------------------------------------------------------------
#endif	; NO_BLOCK_WORDS




#endif ;WORDS_LEN_3


;------------------------------------------------------------------------------
;  Words with names that have a length of 4 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_4

            ; ?dup ( x -- 0 | x x )
            DW   e_qmdup
            DB   4,"?dup"
c_qmdup     PHL
            JSR__pop_data_R4
            TST  R4_L
            JNF  _c_dup_1
            TST  R4_H
            JNF  _c_dup_1
            JMP__push_data_R4_ret
e_qmdup     ;------------------------------------------------------------------


            ; 2dup ( x1 x2 -- x1 x2 x1 x2 )
            DW   e_2dup
            DB   4,"2dup"
c_2dup
#ifdef FAST_DSTACK
            PLD  R5
            PLD  R4
            PHD  R4
            PHD  R5
            PHD  R4
            PHD  R5
            RET
#else
            PHL
            JSR__pop_data_R5_R4
            JSR__push_data_R4
            JSR__push_data_R5
            JMP__push_data_R4_R5_ret
#endif
e_2dup      ;------------------------------------------------------------------


            ; over ( x1 x2 -- x1 x2 x1 )
            DW   e_over
            DB   4,"over"
c_over
#ifdef FAST_DSTACK
            PLD  R4
            PLD  R5
            PHD  R5
            PHD  R4
            PHD  R5
            RET
#else
            PHL
            LD   PTR_L,fPSP
            LD   PTR_H,#>DATA_STACK
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            JMP  c_at_ldret
#endif
e_over      ;------------------------------------------------------------------


            ; swap ( x1 x2 -- x2 x1 )
            DW   e_swap
            DB   4,"swap"
c_swap
#ifdef FAST_DSTACK
            PLD  R4
            PLD  R5
            PHD  R4
            PHD  R5
            RET
#else
            PHL
#endif
_c_swap     JSR__pop_data_R4_R5
            JMP__push_data_R4_R5_ret
e_swap      ;------------------------------------------------------------------


            ; drop ( x -- )
            DW   e_drop
            DB   4,"drop"
c_drop
#ifdef FAST_DSTACK
            PLD  R4
            RET
#else
            JMP__pop_data_R4
#endif
e_drop      ;------------------------------------------------------------------


            ; /mod  ( n1 n2 -- n3 n4 )  Divide the two numbers at the top of the stack with reminder
            DW   e_dmod16
            DB   4,"/mod"
c_dmod16    PHL
            JSR__pop_data_R5
            JSR  c_stod
            JMP  _csmsrem1
e_dmod16    ;------------------------------------------------------------------


            ; exit  ( r:addr -- )  Pop return stack and resume execution at addr
            DW   e_exit
            DB   4,"exit"
c_exit      RTS
e_exit      ;------------------------------------------------------------------


            ; emit  ( x -- )  Print low byte of x as an ASCII character
            DW   e_emit
            DB   4,"emit"
c_emit      PHL
            JSR__pop_data_R4
            LDA  R4_L
            JSR  print_char
            RTS
e_emit      ;------------------------------------------------------------------


            ; type  ( addr u -- )  display the character string specified by addr and u.
            DW   e_type
            DB   4,"type"
c_type      PHL
_c_type_ret JSR__pop_data_R5_R4
            JSR  ld_ptr_r4
            JMP  _ctype3
_ctype2     DEC  R5_H
_ctype1     DEC  R5_L
            JSR__lap_inc_ptr
            JSR  print_char
_ctype3     TST  R5_L
            JNF  _ctype1
            TST  R5_H
            JNF  _ctype2
            RTS 
e_type      ;------------------------------------------------------------------


            ; ELSE  ( -- )  Mid of an IF-ELSE-THEN construct
            DW   e_else
            DB   4+FL_IMMEDIATE,"else"
c_else      PHL
            LDA  #OPCODE_JMP
            JSR  emit_code
            JSR  ccfs_pop
            JSR  psh_r4
            JSR  ccfs_push_cp
            JSR  inc_cp
            JSR  inc_cp
_c_else1    JSR  pop_ptr
            JMP  _c_endcase2
e_else      ;------------------------------------------------------------------


            ; THEN  ( -- )  End an IF-ELSE-THEN construct
            DW   e_then
            DB   4+FL_IMMEDIATE,"then"
c_then      PHL
            JSR  ccfs_pop
            JMP  _c_endcase1
e_then      ;------------------------------------------------------------------


            ; LOOP
            DW   e_loop
            DB   4+FL_IMMEDIATE,"loop"
c_loop      ;insert code that calls the loop_code routine
            LD   R7_L,#<loop_code
            LD   R7_H,#>loop_code
_c_loop_1   PHL
            JSR  emit_jsr
            ;insert an conditional jump to the DO word, part 1
            LDA  #OPCODE_JNF
            JSR  emit_code
            ;get the pointer to DO from cfs stack
            JSR  lcfs_pop
            JSR  ld_ptr_r4
            ;patch the DO code, insert a pointer to behind this LOOP word (used for leaving the loop early)
            LD   R5_L,CP_L
            LD   R5_H,CP_H
            JSR  inc_r5
            JSR  inc_r5
            LDA  R5_L
            JSR__sap_inc_ptr
            LDA  R5_H
            JSR__sap_inc_ptr
            ;insert an conditional jump to the DO word, part 2
            JMP  emit_PTR_ret
e_loop      ;------------------------------------------------------------------


            ; TRUE  ( -- true )
            DW   e_true
            DB   4,"true"
c_true
#ifdef FAST_DSTACK
            LDA  #0xFF
            STA  FLAG
            PHD  ACCU
            RET
#else
            JMP  push_data_ffff
#endif
e_true      ;------------------------------------------------------------------


            ; TUCK  ( x1 x2 -- x2 x1 x2 )
            DW   e_tuck
            DB   4,"tuck"
c_tuck      PHL
            JSR__pop_data_R5_R4
            JSR__push_data_R5
            JMP__push_data_R4_R5_ret
e_tuck      ;------------------------------------------------------------------


            ; CASE
            DW   e_case
            DB   4+FL_IMMEDIATE,"case"
c_case      PHL
            LDA  #6
            AD   CP_L
            STA  R7_L
            LD   R7_H,CP_H
            JNF  _c_case01
            INC  R7_H
_c_case01   LDA  #OPCODE_JMP
            JSR  emit_opaadr  ; insert a JMP that jumps over the next jump
            JSR  ccfs_push_cp ; store current code address on control flow stack
            LDA  #OPCODE_JMP  ; insert a JMP that jumps behind the ENDCASE word
            JMP  emit_opaadr_ret
e_case      ;------------------------------------------------------------------


            ; SIGN  ( n -- )
            DW   e_sign
            DB   4,"sign"
c_sign      PHL
            JSR__pop_data_R4
            ROL  R4_H
            JNF  return
            LDA  #'-'
            JMP  _c_ns_1
e_sign      ;------------------------------------------------------------------


            ; HOLD  ( n -- )
            DW   e_hold
            DB   4,"hold"
c_hold      PHL
            JSR__pop_data_R4
            LDA  R4_L
            JMP  _c_ns_1
e_hold      ;------------------------------------------------------------------


            ; CHAR  ( -- char )  Place char, the value of the first character of name, on the stack.
            DW   e_char
            DB   4,"char"
c_char      PHL
            JSR  skipSpaces
            TST
            JPF  Error_Syntax
            STA  R4_L
_cchar02    JSR__inc_ptr_lap
            TST
            JPF  _cchar01
            CMP  #0x20
            JNF  _cchar02
_cchar01    JSR  ld_inptr_ptr
            JMP  push_data_R4L_ret
e_char      ;------------------------------------------------------------------


            ; DABS ( d -- ud )  ud is the absolute value of d
            DW   e_dabs
            DB   4,"dabs"
c_dabs      PHL
            JSR__pop_data_R5
            LDA  R5_H
            ROL
            JNF  push_data_R5_ret
_c_dabs1    JSR__pop_data_R4
            JSR  negate_R45
            JMP__push_data_R4_R5_ret
e_dabs      ;------------------------------------------------------------------


            ; 2ROT ( x1 x2 x3 x4 x5 x6 -- x3 x4 x5 x6 x1 x2 )
            DW   e_2rot
            DB   4,"2rot"
c_2rot      JMP  dstack_2rot
e_2rot      ;------------------------------------------------------------------


            ; FILL  ( c-addr u char -- )
            DW   e_fill
            DB   4,"fill"
c_fill      PHL
_c_fill     JSR__pop_data_R4
            PSH  R4_L            ;char
            JSR__pop_data_R5_R4  ;count, addr
            POP
_c_fill_4   JSR  ld_ptr_r4
            JMP  _c_fill_3
_c_fill_2   DEC  R5_H
_c_fill_1   DEC  R5_L
            JSR__sap_inc_ptr
_c_fill_3   TST  R5_L
            JNF  _c_fill_1
            TST  R5_H
            JNF  _c_fill_2
            RTS
e_fill      ;------------------------------------------------------------------


            ; MOVE  ( addr1 addr2 u -- )
            DW   e_move
            DB   4,"move"
c_move      PHL
            JSR__pop_data_R4
            LD   R6_L,R4_L
            LD   R6_H,R4_H
            JSR__pop_data_R5_R4
            JSR  memcpy
            RTS
e_move      ;------------------------------------------------------------------


            ; WORD ( char "<chars>ccc<char>" -- c-addr ) 
            DW   e_word
            DB   4,"word"
c_word      PHL
            JSR__pop_data_R5
            JSR  skipDelimiter		; added in accordance with A.6.2.2008 in Forth-2012 standard
            LD   R0,#0
            LD   R4_L,#<(WORD_BUF+1)
            LD   R4_H,#>(WORD_BUF+1)
_cword2     JSR  ld_ptr_inptr
            JSR__lap_inc_ptr
            TST
            JPF  _cword3
            JSR  ld_inptr_ptr
            CMP  R5_L
            JPF  _cword3
            JSR  ld_ptr_r4
            SAP
            JSR  inc_r4
            INC  R0
            JMP  _cword2
_cword3     JSR  ld_ptr_r4
            LDA  #0x20
            SAP
            LD   R4_L,#<WORD_BUF
            LD   R4_H,#>WORD_BUF
            JSR  ld_ptr_r4
            LDA  R0
            SAP
            JMP__push_data_R4_ret
e_word      ;------------------------------------------------------------------


            ; PICK  ( xu ... x1 x0 u -- xu ... x1 x0 xu )
            DW   e_pick
            DB   4,"pick"
c_pick      PHL
            JSR__pop_data_R5
            JSR  _c_pick1
            JMP__push_data_R4_ret  
_c_pick1    CLC
            ROL  R5_L
            LDA  fPSP
            SU   R5_L
            LD   PAR1,SP
            STA  SP
            POP  R4_H
            POP  R4_L
            LD   SP,PAR1
            RET
e_pick      ;------------------------------------------------------------------


            ; ROLL  ( xu xu-1 ... x0 u -- xu-1 ... x0 xu )
            DW   e_roll
            DB   4,"roll"
c_roll      PHL
            JSR__pop_data_R5
            JSR  _c_pick1
            TST  R5_L ; number of bytes to copy
            JPF  return
            STA  R1   ; ptr to source
            DEC
            DEC
            STA  R2   ; ptr to destination
            LD   PTR_H,#>STACK
_c_roll2    LD   PTR_L,R1
            LAP
            LD   PTR_L,R2
            SAP
            INC  R1
            INC  R2
            DEC  R5_L
_c_roll1    TST  R5_L
            JNF  _c_roll2
            DEC  fPSP
            DEC  fPSP
            JMP__push_data_R4_ret
e_roll      ;------------------------------------------------------------------


            ; QUIT
            DW   e_quit
            DB   4,"quit"
c_quit      JSR  print_nl
            JMP  abort_restart
e_quit      ;------------------------------------------------------------------

#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
            ; KEY?  ( -- flag )  If a character is available, return true.  Otherwise, return false.
            DW   e_keyqm
            DB   4,"key?"
c_keyqm     PHL
            TST  NEXTINCHR
            JNF  ret_true
            JSR  call_vect_input
            STA  NEXTINCHR
            TST
            JPF  ret_false
            JMP  ret_true
e_keyqm     ;------------------------------------------------------------------
#endif

            ; BASE
            DW   e_base
            DB   4,"base"
c_base      LD   R4_L,#<BASE
            JMP  ret_regadr
e_base      ;------------------------------------------------------------------


            ; HERE
            DW   e_here
            DB   4,"here"
c_here      PHL
            JSR  ld_r4_cp
            JMP__push_data_R4_ret
e_here      ;------------------------------------------------------------------


            ; PAGE ( -- )
            DW   e_page
            DB   4,"page"
c_page      JMP  display_clear
e_page      ;------------------------------------------------------------------

#ifndef ROM_16KB
            ;-ROT ( x1 x2 x3 -- x3 x1 x2 )
            DW   e_mrot
            DB   4,"-rot"
c_mrot
#ifdef FAST_DSTACK
            PLD  R4
            PLD  R5
            PLD  R6
            PHD  R4
            PHD  R6
            PHD  R5
            RET
#else
            PHL
            JSR__pop_data_R4_R5  ;x3,x2
            JSR  psh_r5 ;x2
            JSR__pop_data_R5  ;x1
            JSR__push_data_R4 ;x3
            JSR__push_data_R5 ;x1
            JSR  pop_r5 ;x2
            JMP__push_data_R5_ret
#endif
e_mrot      ;------------------------------------------------------------------
#endif

            ;CELL ( -- u )  Return the size of one cell
            DW   e_cell
            DB   4,"cell"
c_cell      PHL
            LDA  #2
            JMP  push_data_accu_ret
e_cell      ;------------------------------------------------------------------

#ifndef ROM_16KB
            ;DUMP (addr u -- )  Dump memory to screen
            DW   e_dump
            DB   4,"dump"
c_dump      PHL
            JSR  c_swap
            JSR__pop_data_R4_R5
            ;r5 = u, r4 = addr
#ifdef BETTER_DUMP

            LD  R7_H,#16 	;R7_H: bytes per line

#ifdef WITH_I2C_LCD_KYBD            
            LD   LIB_FIRSTLINE, #1		;LIB_FIRSTLINE=1: bypass first print_nl_w
            TST  LIB_LCDOUT
            JPF  _cdump04	;16 B/line for terminal, 8 B/line for LCD
            LD   R7_H,#8
            JSR  lcd_clear            
#endif   
            
            JMP  _cdump04
_cdump01    TST  R5_L
            JNF  _cdump02
            TST  R5_H
            JPF  _cdump08
_cdump07    DEC  R5_H
_cdump02    DEC  R5_L
            LDA  R0
            CMP  R7_H
            JNF  _cdump05
#ifndef WITH_I2C_LCD_KYBD
            JSR  print_nl
#else
            JSR  print_nl_w
#endif            
            JSR  print_hexword
            LDA  #':'
            JSR  print_char
            JSR  print_space
            PSH  R4_L
            PSH  R4_H
            LD   R2,#0
_cdump05    JSR  ld_ptr_r4
            JSR  inc_r4
            LAP
            INC  R2
            JSR  print_hexbyte
            JSR  print_space
            JLP  _cdump01
_cdump08    TST  R2
            JPF  printnl_rts
            POP  PTR_H
            POP  PTR_L
            LD   R1,R2
_cdump10    LDA  R7_H
            CMP  R1
            JPF  _cdump09
            INC  R1
            JSR  print_space
            JSR  print_space
            JSR  print_space
            JMP  _cdump10
_cdump09    JSR  print_space
            LD   R0,R2
_cdump06    JSR__lap_inc_ptr
            STA  R1
            SU   #0x20
            JNF  _cdump11
            LDA  #0x7E
            SU   R1
            JPF  _cdump12
_cdump11    LD   R1,#'.'
_cdump12    LDA  R1
            JSR  print_char
            JLP  _cdump06
_cdump04    LD   R2,#0
            LD   R0,R7_H
            TST  R5_L
            JNF  _cdump02
            TST  R5_H
            JNF  _cdump07
            
            
            
#else
_cdump04    LD   R0,#16
_cdump01    TST  R5_L
            JNF  _cdump02
            TST  R5_H
            JPF  printnl_rts
            DEC  R5_H
_cdump02    DEC  R5_L
            LDA  R0
            CMP  #16
            JNF  _cdump05
            JSR  print_nl
            JSR  print_hexword
            LDA  #':'
            JSR  print_char
            JSR  print_space
_cdump05    JSR  ld_ptr_r4
            JSR  inc_r4
            LAP
            JSR  print_hexbyte
            JSR  print_space
            JLP  _cdump01
            JMP  _cdump04
#endif

#ifndef WITH_I2C_LCD_KYBD
printnl_rts JSR  print_nl
            RTS
#else

printnl_rts JSR  kb_waitkey ; pause at end when using LCD
            JSR  print_nl
            RTS
#endif
            
e_dump      ;------------------------------------------------------------------


            ;FIND ( c-addr -- c-addr 0 | xt 1 | xt -1 )   Find the definition named in the counted string at c-addr. 
            DW   e_find
            DB   4,"find"
c_find      PHL
            JSR  push_inptr
            JSR__pop_data_R4
            JSR__push_data_R4
            JSR  ld_ptr_r4
            JSR__lap_inc_ptr
            JSR  ld_inptr_ptr
            STA  R1
            JSR  search_word
            JNF  _c_find01
            ;word not found
            JSR  pop_inptr
            JMP  ret_false   ; word not found, return "c-addr 0"
_c_find01   ;word found, PTR points to code section and R2 contains flags
            ;JSR  ld_r4_ptr
            JSR__pop_data_R5
            ;JSR__push_data_R4
            JSR__push_data_PTR
            JSR  pop_inptr
            ROL  R2
            JNF  ret_true     ; not an immediate word, return "xt -1"
            JSR  push_data_1  ; immediate word, return "xt 1"
            RTS
e_find      ;------------------------------------------------------------------


            ; dmin  ( d1 d2 -- d3 )
            DW   e_dmin
            DB   4,"dmin"
c_dmin      LD   R1,#0
_c_dmin_1   PHL
            JSR  c_2over
            JSR  c_2over
            LD   R0,#1
            JSR  _c_sub32
            LDA  FLAG
            XOR  R1
            STA  FLAG
            JNF  _c_dmin_2
            JSR  c_2swap
_c_dmin_2   JSR__pop_data_R4_R5
            RTS
e_dmin      ;------------------------------------------------------------------


            ; dmax  ( d1 d2 -- d3 )
            DW   e_dmax
            DB   4,"dmax"
c_dmax      LD   R1,#1
            JMP  _c_dmin_1
e_dmax      ;------------------------------------------------------------------

#endif ;!ROM_16KB
#endif ;WORDS_LEN_4


;------------------------------------------------------------------------------
;  Words with names that have a length of 5 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_5

            ; 2OVER ( x1 x2 x3 x4 -- x1 x2 x3 x4 x1 x2 )
            DW   e_2over
            DB   5,"2over"            
#ifdef FAST_DSTACK
c_2over     PLD  LIB_BUF+0	;x4
            PLD  LIB_BUF+2	;x3
            PLD  R5			;x2
            PLD  R4			;x1

            PHD  R4			;x1
            PHD  R5			;x2                        
            PHD  LIB_BUF+2	;x3
            PHD  LIB_BUF+0	;x4
            PHD  R4			;x1
            PHD  R5			;x2
            RET
#else
c_2over     PHL						; bug: no stack empty detect
            LD   PTR_L,fPSP
            LD   PTR_H,#>DATA_STACK
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            DEC  PTR_L
            JSR__lap_inc_ptr
            STA  R4_L
            JSR__lap_inc_ptr
            STA  R4_H
            JSR__push_data_R4
            JMP  c_at_ldret
#endif            
e_2over     ;------------------------------------------------------------------


            ; 2SWAP ( x1 x2 x3 x4 -- x3 x4 x1 x2 )
            DW   e_2swap
            DB   5,"2swap"
c_2swap     JMP  dstack_2swap
e_2swap     ;------------------------------------------------------------------


            ; 2DROP ( x1 x2 -- )
            DW   e_2drop
            DB   5,"2drop"
c_2drop     JMP  pop_data_R4_R5
e_2drop     ;------------------------------------------------------------------


            ; SPACE ( -- )  Print a space character
            DW   e_space
            DB   5,"space"
c_space     JMP  print_space
e_space     ;------------------------------------------------------------------


            ; CELL+  ( x -- z )  Advance the address x by the size of one cell
            DW   e_cellplus
            DB   5,"cell+"
c_cellplus  PHL
            JSR__pop_data_R4
            JSR  inc_r4
            JSR  inc_r4
            JMP__push_data_R4_ret
e_cellplus  ;------------------------------------------------------------------


            ; CELLS  ( x -- z )  Get storage size of x cells
            DW   e_cells
            DB   5,"cells"
c_cells     JMP  c_2star
e_cells     ;------------------------------------------------------------------


            ; ALLOT  ( x -- )  Reserve bytes in RAM at HERE
            DW   e_allot
            DB   5,"allot"
c_allot     PHL
_c_allot    JSR  c_dup
            JSR  c_unused
            JSR  c_ugrtrthan
            JSR__pop_data_R4
            TST  R4_H
            JNF  Error_Mem
            JSR__pop_data_R4
            LDA  CP_L
            AD   R4_L
            STA  CP_L
            LDA  CP_H
            ADD  R4_H
            STA  CP_H
            RTS
e_allot     ;------------------------------------------------------------------


            ; does>  The function of DOES> is to specify a run-time action for the "child" words of a defining word.
            DW   e_doesgt
            DB   5,"does>"
c_doesgt    ;drop return address because does> does not return (=do not save LR to stack)
            ;use the value in LR to jump to the code that follows the JSR call to does>
            LD   PTR_L,DOESH_L
            LD   PTR_H,DOESH_H
            PSH  LR_H
            PSH  LR_L
            LDA  #OPCODE_JMP
            JSR__sap_inc_ptr
            POP
            JSR__sap_inc_ptr
            POP
            SAP
            RTS
e_doesgt    ;------------------------------------------------------------------


            ; +LOOP
            DW   e_ploop
            DB   5+FL_IMMEDIATE,"+loop"
c_ploop     ;insert code that calls the loop_code routine
            LD   R7_L,#<ploop_code
            LD   R7_H,#>ploop_code
            JMP  _c_loop_1  ; share the rest of the code with c_loop
e_ploop     ;------------------------------------------------------------------


            ; LEAVE  Leave a loop
            DW   e_leave
            DB   5+FL_IMMEDIATE,"leave"
c_leave     PHL
            ;insert code that calls the c_unloop routine
            LD   R7_L,#<c_unloop
            LD   R7_H,#>c_unloop
            JSR  emit_jsr
            ;insert an unconditional jump to the word behind the loop word
            JSR  lcfs_pop
            JSR  lcfs_push
            LDA  #OPCODE_JMP
            JSR  emit_code
            JSR  dec_r4
            JMP  emit_R4_ret
e_leave     ;------------------------------------------------------------------


            ; BEGIN  ( -- )  Begin a program flow description
            DW   e_begin
            DB   5+FL_IMMEDIATE,"begin"
c_begin     JMP  ccfs_push_cp
e_begin     ;------------------------------------------------------------------


            ; AGAIN  ( -- )  Continue program execution at previous BEGIN
            DW   e_again
            DB   5+FL_IMMEDIATE,"again"
c_again     PHL
_c_again1   JSR  ccfs_pop
            LDA  #OPCODE_JMP
_c_again2   JSR  emit_code
            JMP  emit_R4_ret
e_again     ;------------------------------------------------------------------


            ; UNTIL  ( x -- )  If all bits of x are zero, continue execution at previous BEGIN
            DW   e_until
            DB   5+FL_IMMEDIATE,"until"
c_until     PHL
            LD   R7_L,#<until_code
            LD   R7_H,#>until_code
            JSR  emit_jsr
            JSR  ccfs_pop
            LDA  #OPCODE_JPF
            JMP  _c_again2
e_until     ;------------------------------------------------------------------


            ; WHILE  ( x -- )  If all bits of x are zero, continue execution after WHILE, otherwise leave the loop.
            DW   e_while
            DB   5+FL_IMMEDIATE,"while"
c_while     PHL
            LD   R7_L,#<until_code  ; share the until_code
            LD   R7_H,#>until_code
            JSR  emit_jsr
            LDA  #OPCODE_JPF
            JSR  emit_code
            JSR  ccfs_push_cp
            JMP  _c_do_2
e_while     ;------------------------------------------------------------------


            ; ENDOF  ( -- )  End an OF-ENDOF construct
            DW   e_endof
            DB   5+FL_IMMEDIATE,"endof"
c_endof     PHL
            JSR  ccfs_pop
            JSR  psh_r4
            JSR  ccfs_pop
            JSR  ccfs_push
            LDA  #OPCODE_JMP
            LD   R7_L,R4_L
            LD   R7_H,R4_H
            JSR  emit_opaadr
            JMP  _c_else1    ;share the rest of the code with ELSE
e_endof     ;------------------------------------------------------------------


            ; CHAR+  ( c-addr1 -- c-addr2 )
            DW   e_charplus
            DB   5,"char+"
c_charplus  PHL
            JSR__pop_data_R4
            JSR  inc_r4
            JMP__push_data_R4_ret
e_charplus  ;------------------------------------------------------------------


            ; CHARS  ( n1 -- n2 )
            DW   e_chars
            DB   5,"chars"
c_chars     RET
e_chars     ;------------------------------------------------------------------


            ; COUNT  ( c-addr1 -- c-addr2 u )
            DW   e_count
            DB   5,"count"
c_count     PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
            LAP
            STA  R5_L
            LD   R5_H,#0
#ifdef FAST_DSTACK            
            JSR__inc_ptr
            JMP__push_data_PTR_R5_ret
#else
            JSR  inc_r4
            JMP__push_data_R4_R5_ret
#endif            
e_count     ;------------------------------------------------------------------


            ; FALSE  ( -- false )
            DW   e_false
            DB   5,"false"
c_false
#ifdef FAST_DSTACK
            LDA  #0
            CLC
            PHD  ACCU
            RET
#else
            JMP  push_data_zero
#endif
e_false     ;------------------------------------------------------------------


            ; DEPTH  ( -- n )
            DW   e_depth
            DB   5,"depth"
c_depth     LD   R4_L,fPSP
            CLC
            ROR  R4_L
            LD   R4_H,#0
            JMP__push_data_R4
e_depth     ;------------------------------------------------------------------


            ; */MOD  ( n1 n2 n3 -- n4 n5 )
            DW   e_ssmod
            DB   5,"*/mod"
c_ssmod     PHL
            JSR__pop_data_R4
            LD   R6_L,R4_L
            LD   R6_H,R4_H
            JSR__pop_data_R4_R5
            JSR  multiply_s
            JSR  div_i32i16
            JSR  div_i32_crem
            LD   R5_L,R4_L
            LD   R5_H,R4_H
            LD   R4_L,R6_L
            LD   R4_H,R6_H
            JMP__push_data_R4_R5_ret
e_ssmod     ;------------------------------------------------------------------


            ; VALUE  ( x "<spaces>name" -- )
            DW   e_value
            DB   5,"value"
c_value     PHL
            JSR  c_create  ;VALUE is defined as ": VALUE CREATE , DOES> @ ;"
            LDA  #0        ;My4TH definition is ": VALUE CREATE 0 c, , DOES> @ ;"
            JSR  emit_code ;emit a flag-byte that shows the TO word that only one 16-bit value can be stored here
            JSR  c_comma
            JSR  c_doesgt
#ifdef FAST_DSTACK
            PLD  PTR_L
            JSR__inc_ptr
            JMP  c_at_ldret
#else
            JSR__pop_data_R4
            JSR  inc_r4
            JMP  c_at_ldpret
#endif
e_value     ;------------------------------------------------------------------


            ; ALIGN  ( -- )
            DW   e_align
            DB   5,"align"
c_align     RET
e_align     ;------------------------------------------------------------------


            ; ABORT  ( -- )
            DW   e_abort
            DB   5,"abort"
c_abort     PRINT text_abort
            JMP  abort_restart
e_abort     ;------------------------------------------------------------------


            ; WORDS  ( -- )
            DW   e_words
            DB   5,"words"
c_words     PHL
#ifdef WITH_I2C_LCD_KYBD
            LD   LIB_FIRSTLINE, #1		;LIB_FIRSTLINE=1: bypass first print_nl_w            
            JSR  lcd_clear_t
#endif   
;#if defined(PLATFORM_XS) && !defined(ROM_16KB)
            ;print list of words in ROM
            LD   R2,#100
            LD   R1,#1
_cwords01   JSR  chooseDictionary
            LAP
            STA  R6_L
            INC__PTR_L
            LAP
            STA  R6_H
            ;loop over all dictionary entries
            ;R6 points to the header of the current word.
_cwords02   JSR  ld_ptr_r6
            JSR__lap_inc_ptr
            STA  R6_L
            JSR__lap_inc_ptr
            STA  R6_H       ;R6: ptr to next entry in the dictionary
            JSR__lap_inc_ptr
            AND  #0x1F      ;mask out bits 5-7, they are FLAGs for other purposes
            STA  R0         ;string length
            TST  R0
            JPF   _cwords03 ;jump if end of dictionary
            LDA  PTR_H
            ROL
            JPF  _cwords02  ;skip all words in RAM
            JSR  _cwords15  ;print the word
            JMP  _cwords02
_cwords03   ;next dictionary
            INC  R1
            LDA  #9
            CMP  R1
            JNF  _cwords01
            ;----------------------------------------------
            ;Print list of words in RAM in the order they were defined by the user:
_cwords04   ;Walk through the whole dictionary. Look only for entries in RAM.
            ;Find the next entry, who's address is bigger than the last printed
            ;but is the lowest of the remaining addresses.
            ;R7: Address of last printed word. All new addresses must be higher.
            LD   R7_L,#0x00
            LD   R7_H,#0x80
_cwords06   ;Walk through the whole dictionary. Skip words in ROM.
            ;R6: smallest address in dictionary that is still higher than R7
            LD   R6_L,#0xFF
            LD   R6_H,#0xFF
            LD   R1,#0 ;flag: true if a word to print was found
            LD   R4_L,#<DICTA
            LD   R4_H,#REGPAGE_HI
_cwords07   JSR  ld_ptr_r4
            ;check if this dictionary pointer points into RAM
            JSR__lap_inc_ptr
            STA  R5_L
            LAP
            STA  R5_H
_cwords10   LDA  R5_H
            ROL
            JNF  _cwords11
            ;check if R5 < R6. 
            LDA  R5_L
            SU   R6_L
            LDA  R5_H
            SUB  R6_H
            JPF  _cwords08  ; jump if no
            ;check if R5 > R7. if yes, set R6 := R5 and R1 := true
            LDA  R7_L
            SU   R5_L
            LDA  R7_H
            SUB  R5_H
            JPF  _cwords08
            LD   R6_L,R5_L
            LD   R6_H,R5_H
            DEC  R1
_cwords08   ;move forward to next word in this chain of words
            JSR  ld_ptr_r5
            JSR__lap_inc_ptr
            STA  R5_L
            JSR__lap_inc_ptr
            STA  R5_H
            LAP
            TST
            JNF  _cwords10
_cwords11   ;next dictionary
            INC  R4_L
            INC  R4_L
            LDA  R4_L
            CMP  #<DICTA+16
            JNF  _cwords07
            ;check if there is a word to print
            TST  R1
            JPF  printnl_rts
            LD   R7_L,R6_L
            LD   R7_H,R6_H
            ;print the word pointed by R6
            JSR  ld_ptr_r6
            JSR__inc_ptr
            JSR__inc_ptr
            JSR__lap_inc_ptr
            AND  #0x1F
            STA  R0
            JSR  _cwords15
            ;next word
            JMP  _cwords06
_cwords15   ;print a word
            PHL
            ;start a new line if line is already too long
            LDA  LIB_DISPMAXX
            SU   R2
            JPF  _cwords12
            LD   R2,#18
#ifndef WITH_I2C_LCD_KYBD            
            JSR  print_nl
#else
            JSR  print_nl_w
#endif       
_cwords12   ;print the word
            JSR__lap_inc_ptr
            JSR  print_char
            INC  R2
            JLP  _cwords12
            JSR  print_space
            INC  R2
            RTS
#ifdef ROM_16KB
printnl_rts JSR  print_nl            
            RTS
#endif
e_words     ;------------------------------------------------------------------


            ; ERASE  ( addr u -- )
            DW   e_erase
            DB   5,"erase"
c_erase     PHL
            JSR__pop_data_R5_R4
            LDA  #0
            JMP  _c_fill_4
e_erase     ;------------------------------------------------------------------


            ; PARSE  ( char "ccc<char>" -- c-addr u )  Parse ccc delimited by the delimiter char.
            DW   e_parse
            DB   5,"parse"
c_parse     PHL
_c_parse    ; JSR  skipSpaces	; commented out in accordance with A.6.2.2008 in Forth-2012 standard
            JSR__pop_data_R5
            JSR  push_data_inptr
            LD   R0,#0
            JSR  ld_ptr_inptr
_c_parse1   LAP
            TST
            JPF  _c_parse3
            JSR__inc_ptr
            CMP  R5_L
            JPF  _c_parse2
            INC  R0
            JMP  _c_parse1
_c_parse3   LDA  R5_L
            CMP  #0x20
            JNF  Error_Syntax
_c_parse2   JSR  ld_inptr_ptr
            LDA  R0
            JMP  push_data_accu_ret
e_parse     ;------------------------------------------------------------------


            ; >BODY  ( xt -- a-addr )   a-addr is the data-field address corresponding to xt.
            DW   e_tobody
            DB   5,">body"
c_tobody    PHL
            LD   R4_L,#13  ;16
            LD   R4_H,#0
            JSR__push_data_R4
            JMP  _c_sum16
e_tobody    ;------------------------------------------------------------------


            ; STATE
            DW   e_state
            DB   5,"state"
c_state     LD   R4_L,#STATE
ret_regadr  LD   R4_H,#REGPAGE_HI
            JMP__push_data_R4
e_state     ;------------------------------------------------------------------


            ; DEFER  ( "name" -- )   create a deferred word
            DW   e_defer
            DB   5,"defer"
c_defer     PHL
            TST  STATE
            JNF  Error_Syntax
            JSR  begin_add_new_word
            LD   PTR_L,#<ret_opc
            LD   PTR_H,#>ret_opc
            LDA  #OPCODE_JMP
            JMP  add_JmpOrJsr_ret
e_defer     ;------------------------------------------------------------------


            ; AT-XY  ( xpos ypos -- )   set cursor to screen position
            DW   e_at_xy
            DB   5,"at-xy"
c_at_xy     PHL
            JSR__pop_data_R4_R5
            LD   R0,R5_L
            LD   R1,R4_L
_c_atxy_rts JSR  display_gotoxy
            RTS
e_at_xy     ;------------------------------------------------------------------


            ; HOLDS  ( c-addr u -- )
            DW   e_holds
            DB   5,"holds"
c_holds     PHL
            JSR__pop_data_R4
            JSR__push_data_R4
            PSH  R4_L
            JSR  c_sum16
_cholds01   POP
            TST
            JPF  _cholds02
            DEC
            PSH
            JSR  c_1minus
            JSR  c_dup
            JSR  c_at
            JSR  c_hold
            JMP  _cholds01
_cholds02   JSR__pop_data_R4      
            RTS
e_holds     ;------------------------------------------------------------------

#endif ;WORDS_LEN_5


;------------------------------------------------------------------------------
;  Words with names that have a length of 6 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_6

            ; negate ( x -- -x )  Negate the number on top of the stack
            DW   e_negate
            DB   6,"negate"
c_negate    PHL
            JSR__pop_data_R4
_c_negate_1 JSR  inv_r4
            JSR  inc_r4
            JMP__push_data_R4_ret
e_negate    ;------------------------------------------------------------------


            ; invert ( x -- -x )  Invert the number on top of the stack
            DW   e_invert
            DB   6,"invert"
c_invert    PHL
_c_invert   JSR__pop_data_R4
            JSR  inv_r4
            JMP__push_data_R4_ret
e_invert    ;------------------------------------------------------------------


            ; spaces ( x -- )  Print some space characters
            DW   e_spaces
            DB   6,"spaces"
c_spaces    PHL
            JSR__pop_data_R4
_c_space_2  TST  R4_L
            JNF  _c_space_1
            TST  R4_H
            JPF  return
_c_space_1  JSR  print_space
            JSR  dec_r4
            JNF  _c_space_2
e_spaces    ;------------------------------------------------------------------


            ; create  ( -- )  Create a new dictionary entry (for variables and data)
            DW   e_create
            DB   6,"create"
c_create    PHL
            JSR  begin_add_new_word
            JSR  add_word_entry_code
            JSR  write_create_code
            RTS
e_create    ;------------------------------------------------------------------


            ; UNLOOP  Remove one set of loop control parameters from the loop control flow stack
            DW   e_unloop
            DB   6,"unloop"
c_unloop    INC  LCFSP
            INC  LCFSP
            INC  LCFSP
            INC  LCFSP
            RET
e_unloop    ;------------------------------------------------------------------


            ; REPEAT  ( -- )  Continue program execution at previous BEGIN
            DW   e_repeat
            DB   6+FL_IMMEDIATE,"repeat"
c_repeat    PHL
            JSR  ccfs_pop
            JSR  ld_ptr_r4
            JSR  ld_r4_cp
            JSR  inc_r4
            JSR  inc_r4
            JSR  inc_r4
            LDA  R4_L
            JSR__sap_inc_ptr
            LDA  R4_H
            SAP
            JMP  _c_again1
e_repeat    ;------------------------------------------------------------------


            ; LSHIFT  ( x1 u -- x2 )   Perform a logical left shift of u bit-places on x1, giving x2.
            DW   e_lshift
            DB   6,"lshift"
c_lshift    PHL
            JSR__pop_data_R5_R4
_c_lshift_1 TST  R5_L
            JPF  push_data_R4_ret
            ;CLC
            ROL  R4_L
            ROL  R4_H
            DEC  R5_L
            JMP  _c_lshift_1
e_lshift    ;------------------------------------------------------------------


            ; RSHIFT  ( x1 u -- x2 )   Perform a logical right shift of u bit-places on x1, giving x2.
            DW   e_rshift
            DB   6,"rshift"
c_rshift    PHL
            JSR__pop_data_R5_R4
_c_rshift_1 TST  R5_L
            JPF  push_data_R4_ret
            ;CLC
            ROR  R4_H
            ROR  R4_L
            DEC  R5_L
            JMP  _c_rshift_1
e_rshift    ;------------------------------------------------------------------


            ; UM/MOD  ( ud u1 -- u2 u3 )   Divide ud by u1, giving the quotient u3 and the remainder u2.
            DW   e_umsmod
            DB   6,"um/mod"
c_umsmod    PHL
            JSR__pop_data_R4
            LD   R6_L,R4_L
            LD   R6_H,R4_H
            JSR__pop_data_R5_R4
            JSR  div_u32u16
_c_umsmod1  LD   R5_L,R6_L
            LD   R5_H,R6_H
pushR4R5ret JSR__push_data_R5
            JMP__push_data_R4_ret
e_umsmod    ;------------------------------------------------------------------


            ; SM/REM  ( d1 n1 -- n2 n3 )  Divide d1 by n1, giving the symmetric quotient n3 and the remainder n2.
            DW   e_smsrem
            DB   6,"sm/rem"
c_smsrem    PHL
            JSR__pop_data_R5
_csmsrem1   LD   R6_L,R5_L
            LD   R6_H,R5_H
            JSR__pop_data_R5_R4
            JSR  div_i32i16
            JSR  div_i32_crem
            JMP  _c_umsmod1
e_smsrem    ;------------------------------------------------------------------


            ; [CHAR]  ( -- char )  Place char, the value of the first character of name, on the stack.
            DW   e_brcharbr
            DB   6+FL_IMMEDIATE,"[char]"
c_brcharbr  PHL
            JSR  c_char
            JSR__pop_data_R4
            JMP  add_16bit_literal_ret
e_brcharbr  ;------------------------------------------------------------------


            ; FM/MOD  ( d1 n1 -- n2 n3 )  Divide d1 by n1, giving the floored quotient n3 and the remainder n2.
            DW   e_fmsrem
            DB   6,"fm/mod"
c_fmsrem    PHL
            JSR__pop_data_R4
            JSR__push_data_R4
            JSR  psh_r4   ;divisor on stack
            JSR  c_smsrem
            JSR  pop_r6
            JSR__pop_data_R4_R5  ;R4: quotient, R5: reminder
            LDA  R4_H
            ROL
            JNF  pushR4R5ret  ; positive result - do nothing
            LDA  R5_L
            OR   R5_H
            TST
            JPF  pushR4R5ret  ; no reminder - do nothing
            ;fix the result:  quotient -= 1, reminder += divisor
            JSR  dec_r4 ; decrement quotient
            ;add divisor to reminder
            LDA  R6_L
            AD   R5_L
            STA  R5_L
            LDA  R6_H
            ADD  R5_H
            STA  R5_H
            JMP  pushR4R5ret
e_fmsrem    ;------------------------------------------------------------------


            ; 2VALUE  ( x1 x2 "<spaces>name" -- )
            DW   e_2value
            DB   6,"2value"
c_2value    PHL
            JSR  c_create  ;VALUE is defined as ": VALUE CREATE , , DOES> 2@ ;"
            LDA  #1        ;My4TH definition is ": VALUE CREATE 1 c, , , DOES> 1+ 2@ ;"
            JSR  emit_code ;emit a flag-byte that shows the TO word that only one 16-bit value can be stored here
            JSR  c_comma
            JSR  c_comma
            JSR  c_doesgt
            JSR__pop_data_R4
            JSR  inc_r4
            JMP  _c_2at_1
e_2value    ;------------------------------------------------------------------


            ; ACCEPT  ( c-addr +n1 -- +n2 )
            DW   e_accept
            DB   6,"accept"
c_accept    PHL
            JSR__pop_data_R4
            JSR  inc_r4
            LD   R0,#80
            TST  R4_H
            JNF  _c_acpt01
            LDA  R4_L
            SUB  R0
            JPF  _c_acpt01
            LD   R0,R4_L
_c_acpt01   LD   R4_L,#<SYS_BUF
            LD   R4_H,#>SYS_BUF
            LD   R7_L,#0
            JSR  input_string
            LD   PTR_L,#<SYS_BUF
            LD   PTR_H,#>SYS_BUF
            JSR  strlen
            LD   R6_L,R0
            LD   R4_L,#<SYS_BUF
            LD   R4_H,#>SYS_BUF
            JSR__pop_data_R5
            JSR  memcpy_short
            LD   R4_L,R0
            LD   R4_H,#0
            JSR  push_data_R4_ret
e_accept    ;------------------------------------------------------------------


            ; ABORT"  Print a string and abort if flag is nonzero
            DW   e_abortq
            DB   6+FL_IMMEDIATE,"abort",0x22
c_abortq    TST  STATE
            JPF  abort_restart  ;quit here if in interpreter mode
            LD   R7_L,#<abort_code
            LD   R7_H,#>abort_code
            JMP  _prstr_common            
e_abortq    ;------------------------------------------------------------------


            ; UNUSED  ( -- u )  u is the amount of space remaining in the region addressed by HERE
            DW   e_unused
            DB   6,"unused"
c_unused    LDA  #<(HEAP_END+1)
            SU   CP_L
            STA  R4_L
            LDA  #>(HEAP_END+1)
            SUB  CP_H
            STA  R4_H
            JMP__push_data_R4
e_unused    ;------------------------------------------------------------------


            ; FORGET
            DW   e_forget
            DB   6,"forget"
c_forget    PHL
            JSR  search_word_ex
            JPF  Error_Word ;word not found
            LDA  R4_H
            ROL
            JNF  Error_Word ;word not found (in RAM)
_cforget    ;R4 = ptr to header (= memory barrier address, words at this and after this address will be deleted)
            ;re-set the "HERE" ptr to this address
            LD   CP_L,R4_L
            LD   CP_H,R4_H
            LD   R3,#DICTA
_c_forget1  ;do for all 8 dictionary pointers
            LD   PTR_L,R3
            LD   PTR_H,#>REGPAGE
            ;load current dictionary pointer into R5 and compare with R4
            JSR__lap_inc_ptr
            STA  R5_L
            SU   R4_L
            LAP
            STA  R5_H
            SUB  R4_H
            JNF  _c_forget2  ; jump if current pointer points to memory below the word that shall be deleted
            ;delete the word, unchain it from the dictionary pointer list
            JSR  ld_ptr_r5
            JSR__lap_inc_ptr
            STA  R6_L
            LAP
            STA  R6_H
            LD   PTR_L,R3
            LD   PTR_H,#>REGPAGE
            LDA  R6_L
            JSR__sap_inc_ptr
            LDA  R6_H
            SAP
            ;check this dictionary pointer again
            JMP  _c_forget1
_c_forget2  ;next dictionary pointer
            INC  R3
            INC  R3
            LDA  #DICTA+2*8
            CMP  R3
            JNF  _c_forget1
#ifdef NO_BLOCK_WORDS
            RTS
#else
            ;now check also the BLOCK structure to be sure
            JMP  _chk_bptr_1
#endif
e_forget    ;------------------------------------------------------------------


            ; DEFER!  ( xt xt-deferred -- )
            DW   e_deferstor
            DB   6,"defer!"
c_deferstor PHL
_c_defstor  JSR__pop_data_R5_R4 ; get ptr to deferred xt, and get ptr to new xt
            JSR  ld_ptr_r5
            JSR__inc_ptr
            JMP  _c_store_2
e_deferstor ;------------------------------------------------------------------


            ; DEFER@  ( xt-deferred -- xt )
            DW   e_deferld
            DB   6,"defer@"
c_deferld   PHL
_c_deferld  JSR__pop_data_R4
            JSR  inc_r4
            JMP  c_at_ldpret
e_deferld   ;------------------------------------------------------------------


            ; WITHIN  ( n low high -- flag )
            DW   e_within
            DB   6,"within"
c_within    PHL
_cwithin_rts
            ;implemented as " over - >r - r> u< "
            JSR__pop_data_R5_R4
            JSR  _subR5R4
            JSR  psh_r5
            JSR__pop_data_R5
            JSR  _subR5R4
            LD   R4_L,R5_L
            STA  R4_H
            JSR  pop_r5
            JMP  _c_lthan_2
_subR5R4    LDA  R5_L
            SU   R4_L
            STA  R5_L
            LDA  R5_H
            SUB  R4_H
            STA  R5_H
            RET
e_within    ;------------------------------------------------------------------


            ; MARKER  ( -- )
            DW   e_marker
            DB   6,"marker"
c_marker    PHL
            ;compile time
            JSR  begin_add_new_word
            JSR  ld_r4_cp
            JSR  add_word_entry_code
            JSR  add_16bit_literal
            LDA  #OPCODE_JMP
            LD   PTR_L,#<_cmarker01
            LD   PTR_H,#>_cmarker01
            JMP  add_JmpOrJsr_ret
_cmarker01  ;word run time
            ;find the beginning of the word in RAM
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif            
_cmarker02  JSR  dec_ptr
            LAP
            AND  #0x60
            TST
            JNF   _cmarker02
            JSR  dec_ptr
            JSR  dec_ptr
            JSR  ld_r4_ptr
            ;R4 points now to the beginning of the word in memory (the name length byte)
            JMP  _cforget
e_marker    ;------------------------------------------------------------------

#ifndef NO_BLOCK_WORDS
            ; SOURCE  ( -- c-addr u )   c-addr is the address of, and u is the number of characters in, the input buffer.
            ; Note: This is very special on My4TH. Because My4TH is really slow in addition, it internally never adds
            ; an index to a base address. So IN contains always an address and not an offset. Because of this,
            ; every buffer is assumed to begin at address 0x0000. Thus, when IN is assumed to contain an offset, and
            ; the buffer address is 0x0000, adding IN to 0x0000 results in the real address of the next character
            ; in the input buffer. Furthermore, the word SOURCE returns a virtual (and very large) size of the
            ; buffer (which starts virtually at address 0x0000). Subtracting IN from the buffer size gives the
            ; amount of unread characters in the input buffer.
            ; Note 2: If code is loaded from a BLOCK, this function will not return the size of the block buffer but
            ; the size of the line buffer where the currently executed line is stored in. This is because of speed
            ; and memory optimisation, the code is loaded line-by-line from the EEPROM into a temporary buffer before
            ; it is executed.
            DW   e_source
            DB   6,"source"
c_source    PHL
            JSR  push_data_zero
            JSR  ld_ptr_inptr
            JSR  strlen
            LDA  R0
            JSR  push_data_accu
            JSR  push_data_inptr
            JMP  _c_sum16
e_source    ;------------------------------------------------------------------


            ; REFILL  ( -- flag ) 
            DW   e_refill
            DB   6,"refill"
c_refill    PHL
            JSR  test_blk
            JPF  ret_false  ; can not refill other input sources than blocks
            LD   R4_L,BLK_L
            LD   R4_H,BLK_H
            JSR  inc_r4
            JSR  fblockToEepromAddr
            JPF  ret_false
            INC  REFILL
            JMP  ret_true
e_refill    ;------------------------------------------------------------------
#endif

#endif ;WORDS_LEN_6


;------------------------------------------------------------------------------
;  Words with names that have a length of 7 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_7

            ; EXECUTE ( xt -- )  Execute the token on stack
            DW   e_execute
            DB   7,"execute"
c_execute   PHL
            JSR__pop_data_R4
            LD   JSRSPACE+1,R4_L
            LD   JSRSPACE+2,R4_H
            JMP  JSRSPACE_JMP
e_execute   ;------------------------------------------------------------------


            ; LITERAL  ( x -- )
            DW   e_literal
            DB   7+FL_IMMEDIATE,"literal"
c_literal   PHL
            JSR__pop_data_R4
            JMP  add_16bit_literal_ret
e_literal   ;------------------------------------------------------------------


            ; ALIGNED  ( addr -- a-addr )
            DW   e_aligned
            DB   7,"aligned"
c_aligned   RET
e_aligned   ;------------------------------------------------------------------


            ; ENDCASE  ( x --  )
            DW   e_endcase
            DB   7+FL_IMMEDIATE,"endcase"
c_endcase   PHL
            LD   R7_L,#<pop_data_R4
            LD   R7_H,#>pop_data_R4
            JSR  emit_jsr   ; insert "JSR pop_data_R4" to remove the case selector from stack
            JSR  ccfs_pop   ; resolve the JMP target address in the CASE word
            JSR  inc_r4
_c_endcase1 JSR  ld_ptr_r4
_c_endcase2 LDA  CP_L
            JSR__sap_inc_ptr
            LDA  CP_H
            SAP
            RTS
e_endcase   ;------------------------------------------------------------------


            ; DECIMAL  ( -- ) 
            DW   e_decimal
            DB   7,"decimal"
c_decimal   LD   BASE,#10
            JMP  _c_hex1
e_decimal   ;------------------------------------------------------------------


            ; DNEGATE  ( d1 -- d2 )
            DW   e_dnegate
            DB   7,"dnegate"
c_dnegate   PHL
            JSR__pop_data_R5
            JMP  _c_dabs1
e_dnegate   ;------------------------------------------------------------------


            ; >NUMBER  ( ud1 c-addr1 u1 -- ud2 c-addr2 u2 )
            DW   e_tonumber
            DB   7,">number"
c_tonumber  PHL
            JSR__pop_data_R5_R4
            LD   R1,R5_L
            JSR  ld_ptr_r4  ; ptr to string
            JSR__pop_data_R5_R4 ; R4/R5 = double number accu
_c_tonmb01  TST  R1
            JPF  _c_tonmb02  ; end of conversion
            LAP
            JSR  char2binnum
            JNF  _c_tonmb02  ; end of conversion
            PSH
            DEC  R1
            JSR__inc_ptr
            LD   R6_L,BASE
            LD   R6_H,#0
            PSH  R1
            JSR  mul32u
            POP  R1
            POP
            AD   R4_L
            STA  R4_L
            JNF  _c_tonmb01
            INC  R4_H
            TST  R4_H
            JNF  _c_tonmb01
            JSR  inc_r5
            JMP  _c_tonmb01
_c_tonmb02  JSR__push_data_R4
            JSR__push_data_R5
            ;JSR  ld_r4_ptr
            LD   R5_L,R1
            LD   R5_H,#0
            ;JMP__push_data_R4_R5_ret
            JMP__push_data_PTR_R5_ret            
e_tonumber  ;------------------------------------------------------------------


            ; RECURSE  ( -- )
            DW   e_recurse
            DB   7+FL_IMMEDIATE,"recurse"
c_recurse   PHL
            LD   PTR_L,CW_L
            LD   PTR_H,CW_H
_c_recur1   JMP  add_word_call_ret
e_recurse   ;------------------------------------------------------------------


            ; :NONAME
            DW   e_cnoname
            DB   7+FL_IMMEDIATE,":noname"
c_cnoname   PHL
            TST  STATE
            JNF  Error_Syntax
            INC  STATE
            JSR  ld_r4_cp
            JSR  add_word_entry_code
            JMP__push_data_R4_ret
e_cnoname   ;------------------------------------------------------------------


            ; BUFFER:
            DW   e_cbufferc
            DB   7,"buffer:"
c_bufferc   PHL
            JSR  c_create
            JMP  _c_allot
e_cbufferc ;------------------------------------------------------------------

#endif ;WORDS_LEN_7


;------------------------------------------------------------------------------
;  Words with names that have a length of 8 characters
;------------------------------------------------------------------------------

#ifdef WORDS_LEN_8

            ;CONSTANT ( x -- )  Creates a new 16-bit constant
            DW   e_constant
            DB   8,"constant"
c_constant  PHL
            JSR  begin_add_new_word
            JSR__pop_data_R4
            JSR  write_constant_body
            RTS
e_constant  ;------------------------------------------------------------------


            ; VARIABLE  Creates a new variable with one 16-bit cell
            DW   e_variable
            DB   8,"variable"
c_variable  PHL
            JSR  begin_add_new_word
            JSR  write_variable_body
            LDA  #0
_c_var_2em  JSR  emit_code
            JMP  emit_code_ret
e_variable  ;------------------------------------------------------------------


            ; 2LITERAL  ( x1 x2 -- )  Run-time: Place cell pair x1 x2 on the stack.
            DW   e_2literal
            DB   8+FL_IMMEDIATE,"2literal"
c_2literal  PHL
            JSR  c_swap
            JSR  c_literal
            JSR  c_literal
            RTS
e_2literal  ;------------------------------------------------------------------


            ; POSTPONE
            DW   e_postpone
            DB   8+FL_IMMEDIATE,"postpone"
c_postpone  PHL
            JSR  search_word_ex
            JPF  Error_Word ;word not found
            ROL  R2
            JPF  add_word_call_ret  ;add direct call to immediate word
            ;append call to insert JSR to the word later
            JSR  emit_code_ldi
            LDA  #PTR_L
            JSR  emit_code
            LDA  PTR_L
            JSR  emit_code
            JSR  emit_code_ldi
            LDA  #PTR_H
            JSR  emit_code
            LDA  PTR_H
            JSR  emit_code
            LD   PTR_L,#<add_word_call
            LD   PTR_H,#>add_word_call
add_word_call_ret:
            LDA  #OPCODE_JSR
            JMP  add_JmpOrJsr_ret
e_postpone  ;------------------------------------------------------------------


            ; COMPILE,
            DW   e_compilec
            DB   8,"compile,"
c_compilec  PHL
#ifdef FAST_DSTACK
            PLD  PTR_L
#else
            JSR__pop_data_R4
            JSR  ld_ptr_r4
#endif
            JMP  add_word_call_ret
e_compilec  ;------------------------------------------------------------------


            ; EVALUATE  ( i*x c-addr u -- j*x )
            DW   e_evaluate
            DB   8,"evaluate"
c_evaluate  PHL
            JSR__pop_data_R5_R4
            ;R5 = strlen
            ;R4 = ptr to the source string
            ;now: copy string, terminate it with a zero
            LD   R6_L,R5_L
            LD   R5_L,#<EVALUATE_BUF
            LD   R5_H,#>EVALUATE_BUF
            JSR  memcpy_short
            JSR  ld_ptr_r5
            LDA  #0
            SAP
            ;evaluate the zero-terminated string
            LD   PTR_L,#<BLK_L
            JSR  push_zpvar
            LD   BLK_L,#0
            LD   BLK_H,#0
            JSR  push_inptr
            LD   INPTR_L,#<EVALUATE_BUF
            LD   INPTR_H,#>EVALUATE_BUF
            JSR  evaluate
            JSR  pop_inptr
            LD   PTR_L,#<BLK_L
            JMP  pop_zpvar_rts
e_evaluate  ;------------------------------------------------------------------

#endif ;WORDS_LEN_8


#ifdef WORDS_LEN_9

;------------------------------------------------------------------------------
;  Words with names that have a length of 9 characters
;------------------------------------------------------------------------------

            ; immediate  ( -- )  Mark last compiled word as "IMMEDIATE" word
            DW   e_immediate
            DB   9,"immediate"
c_immediate PHL
            LD   PTR_L,DICTL_L
            LD   PTR_H,DICTL_H
            JSR__inc_ptr
            JSR__inc_ptr
            LAP
            OR   #FL_IMMEDIATE
            SAP
            RTS
e_immediate ;------------------------------------------------------------------

            ;2CONSTANT ( d -- )  Creates a new 32-bit constant
            DW   e_2constant
            DB   9,"2constant"
c_2constant PHL
            JSR  begin_add_new_word
            JSR  add_word_entry_code
            JSR  popR4R5_add_32bit_literal
            JMP  add_JmpReturn_ret
e_2constant ;------------------------------------------------------------------


            ; 2VARIABLE  Creates a new variable with two 16-bit cells
            DW   e_2variable
            DB   9,"2variable"
c_2variable PHL
            LD   LR_L,#<_c_var_2em
            LD   LR_H,#>_c_var_2em
            JMP  c_variable
e_2variable ;------------------------------------------------------------------


            ; ACTION-OF  ( "<spaces>name" -- xt )
            DW   e_actionof
            DB   9+FL_IMMEDIATE,"action-of"
c_actionof  PHL
            JSR  c_tick
            TST  STATE
            JPF  _c_deferld  ;interpretation mode
            ;compilation mode
            JSR  c_literal
            LD   PTR_L,#<c_deferld
            LD   PTR_H,#>c_deferld
            JMP  add_word_call_ret
e_actionof  ;------------------------------------------------------------------


            ; [COMPILE]
            DW   e_compileb
            DB   9+FL_IMMEDIATE,"[compile]"
c_compileb  PHL
            JSR  search_word_ex
            JPF  Error_Word ;word not found
            JMP  add_word_call_ret
e_compileb  ;------------------------------------------------------------------


            ; SOURCE-ID  ( -- 0 | -1 ) 
            DW   e_sourceid
            DB   9,"source-id"
c_sourceid  LDA  INPTR_H
            CMP  #>EVALUATE_BUF
            JPF  c_true
            JMP  c_false
e_sourceid  ;------------------------------------------------------------------



#endif

#ifdef WORDS_LEN_10

;------------------------------------------------------------------------------
;  Words with names that have a length of 10 characters
;------------------------------------------------------------------------------

            ; PARSE-NAME  ( "<spaces>name<space>" -- c-addr u ) Skip leading space delimiters. Parse name delimited by a space. 
            DW   e_parsename
            DB   10,"parse-name"
c_parsename PHL
			JSR  skipSpaces
            JSR  c_bl
            JMP  _c_parse
e_parsename ;------------------------------------------------------------------

#endif

#ifdef WORDS_LEN_11

;------------------------------------------------------------------------------
;  Words with names that have a length of 11 characters
;------------------------------------------------------------------------------



#endif

#if defined(WORDS_LEN_12) && !defined(ROM_16KB)

;------------------------------------------------------------------------------
;  Words with names that have a length of 12 characters
;------------------------------------------------------------------------------

            ; ENVIRONMENT?  ( c-addr u -- false | x true )
            DW   e_envqm
            DB   12,"environment?"
c_envqm     PHL
            JSR__pop_data_R4_R5
            ;R4_L = length of the string
            ;R5 = ptr to the string
            ;walk through the table of known strings and find the requested string
            LD   R6_L,#<tab_envstrings
            LD   R6_H,#>tab_envstrings
_cenv01     ;loop
            JSR  ld_ptr_r6
            JSR__lap_inc_ptr
            TST
            JPF  push_data_accu_ret  ; return false
            AD   R6_L
            STA  R6_L
            LD   R7_L,R5_L
            LD   R7_H,R5_H
            ;compare strings
            LD   R0,R4_L
_cenv02     JSR__lap_inc_ptr
            TST
            JPF  _cenv01 ;end of string in ROM, no match
            STA  R1
            JSR  psh_ptr
            JSR  ld_ptr_r7
            JSR  inc_r7
            LAP
            JSR  pop_ptr
            JSR  to_upper
            CMP  R1
            JNF  _cenv01 ;no match, try next string
            JLP  _cenv02
            ;found?
            JSR__lap_inc_ptr
            TST
            JNF  _cenv01 ;no match, try next string
            ;found!
            JSR__lap_inc_ptr
            STA  R0  ;how many parameter words
_cenv03     JSR__lap_inc_ptr
            STA  R4_L
            JSR__lap_inc_ptr
            STA  R4_H
            JSR__push_data_R4
            JLP  _cenv03
            JMP  ret_true
e_envqm     ;------------------------------------------------------------------


#endif

