#if 0
;------------------------------------------------------------------------------
;  BLOCK words for mass storage access (EEPROM)
;------------------------------------------------------------------------------
;
; This file implements this FORTH code:
;
; variable blk_struct 2 cells allot blk_struct 3 cells erase
; : BLK_ALLOC blk_struct @ 0= if 
;     here blk_struct ! 1024 allot then ;
; : SAVE-BUFFERS blk_struct cell+ cell+ @ if
;     blk_struct cell+ @ blk_struct @ eepsave
;     false blk_struct cell+ cell+ ! then ;
; : FLUSH save-buffers ;
; : BUFFER blk_alloc dup blk_struct cell+ @ = if drop else
;     save-buffers blk_struct cell+ ! then blk_struct @ ;
; : BLOCK blk_alloc dup blk_struct cell+ @ = if drop else
;     save-buffers dup blk_struct cell+ !
;     blk_struct @ eepload then blk_struct @ ;
; : UPDATE true blk_struct cell+ cell+ ! ;
; : EMPTY-BUFFERS blk_struct cell+ 2 cells erase ;
;
; Note:
;   Only one block buffer is supported. It gets allocated when
;   the BLOCK words are called the first time, thus no memory
;   is wasted when the BLOCK words are not used.
;
;------------------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_12
            ; SAVE-BUFFERS  ( -- )  Save the contents of each UPDATEd block buffer to the EEPROM.
            DW   e_savebuffers
            DB   12,"save-buffers"
c_savebuffers
            ; "blk_struct cell+ cell+ @ if blk_struct cell+ @ blk_struct @ eepsave
            ;  false blk_struct cell+ cell+ ! then"
            PHL
_c_savebuffers
            JSR  _c_chk_bptr
            TST  BLKSTR_UPD
            JPF  rts_opc
            LD   BLKSTR_UPD,#0
            LDA  BLKSTR_BLK+1
            CMP  #0xFF
            JPF  rts_opc
            ;Put block number into R4
            STA  R4_H
            LD   R4_L,BLKSTR_BLK+0
            ;Load data source address into R5
            LD   R5_L,BLKSTR_BUF+0
            LD   R5_H,BLKSTR_BUF+1
            ;Save the block to the EEPROM
            JSR  eeprom_write_forth_block
            JPF  Error_InOut
            ;finished
            RTS

_c_blk_free
            ; try to free the block buffer again
            PHL
            JSR  _c_bufaddr
            JSR  ld_R5_1024
            JSR__push_data_R5
            JSR  c_sum16
            JSR  c_here
            JSR  c_equal
            JSR__pop_data_R4
            TST  R4_H
            JPF  rts_opc
            DEC  CP_H
            DEC  CP_H
            DEC  CP_H
            DEC  CP_H
            DB   OPCODE_LDA  ; "jump" over following PHL instruction
init_blk_struct:
            PHL
_cinitblks  ; buffer address := NULL
            LD   BLKSTR_BUF+0,#0
            LD   BLKSTR_BUF+1,#0
_empty_blkstruct:
            ; buffer number := 0xFFFF
            LD   BLKSTR_BLK+0,#0xFF
            LD   BLKSTR_BLK+1,#0xFF
            ;dirty_flag = 0
            LD   BLKSTR_UPD,#0
            RTS

e_savebuffers ;----------------------------------------------------------------
#endif

#ifdef WORDS_LEN_5
            ; FLUSH  ( -- )  Perform the function of SAVE-BUFFERS, then unassign all block buffers.
            DW   e_flush
            DB   5,"flush"
c_flush     PHL
_c_flush    JSR  c_savebuffers
            JMP  _c_emptybuffers
e_flush     ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_6
            ; BUFFER  ( u -- a-addr )  
            DW   e_buffer
            DB   6,"buffer"
c_buffer    ; "blk_alloc dup blk_struct cell+ @ = if drop else
            ;  save-buffers blk_struct cell+ ! then blk_struct @"
            PHL
            JSR  _cbuf03
            JNF  _cbuf01
_cbuf04     ;same block number
            JSR  c_drop
            JMP  _cbuf02
_cbuf05     PHL  ;entry-point for shared code with BLOCK word
_cbuf01     ;other block number
            JSR  c_savebuffers
            JSR__pop_data_R4
            LD   BLKSTR_BLK+0,R4_L
            LD   BLKSTR_BLK+1,R4_H
            DB   OPCODE_LDA  ; "jump" over following PHL instruction
_c_bufaddr  ;get pointer to buffer
            PHL
_cbuf02     LD   R4_L,BLKSTR_BUF+0
            LD   R4_H,BLKSTR_BUF+1
            JMP__push_data_R4_ret
_cbuf03     ;shared code with c_block
            PHL
            JSR _c_blk_alloc
            JSR__pop_data_R4
            JSR__push_data_R4
            LDA  R4_L
            CMP  BLKSTR_BLK+0
            JNF  rts_opc
            LDA  R4_H
            CMP  BLKSTR_BLK+1
            RTS  ;return with FLAG=1 if same block number

_c_blk_alloc
            ; "blk_struct @ 0= if here blk_struct ! 1024 allot then"
            PHL
            JSR  _c_chk_bptr
            TST  BLKSTR_BUF+1
            JNF  rts_opc
            JSR  c_here
            JSR  ld_R5_1024
            JSR__push_data_R5
            JSR  c_allot  ;allocate memory, may throw an error message if no memory available
            JSR__pop_data_R4
            LD   BLKSTR_BUF+0,R4_L
            LD   BLKSTR_BUF+1,R4_H
            RTS

_c_chk_bptr
            ; check if buffer pointer is still valid
            PHL
_chk_bptr_1
            JSR  _c_bufaddr
            JSR  c_here
            JSR  c_ulessthan
            JSR__pop_data_R4
            TST  R4_H
            JPF  _cinitblks  ; jump if false (buffer address is invalid)
            RTS

e_buffer    ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_5
            ; BLOCK  ( u -- a-addr )  Load a data block from EEPROM into memory
            DW   e_block
            DB   5,"block"
            ; "blk_alloc dup blk_struct cell+ @ = if drop else
            ;  save-buffers dup blk_struct cell+ ! blk_struct @ eepload then blk_struct @"
c_block     PHL
            JSR  _cbuf03  ;share code with BUFFER
            JPF  _cbuf04  ;jump if same block number
            ;other block number
            JSR  c_dup
            JSR  _cbuf05  ;share code with BUFFER
            ;Load memory destination address into R5
            JSR__pop_data_R5
            ;Load block number into R4
            JSR__pop_data_R4
            ;Read the block into memory
            JSR  eeprom_read_forth_block
            JPF  Error_InOut
            ;finished
            JMP  _cbuf02
e_block     ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_6
            ; UPDATE  ( -- )  Mark the current block buffer as modified
            DW   e_update
            DB   6,"update"
c_update    ; "true blk_struct cell+ cell+ !"
            LD   BLKSTR_UPD,#0xFF
            RET
e_update    ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_13
            ; EMPTY-BUFFERS  ( -- ) 
            DW   e_emptybuffers
            DB   13,"empty-buffers"
c_emptybuffers  ; "blk_struct cell+ 2 cells erase"
            PHL
_c_emptybuffers
            JSR  _c_blk_free
            JMP  _empty_blkstruct
e_emptybuffers ;---------------------------------------------------------------
#endif

#ifdef WORDS_LEN_4
            ; LOAD ( n -- )  Load and interpret a "screen" from EEPROM (n = screen number)
            DW   e_load
            DB   4,"load"
c_load      LD   R6_H, #0	;=0:LOAD; !=0:LIST. R6 is not used in load_line_into_filebuf
            PHL
            ;write yet unsaved blocks to EEPROM
_list_ent   JSR  c_savebuffers
            ;push current context (BLK, LINE and INPTR) to the system stack
            LD   PTR_L,#BLK_L
            JSR  push_zpvar
            LD   PTR_L,#FILE_LNBR
            JSR  push_zpvar
            JSR  push_inptr
            ;get block number
            JSR__pop_data_R4
_ldscr06    LD   FILE_LNBR,#0  ; line number 0 - 15
_ldscr01    ;loop over all lines in the screen
            JSR  psh_r4
            LD   BLK_L,R4_L
            LD   BLK_H,R4_H
            TST  R6_H
            JNF  _ldscr12            
            JSR  test_blk		;if LOAD, test if block number is 0
            JPF  Error_Value
_ldscr12    JSR  load_line_into_filebuf
            TST  R6_H
            JNF  _ldscr10
            PSH  R6_H
            JSR  interpret_filebuf_line
            POP  R6_H
            JMP  _ldscr11
_ldscr10    JSR  list_filebuf_line
_ldscr11    JSR  pop_r4
            TST  REFILL
            JPF  _ldscr07
            ; refill flagged, continue at line 0 in next block
            LD   REFILL,#0
            JSR  inc_r4
            JMP  _ldscr06
_ldscr07    ;next line
            INC  FILE_LNBR
            LDA  #16
            CMP  FILE_LNBR
            JNF  _ldscr01
            ;restore the context, get INPTR, LINE and BLK back from stack
            JSR  pop_inptr
            LD   PTR_L,#FILE_LNBR
            JSR  pop_zpvar
            LD   PTR_L,#BLK_L
            JSR  pop_zpvar
            ;check last context, refill file buffer with old line if required
            JSR  test_blk
            JNF  load_line_into_filebuf_rts
            RTS
e_load      ;------------------------------------------------------------------


            ; THRU ( u1 u2 -- )  LOAD the mass storage blocks numbered u1 through u2 in sequence.
            DW   e_thru
            DB   4,"thru"
c_thru      PHL
            JSR__pop_data_R4_R5
_thru01     JSR  psh_r4
            JSR  psh_r5
            JSR__push_data_R5
            JSR  c_load
            JSR  pop_r5
            JSR  pop_r4
            LDA  R5_L
            CMP  R4_L
            JNF  _thru02
            LDA  R5_H
            CMP  R4_H
            JPF  rts_opc
_thru02     JSR  inc_r5
            JMP  _thru01
e_thru      ;------------------------------------------------------------------

            ; LIST ( n -- )  Display block n in an implementation-defined format. (n = screen number)
            DW   e_list
            DB   4,"list"
c_list      PHL

			; set SCR
            JSR  prep_eepblk
            LD   SCR_L,R5_L
            LD   SCR_H,R5_H
            JSR__push_data_R5	; push screen number back into dstack
                        
            JSR  print_nl
            LD   R6_H, #1
            LD   R6_L, #0 ; line number
            LD   LIB_FIRSTLINE, #0		;do not bypass first print_nl_w
            
            TST  LIB_LCDOUT
            JPF  _list_ent          
            JSR  lcd_clear
            JMP  _list_ent

list_filebuf_line:	;subroutine for list one line
            PHL
_lsscr05    LDA  R6_L
            JSR  print_hexbyte
            LDA  #'|'
            JSR  print_char
            JSR  print_space
            ;print 64 characters
            JSR  ld_ptr_filebuf
            LD   R0,#64            
_lsscr03    LAP
            IPT
            JSR  print_char
            JLP  _lsscr03
#ifndef WITH_I2C_LCD_KYBD            
            JSR  print_nl
#else       
            JSR  print_nl_w
#endif
            LDA  R6_L
_lsscr06    INC
            CMP  #0x0A
            JNF  _lsscr04
            LDA  #0x10
_lsscr04    STA  R6_L            
            RTS
e_list      ;------------------------------------------------------------------
#endif
