;------------------------------------------------------------------------------
;  EDIT word to edit a SCREEN on a serial terminal via RS232
;------------------------------------------------------------------------------
#ifdef WITH_I2C_LCD_KYBD
PROMPT_YPOS   SET 19
#else

#ifdef BETTER_EDITOR
PROMPT_YPOS   SET 21
#else
PROMPT_YPOS   SET 20
#endif

#endif
            ;edit on a serial terminal
            ;on stack: blocknbr, buffer
            JSR _c_val_scrbuf
            JSR  c_store
            JSR _c_val_scrnum
            JSR  c_store
            JSR _c_printscr
            
_c_mloop    JSR _c_printpmpt
            JSR _c_input2
            JSR _c_evalinp
            JMP _c_mloop


_c_val_scrnum
            LDA  #<(EDIT_STRUCT+0)
            DB   OPCODE_LDI  ; trick: jumps over next two bytes, but overwrites register TEMP5
_c_val_scrbuf
            LDA  #<(EDIT_STRUCT+2)
            DB   OPCODE_LDI  ; trick: jumps over next two bytes, but overwrites register TEMP5
_c_val_inpcnt
            LDA  #<(EDIT_STRUCT+4)
            STA  R4_L
            LD   R4_H,#>(EDIT_STRUCT+0)
            JMP__push_data_R4


MEM_STRBUF  SET  SYS_BUF
_c_strbuf   LD   R4_L,#<MEM_STRBUF
            LD   R4_H,#>MEM_STRBUF
            JMP__push_data_R4

_c_add_scrbuf
            PHL
            JSR _c_val_scrbuf
            JSR  c_at
            JMP _c_sum16


_c_editline ; edit a line
            PHL
            JSR  c_dup
            JSR _c_strbuf
            JSR__pop_data_R4_R5
            LD   R0,#0x41
            JSR  forth_edlin
            ;----
            ;Bugfix v1.4:
            ;Ensure that string is always 64 characters long.
            ;If needed, fill it up with spaces.
            ;R4 is still pointing to the buffer.
            ;R2 is the string length.
            ;PTR is pointing to the end of the string.
_ceditln01  LDA  #32
            JSR__sap_inc_ptr
            LDA  R2
            INC  R2
            CMP  #64
            JNF  _ceditln01
            ;----
            JSR _c_strbuf
            JSR  c_swap
            LD   R4_L,#64
            LD   R4_H,#0
            JSR__push_data_R4
            JSR  c_move
            RTS

_c_hline    ; print horizontal line, line length in ACCU
            PHL
            STA  R0
_chline01   LDA  #'-'
            JSR  print_char
            JLP  _chline01
            RTS

_c_prscrln  ; print one of the 16 lines of the screen ( line -- )
            PHL
            JSR  c_dup
            JSR  push_data_zero
            JSR  c_swap
            JSR  c_1plus
            JSR  c_at_xy
            JSR  _cprscr01
            LDA  #'|'
            JSR  print_char
            JSR  c_space
            ;JSR  c_1minus
            JSR  push64
            JSR  c_mul16
            JSR _c_add_scrbuf
            JSR  push64
            JSR  c_type
            JSR  c_space
            LDA  #'|'
            JSR  print_char
            JSR  c_cr
            RTS
_cprscr01   PHL
            JSR  c_dup
            JSR  c_stod
            JSR  c_lns
_cprscr03   JSR  c_ns
            JSR  c_ns
            JSR  c_nsg
            JSR  c_type
            RTS
_cprscr02   PHL
            JMP  _cprscr03

push64      LDA  #64
            JMP  push_data_accu

_c_printscr ; print the whole screen and also the menu
            PHL
            ;page 29 hline ." [Screen "
            JSR  c_page
            LDA  #29
            JSR _c_hline
            PRINT _cprscrT1
            ;scrnum s>d <# # # # #>
            JSR _c_val_scrnum
            JSR  c_at
            JSR  c_stod
            JSR  c_lns
            JSR  c_ns
            JSR  _cprscr02 ;re-use code from c_prscrln
            ;type [char] ] emit 29 hline
            LDA  #']'
            JSR  print_char
            LDA  #29
            JSR _c_hline
            ;16 0 do i prscrln loop
            LDA  #0
_cprtscr01  PSH
            JSR  push_data_accu
            JSR _c_prscrln
            POP
            INC
            CMP  #16
            JNF  _cprtscr01
            ;70 hline
            LDA  #70
            JSR _c_hline
            PRINT _cprscrT2
            RTS
_cprscrT1   DB   "[Screen ",0
#ifdef WITH_I2C_LCD_KYBD

#ifdef BETTER_EDITOR
_cprscrT2   DB   "\n#line, Insert, Delete, Clear, Save, Quit, Write&exit",0
#else
_cprscrT2   DB   "\n#line, Clear, Save, Quit, Write&exit",0
#endif

#else

_cprscrT2   DB   "\nEnter line number to edit, or enter:\n"
#ifdef BETTER_EDITOR
            DB   "I = insert line, D = delete line, C = clear screen\n"
            DB   "S = save, Q = quit (lose changes), W = save and quit",0
#else
            DB   "S = save, Q = quit (lose changes), W = save and quit, "
            DB   "C = clear screen",0
#endif

#endif
_c_printpmpt ; print the input prompt
            PHL
            ;0 20 at-xy ." >"
            LD   R0,#0
            LD   R1,#PROMPT_YPOS
            JSR  display_gotoxy
            LDA  #'>'
            JSR  print_char
            LDA  #22 ;67
            JSR  push_data_accu
            JSR  c_spaces
            ;2 20 at-xy
            LD   R0,#2
            LD   R1,#PROMPT_YPOS
            JMP  _c_atxy_rts

; : input2 begin strbuf 2 accept dup to inpcnt until ;
_c_input2
            PHL
_cinp201    JSR _c_strbuf
            LDA  #2
            JSR  push_data_accu
            JSR  c_accept
            JSR  c_dup
            JSR _c_val_inpcnt
            JSR  c_store
            JSR__pop_data_R4
            TST  R4_L
            JPF  _cinp201
            RTS

_c_isnum    ; check if the input buffer contains a valid number ( -- flag)
            PHL
            JSR  _cisnum03
            LD   R4_L,#0xFF  ;flag: initialize with TRUE
_cisnum02   JSR__lap_inc_ptr
            JSR  is_digit
            JNF  _cisnum01
            LD   R4_L,#0     ;set flag to false
_cisnum01   JLP  _cisnum02
            JSR  _pushR4LR4L ;push flag to data stack
            RTS
_cisnum03   PHL
            JSR _c_val_inpcnt
            JSR  c_at
            JSR__pop_data_R4
            LD   R0,R4_L
            LD   PTR_L,#<MEM_STRBUF
            LD   PTR_H,#>MEM_STRBUF
            RTS

_c_getnum   ; get the number from the input buffer ( -- number )
            PHL
            JSR  _cisnum03  ;re-use code from _c_isnum
            LD   R4_L,#0
            LD   R4_H,#0
_cgetnm01   JSR  mul10
            JSR__lap_inc_ptr
            AND  #0x0F
            AD   R4_L
            STA  R4_L
            JLP  _cgetnm01
            JMP__push_data_R4_ret

_c_getcmd   ; get the command character from the input buffer
            PHL
            JSR  _cisnum03  ;re-use code from _c_isnum
            LD   R4_L,#0
_cgetcm01   LD   R4_H,R4_L
            JSR__lap_inc_ptr
            STA  R4_L
            JLP  _cgetcm01
            JMP__push_data_R4_ret

_c_getinp   ; evaluate the user input in the input buffer
            ; return a number or a command
            ; ( -- num 1  [or]  -- cmd 0 )
            PHL
            JSR _c_isnum
            JSR__pop_data_R4
            TST  R4_L
            JPF  _cgetin01
            JSR _c_getnum
            JSR  c_dup
            JSR__pop_data_R4
            ;DEC  R4_L
            LDA  #0xF0		; is 0..15 ?
            AND  R4_L
            TST
            JNF  _cgetin02
            LDA  #1
            JSR  push_data_accu
            RTS
_cgetin02   JSR  c_drop
            JSR  push_data_zero
            JMP  _cgetin03
_cgetin01   JSR _c_getcmd
_cgetin03   JSR  push_data_zero
            RTS

           
_c_savescr  ; save a modified screen to EEPROM
            PHL
_c_savescr1
            PRINT text_saving1
            JSR  c_savebuffers
            RTS


_c_clearScreen  ;  ( bufaddr -- )
            ;fill screen buffer with spaces
            PHL
            LD   R4_L,#0
            LD   R4_H,#4
            JSR__push_data_R4
            JSR  c_bl
            JMP  _c_fill


#ifdef BETTER_EDITOR
ed_inp_num  ;read a number from console, return flag=0 and R4_L=number if ok
            PHL
            JSR _c_input2
            JSR  c_space  ; only for visual feedback
            JSR _c_isnum
            JSR__pop_data_R4
            TST  R4_L
            JPF  rts_opc
            JSR  _c_getnum
            JSR__pop_data_R4
            ;DEC  R4_L
            ;LDA  #0xF0		; is 0..15 ?
            ;AND  R4_L
            ;TST
            LDA  #15		; is 0..15 ?
            SU   R4_L
            INC  FLAG
            RTS

ed_lastline ;return memory address of beginning of last text line on data stack
            PHL
            LD   R4_L,#<960
            LD   R4_H,#>960
            JSR__push_data_R4
            JMP _c_add_scrbuf+1

edit_insert ;insert an empty line
            JSR  ed_lastline
            JSR__pop_data_R4
            JSR  ld_ptr_r4
            LD   R0,#64
_edin01     JSR__lap_inc_ptr
            CMP  #32
            JNF  _edin02
            JLP  _edin01
            PRINT _textinsln
            JSR  ed_inp_num
            JPF  rts_opc
            JSR__push_data_R4
            LDA  #15
            JSR  push_data_accu
            JSR  c_swap
            JSR  c_sub16
            JSR  push64
            JSR  c_mul16
            ;on stack: number of bytes to move
            LD   R4_L,#0
            LD   R4_H,#4
            JSR__push_data_R4
            JSR _c_add_scrbuf
            JSR  c_dup
            JSR  push64
            JSR  c_sub16
            ;on stack: number of bytes to move, destination-address+1, source-address+1
            JSR__pop_data_R4_R5
            LD   R6_L,R5_L
            LD   R6_H,R5_H
            JSR__pop_data_R5
            ;now: R4 = source+1, R5 = number of bytes, R6 = dest+1
            ;move the memory!
            JMP  _edin07
_edin04     DEC  R5_H
_edin03     DEC  R5_L
            TST  R4_L
            JNF  _edin05
            DEC  R4_H
_edin05     DEC  R4_L
            TST  R6_L
            JNF  _edin06
            DEC  R6_H
_edin06     DEC  R6_L
            JSR  ld_ptr_r4
            LAP
            JSR  ld_ptr_r6
            SAP
_edin07     TST  R5_L
            JNF  _edin03
            TST  R5_H
            JNF  _edin04
            ;clear inserted line
            JSR  ld_ptr_r4
            LD   R0,#64
_edin08     LDA  #32
            SAP
            JSR__inc_ptr
            JLP  _edin08
            ;update the screen
            JMP  _cevali08

_edin02     ;error, last line not empty
            PRINT _textnoins
            JMP  _wait1s5

edit_delete ;delete a line
            PRINT _textdelln
            JSR  ed_inp_num
            JPF  rts_opc
            JSR__push_data_R4
            JSR__push_data_R4
            JSR  push64
            JSR  c_mul16
            JSR _c_add_scrbuf
            ; on stack: line, start address of the line to delete
            JSR  c_dup
            JSR  push64
            JSR  c_sum16
            JSR  c_swap
            ; on stack: line, start address of next line, start address of line to delete
            JSR  c_rot
            LDA  #15
            JSR  push_data_accu
            JSR  c_swap
            JSR  c_sub16
            JSR  push64
            JSR  c_mul16
            ; on stack: start address of next line, start address of line to delete, number of bytes to move
            JSR  c_move
            ;delete last line (overwrite it with spaces)
            JSR  ed_lastline
            JSR  push64
            LD   R4_L,#32
            JSR__push_data_R4
            JSR  c_fill
            ;update the screen
            JMP  _cevali08
            
_textinsln  DB   "\rInsert before line: ",0
_textdelln  DB   "\rDelete line: ",0
_textnoins  DB   "\rLast line not empty !",0

#endif


_c_evalinp  ; evaluate the user input, handle the menu
            PHL
            JSR _c_getinp
            JSR__pop_data_R4
            TST  R4_L
            JPF  _cevali01
            ;number entered
            LD   R0,#0
            LD   R1,#PROMPT_YPOS
            JSR  display_gotoxy
#if 1       ;-------------------
            ; New in v1.4:
            ; Edit line inside the screen display, and not on the command line of the editor
            LDA  #5
            JSR  push_data_accu
            JSR  c_spaces
            JSR  push_data_zero
            JSR  c_over
            JSR  c_1plus
            JSR  c_at_xy
            JSR  _cprscr01  ;re-use code from _c_prscrln to print the number
            LDA  #'>'
            JSR  print_char
            JSR  print_space
#else       ;-------------------
            ; old code before v1.4:
            JSR  _cprscr01  ;re-use code from _c_prscrln to print the number
            LDA  #'>'
            JSR  print_char
#endif
            JSR  c_dup
            ;JSR  c_1minus
            LDA  #64
            JSR  push64
            JSR  c_mul16
            JSR _c_add_scrbuf
            JSR _c_editline
            JSR _c_prscrln
            JSR  c_update
            RTS
_cevali01   ;command entered
            JSR__pop_data_R4
            TST  R4_H
            JNF  _cevali05
            LDA  R4_L
            JSR  to_upper
            CMP  #'Q'
            JPF  _cevali06
_cevali02   CMP  #'S'
            JPF  _c_savescr1
_cevali03   CMP  #'W'
            JPF  _cevali04
#ifdef BETTER_EDITOR
            CMP  #'I'
            JPF  edit_insert
            CMP  #'D'
            JPF  edit_delete
#endif
            CMP  #'C'
            JNF  _cevali05
            ;case C
            JSR _c_val_scrbuf
            JSR  c_at
            JSR _c_clearScreen
_cevali08   JSR _c_printscr
            JSR  c_update
            RTS
_cevali05   ;unknown command
            PRINT text_errCmd
_wait1s5    LD   R4_L,#<1500
            LD   R4_H,#>1500
            JSR__push_data_R4
            JMP  c_ms+1

_cevali04   ;case W
            JSR _c_savescr
_cevali06   ;case Q
            JSR  print_nl
            ;return to Forth, break the menu loop
            POP
            POP

            ;end of editor code, program execution continues in file forth_words_edit.asm
