;------------------------------------------------------------------------------
;  Words with special functions for My4TH
;------------------------------------------------------------------------------


#ifndef PLATFORM_XS
#ifdef WORDS_LEN_4
            ; RINP  ( -- u )  read input port
            DW   e_rinp
            DB   4,"rinp"
c_rinp      IN
            JMP  push_data_accu
e_rinp      ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_4
            ; WOUT  ( u -- )  write to output port
            DW   e_wout
            DB   4,"wout"
c_wout      PHL
            JSR__pop_data_R4
            LD   OUTP,R4_L
            OUT  OUTP
            RTS
e_wout      ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_4
            ; ROUT  ( -- u )  read current state of output port
            DW   e_rout
            DB   4,"rout"
c_rout      LDA  OUTP    ; fixed in v1.1, was "LD R4_L,OUTP" in v1.0
            JMP  push_data_accu
e_rout      ;------------------------------------------------------------------
#endif
#endif

#ifndef NO_I2C
#ifdef WORDS_LEN_9
            ; I2C-START  ( addr -- ack )  send a start condition
            DW   e_i2cstart
            DB   9,"i2c-start"
c_i2cstart  PHL
            JSR__pop_data_R4
            LD   R0,R4_L
            JSR  i2c_start_addr
            JNF  _ci2csnd01
            JSR  i2c_stop_xs
            JMP  ret_false
e_i2cstart  ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_8
            ; I2C-STOP  ( -- )  send a stop condition
            DW   e_i2cstop
            DB   8,"i2c-stop"
c_i2cstop   JMP  i2c_stop
e_i2cstop   ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_8
            ; I2C-SEND  ( byte -- ack )  send a byte
            DW   e_i2csend
            DB   8,"i2c-send"
c_i2csend   PHL
            JSR__pop_data_R4
            LD   R1,R4_L
            JSR  i2c_send
_ci2csnd01  INC  FLAG
            JSR  push_flag
            RTS
e_i2csend   ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_8
            ; I2C-RECV  ( ack -- byte )  receive a byte  (ack is usually 0 and must be 1 for the very last byte)
            DW   e_i2crecv
            DB   8,"i2c-recv"
c_i2crecv   PHL
            JSR__pop_data_R4
            LD   R1,R4_L
            JSR  i2c_recv
            JSR  push_data_accu
            RTS
e_i2crecv   ;------------------------------------------------------------------
#endif

#if defined(WORDS_LEN_4) && defined(PLATFORM_XS)
            ; I2C?   detect and print list of available I2C devices
            DW   e_i2cqm
            DB   4,"i2c?"
c_i2cqm     PHL
            LD   R2,#2
_ci2cqm01   JSR  i2c_ping
            JPF  _ci2cqm02
            LDA  #2
            JSR  delay_ms
            JSR  i2c_finish
            LDA  R2
            JSR  print_hexbyte
            JSR  print_space
_ci2cqm02   INC  R2
            INC  R2
            LDA  #0xFE
            CMP  R2
            JNF  _ci2cqm01
            JSR  i2c_finish
            JSR  print_nl
            RTS
e_i2cqm     ;------------------------------------------------------------------

#endif
#endif ; !NO_I2C

#ifndef NO_BLOCK_WORDS
#ifdef WORDS_LEN_10
            ; SAVE-IMAGE  ( n -- )
            ; Usage: To save a file to EEPROM block 5 and following blocks, enter:
            ; 5 save-image
            DW   e_saveimage
            DB   10,"save-image"
c_saveimage PHL
            JSR  c_dup  ; make a copy of the block number
            ;construct the program header
            LD   PTR_L,#<FORTH_START
            LD   PTR_H,#>FORTH_START
            LDA  #FTH_HDR_FLAG
            JSR__sap_inc_ptr
            LDA  #ROMVERSION_BINARY^PFFLAG
            JSR__sap_inc_ptr
            LDA  #0   ; two bytes reserved
            JSR__sap_inc_ptr 
            JSR__sap_inc_ptr
            LD   R4_L,#PRGHEADER
            LD   R4_H,#REGPAGE_HI
            LD   R5_L,#<(FORTH_START+4)
            LD   R5_H,#>(FORTH_START+4)
            LD   R6_L,#PRGHDR_SIZE
            JSR  memcpy_short
            ;save all blocks
            LD   PTR_L,#<FORTH_START
            LD   PTR_H,#>FORTH_START
            JSR  psh_ptr
_sav4th01   ;get block number from stack, but keep the original on stack
            JSR  c_dup
            JSR__pop_data_R4
            JSR  fblockToEepromAddr
            JPF  Error_Value
            LD   R7_L,#8   ; 8 blocks of 128 bytes = 1024 bytes to write
            ;R4 = 16-bit EEPROM address
_sav4th02   JSR  eeprom_start_write_ackpoll
            JPF  Error_InOut  ; error
            LD   R2,#128
            JSR  pop_ptr
            JSR  eeprom_write_block
            PSH  FLAG
            JSR  eeprom_stop
            POP  FLAG
            JPF  Error_InOut  ; error
            ;written enough?
            LDA  PTR_L
            SU   CP_L
            LDA  PTR_H
            SUB  CP_H
            JPF  _sav4th04
            JSR  psh_ptr
            ;write next 128-byte block
            LDA  #128
            AD   R4_L
            STA  R4_L
            JNF  _sav4th03
            INC  R4_H
_sav4th03   DEC  R7_L
            TST  R7_L
            JNF  _sav4th02
            ;inc block number
            JSR  c_1plus
            ;next block
            JMP  _sav4th01
_sav4th04   ;print message "saved to block x-y"
            JSR  c_swap
            LD   PTR_L,#<text_savedto
            LD   PTR_H,#>text_savedto
            JSR  _sav4th05
            LD   PTR_L,#<text_to
            LD   PTR_H,#>text_to
            DB   0x03  ;insert OP-code for "LDA #", so skip following PHL
_sav4th05   PHL
            JSR  print_str
            JMP  print_integer_rts
e_saveimage ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_9
            ; RUN-IMAGE  ( n -- )
            ; Usage: To load and run a file from EEPROM block 5 and following blocks, enter:
            ; 5 run-image
            DW   e_runimage
            DB   9,"run-image"
c_runimage  LDA  #1
            JMP  _ldforth10
e_runimage  ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_10
            ; LOAD-IMAGE  ( n -- )
            ; Usage: To load a file from EEPROM block 5 and following blocks, enter:
            ; 5 load-image
            DW   e_loadimage
            DB   10,"load-image"
c_loadimage LDA  #0
_ldforth10  PHL
            PSH
            ;get block number from stack, but keep the original on stack
            JSR  c_dup
            JSR__pop_data_R4
            JSR  fblockToEepromAddr
            JPF  Error_Value
            ;read first 24 bytes from EEPROM (the beginning of the program header)
            JSR  eeprom_start_read
            JPF  Error_InOut
            LD   R5_L,#24
            LD   R5_H,#0
            LD   PTR_L,#DRIVER_VARS
            LD   PTR_H,#>REGPAGE
            JSR  eeprom_read_block
            JSR  eeprom_stop
            LDA  DRIVER_VARS+0
            CMP  #FTH_HDR_FLAG
            JNF  _c_loadferr
            ;get the size of the FORTH program image in the EEPROM
            LDA  DRIVER_VARS+22
            SU   #<FORTH_START
            STA  R6_L
            LDA  DRIVER_VARS+23
            SUB  #>FORTH_START
            STA  R6_H
            LD   PTR_L,#<FORTH_START
            LD   PTR_H,#>FORTH_START
            ;now load the whole program
            JSR  loadForthBlocksToMemory
            POP
            TST
            JNF  _c_runimage  ;execute the program
            JSR  prepare_forth_program
            JPF  _c_loadferr
            JSR  printOkStatus
            JMP  abort_restart
_c_runimage JSR  prepare_forth_program
            JNF  do_run
_c_loadferr PRINT text_error
            JMP  forth_reinit

loadForthBlocksToMemory:
            ;R6 = remaining number of bytes to load,
            ;PTR = destination memory pointer
            ;block number on data stack
            PHL
_ldforth01  JSR  psh_ptr
            JSR  psh_r6
            JSR  c_dup
            JSR__pop_data_R4
            JSR  fblockToEepromAddr
            JPF  Error_Value
            JSR  eeprom_start_read
            JPF  Error_InOut
            JSR  pop_r6
            JSR  pop_ptr
            ;calculate number of bytes to read, but read no more than 1024 bytes
            LDA  #3
            SU   R6_H
            JNF  _ldforth02
            LD   R5_L,R6_L
            LD   R5_H,R6_H
            JMP  _ldforth03
_ldforth02  LD   R5_L,#0
            LD   R5_H,#4
_ldforth03  LDA  R6_L
            SU   R5_L
            STA  R6_L
            LDA  R6_H
            SUB  R5_H
            STA  R6_H
            ;now read the data (max 1 kB)
            JSR  eeprom_read_block
            JSR  eeprom_stop
            ;print progress
            LDA  #'#'
            JSR  print_char
            ;load next block
            JSR  c_1plus
            TST  R6_L
            JNF  _ldforth01
            TST  R6_H
            JNF  _ldforth01
            ;program loaded
            JSR__pop_data_R4  ; remove block number from data stack
            RTS
e_loadimage ;------------------------------------------------------------------
#endif
#endif ; !NO_BLOCK_WORDS

#if !defined(PLATFORM_MYNOR) && !defined(NO_LCD)
#ifdef WORDS_LEN_3
            ; LCD  ( -- )
            DW   e_lcd 
            DB   3,"lcd"
c_lcd       TST  LIB_LCDOUT
            JPF  init_console
            RET
e_lcd       ;------------------------------------------------------------------
#endif

#ifdef WORDS_LEN_8
            ; TERMINAL
            DW   e_terminal
            DB   8,"terminal"
c_terminal  LD   VECT_OUTPUT+2,#0 ;set standard vector
            LD   VECT_INPUT+2,#0  ;set standard vector
            TST  LIB_LCDOUT
            JPF  ret_opc
            PHL
            JSR  display_clear
            PRINT text_useterm
            JSR  lcd_disable
            JSR  keyboard_term
            RTS
e_terminal  ;------------------------------------------------------------------
#endif
#endif

#ifndef ROM_16KB
#ifdef WORDS_LEN_4
            ; SYSV  ( u -- addr )   return a pointer to the vector address of system vector u
            DW   e_sysv
            DB   4,"sysv"
c_sysv      PHL
            JSR__pop_data_R4
            LDA  R4_L
            JSR  getVectAdr
            LD   R4_L,PTR_L
            LD   R4_H,PTR_H
            JMP__push_data_R4_ret
e_sysv      ;------------------------------------------------------------------
#endif
#endif


#ifdef WORDS_LEN_6
            ; RANDOM  ( n -- u )  Random number generator. The generated number u is in the range 0 .. n-1.
            DW   e_random
            DB   6,"random"
c_random    PHL
            LD   R4_L,RANDVAR+0
            LDA  RANDVAR+2
            ROL
            INC  FLAG
            RWL  RANDVAR+0
            INC  FLAG
            ROL  RANDVAR+2
            LDA  #31
            AD   RANDVAR+1
            STA  RANDVAR+1
            STA  R4_H
            JSR__pop_data_R5
            JSR  divide_u
            JMP__push_data_R5_ret
e_random    ;------------------------------------------------------------------
#endif

#if defined(WORDS_LEN_5) && !defined(ROM_16KB)
            ; RDROP   remove one word from return stack
            DW   e_rdrop
            DB   5,"rdrop"
c_rdrop     DEC  RETSP
            DEC  RETSP
            RET
e_rdrop     ;------------------------------------------------------------------
#endif


#if defined(WORDS_LEN_2) && !defined(ROM_16KB)
            ; SX    get x-size (width) of the current display to the stack
            DW   e_sx
            DB   2,"sx"
c_sx        PHL
            LDA  LIB_DISPMAXX
            JMP  push_data_accu_ret
e_sx        ;------------------------------------------------------------------
#endif


#if defined(WORDS_LEN_2) && !defined(ROM_16KB)
            ; SY    get y-size (height) of the current display to the stack
            DW   e_sy
            DB   2,"sy"
c_sy        PHL
            LDA  LIB_DISPMAXY
            JMP  push_data_accu_ret
e_sy        ;------------------------------------------------------------------
#endif


#ifdef WORDS_LEN_2
            ; >=  ( n n -- flag )
            DW   e_greq
            DB   2,">="
c_greq      PHL
            JSR  c_lessthan
            JMP  _c_invert
e_greq      ;------------------------------------------------------------------
#endif


#ifndef ROM_16KB
#ifdef WORDS_LEN_2
            ; <=  ( n n -- flag )
            DW   e_leeq
            DB   2,"<="
c_leeq      PHL
            JSR  c_grtrthan
            JMP  _c_invert
e_leeq      ;------------------------------------------------------------------
#endif


#ifdef WORDS_LEN_6
            ; BOUNDS  ( addr u -- addr+u addr )
            DW   e_bounds
            DB   6,"bounds"
c_bounds    PHL
            JSR  c_over
            JSR  c_sum16
            JMP  _c_swap
e_bounds      ;------------------------------------------------------------------
#endif

#if defined(WORDS_LEN_3) && defined(PLATFORM_XS)
            ; LED  ( value -- )  Switch the on-board LED on or off (only on "My4TH light")
            DW   e_led
            DB   3,"led"
c_led       PHL
            JSR__pop_data_R4
            TST  I2C_BUSY
            JNF  rts_opc
            LDA  #6
            TST  R4_L
            JNF  _cled01
            INC
_cled01     STA  OUTP
            OUT  OUTP
            RTS
e_led       ;------------------------------------------------------------------
#endif

#endif ; !ROM_16KB

