;------------------------------------------------------------------------------
; Input (read a string from console / terminal)
;------------------------------------------------------------------------------

SEG_LOWCODE

call_vect_input:  ; call function v_keyb_input via a vector
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_BIGKEYB
          JNF  keyb_readkey
#else
#ifdef MY4TH_NFD
          TST  LIB_BIGKEYB
          JNF  FDVECT_READKEY
#endif
#endif

inp_readkey:
          ;call readkey over a vector (if any is set), 
          ;only return when a key was pressed.
          PHL
          PSH  R2
          PSH  R3
          PSH  R4_L
          PSH  R4_H
          PSH  PTR_L
          PSH  PTR_H
          TST  VECT_INPUT+2
          JPF  _inprk01
_inprk02  JSR  INPUT_VECTOR
          TST
          JPF  _inprk02
          JMP  _inprk03
_inprk01  JSR  readkey
_inprk03  POP  PTR_H
          POP  PTR_L
          POP  R4_H
          POP  R4_L
          POP  R3
          POP  R2
          RTS


#ifndef NO_BLOCK_WORDS
forth_edlin:
          ;input a line: R4=buffer, R5=default str, R0=bufsize
          PHL
          LD   R6_L,R4_L
          LD   R6_H,R4_H
          LD   R2,#0
          LD   R1,R0
          DEC  R1
_edln01   JSR  ld_ptr_r5
          JSR  inc_r5
          LAP  
          JSR  ld_ptr_r6
          TST
          JPF  _edln02
          JSR  inc_r6
          SAP  
          JSR  print_char
          INC  R2
          LDA  R2
          CMP  #0x40
          JPF  _edln02
          DEC  R1
          TST  R1
          JNF  _edln01
          JSR__inc_ptr
_edln02   LDA  R2
          JSR  begin_esc_seq
          LDA  #0x44
          JSR  print_char
#ifdef BETTER_LINEINPUT
          ;remove space characters from the end of the buffer
          LDA  R2
          JSR  _inps23
_edln03   TST  R2
          JPF  _edln04
          JSR  dec_ptr
          LAP
          CMP  #0x20
          JNF  _edln04
          DEC  R2
          JMP  _edln03
#endif
_edln04   LD   R7_L,#0
          LD   R1,#0
          JMP  _forth_inpstr
#endif

#ifndef ROM_16KB
begin_esc_seq:
          ; Begin an escape sequence: ESC [ number
          ; The number is in accu.
          PHL
          JSR  psh_r4
          PSH
          LDA  #0x1B
          JSR  print_char
          LDA  #0x5B
          JSR  print_char
          POP  R4_L
          LD   R4_H,#0
          JSR  print_decword
          JSR  pop_r4
          RTS
#endif

input_string:
          ;@API Input
          ; Read a string from terminal (entered by user)
          ; The read string will be terminated with a trailing zero, thus
          ; a maximum of R0 - 1 characters can be entered on the terminal.
          ; In: R0 = buffersize,
          ;     R4_L,R4_H = ptr to destination buffer,
          ; Out: entered string in destination buffer
          ; Changes: ACCU, R0, R1, R2, R3, R5, R6, R7, PTR
#if defined(MY4TH_NFD) && !defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  FDVECT_READSTR
#endif
          PHL
          LD   R2,#0      ; R2 = entered string length
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  _inputstr_lcd
#endif
          LD   R1,#0      ; R1 = cursor position
_forth_inpstr:
          JSR  ld_ptr_r4  ; R4 = ptr to beginning of input buffer
          LD   R3,R0      ; R3 = max buffer size
          DEC  R3         ; PTR = R4 + R1
          JMP  INPSTR_VECTOR  ;will usually jump to input_str_loop

input_str_loop:
_inps01   ;input loop
          PSH  R1
          JSR  inp_readkey
          POP  R1
          CMP  #KCODE_BS
          JPF  _in_del
          CMP  #KCODE_LEFT
          JPF  _crsrL
          CMP  #KCODE_RIGHT
          JPF  _crsrR
          CMP  #KCODE_DEL
#ifdef BETTER_LINEINPUT
          JPF  _in_delr
#else
          JPF  _inps01
#endif
          STA  R0
          ;AND  #0xE0
          AND  #0x60	; if 0..31 or 128..159 (special keys)
          TST
          JNF  _inps22  ; character >= 32 (it is printable)
          LDA  R0
          CMP  #0x0D
#ifdef BETTER_LINEINPUT
          JPF  _in_ent
          CMP  #KCODE_HOME
          JPF  _in_home
          CMP  #KCODE_END
          JNF  _inps01

_in_end   ;end-key was pressed
          LDA  R2
          SU   R1
          TST
          JPF  _inps01
          LD   R1,R2
          JSR  begin_esc_seq
          LDA  #0x43
          JSR  print_char
          LDA  R2
          JSR  _inps23
          JMP  _inps01
_inps23   AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  ret_opc
          INC  PTR_H
          RET

_in_home  ;home-key was pressed
          TST  R1
          JPF  _inps01
          LDA  R1
          LD   R1,#0
          JSR  psh_r4
          JMP  _inps09
#else
          JNF  _inps01
#endif
_in_ent   ;"ENTER" was pressed
          ;----
          ;Bugfix v1.4: ensure that the cursor is in the last column
          LDA  R2
          SU   R1
          TST
          JPF  _inps08
#ifdef ROM_16KB
          STA  R0
          JSR  psh_ptr
_inps21   LD   PTR_L,#<text_right
          LD   PTR_H,#>text_right
          JSR  print_str
          JLP  _inps21
          JSR  pop_ptr
#else
          JSR  begin_esc_seq
          LDA  #0x43
          JSR  print_char
#endif
_inps08   ;----
          ;append zero to the buffer and return
          LDA  R4_L
          AD   R2
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inps07
          INC  PTR_H
_inps07   LDA  #0
          SAP
          RTS

_inps22   ;check if there is still some space in the buffer
          LDA  R1
          CMP  R3
          JPF  _inps01  ; no space left
#ifdef BETTER_LINEINPUT
          ;write character (R0) into buffer and increment cursor position
          CMP  R2
          JPF  _inps12
          ;check if there is still space for inserting a new character
          LDA  R2
          CMP  R3
          JNF  _inps17
          ;no space left, check if a space character is at the end of the line
          JSR  psh_ptr
          LDA  R2
          DEC
          JSR  _inps23
          LAP
          JSR  pop_ptr
          CMP  #0x20
          JNF  _inps01  ; no space at end of line
          ;decrement line length (drop the space character)
          DEC  R2
          LDA  R1
          CMP  R2
          JPF  _inps12
_inps17   ;the cursor is within the line, move rest of the line one character to the right
          LDA  R0
          JSR  print_char
          ;do in a loop: *PTR+1 = *PTR
          JSR__inc_ptr
          JSR  psh_ptr
          LDA  R2
          SU   R1
          STA  R5_L ; number of characters to move to the right side
          STA  R5_H
          LDA  R2
          AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inps14
          INC  PTR_H
_inps14   ;PTR points to last character +1
          JSR  dec_ptr
          JSR__lap_inc_ptr
          SAP
          JSR  dec_ptr
          DEC  R5_L
          TST  R5_L
          JNF  _inps14
          ;store the new character
          LDA  R0
          SAP
          ;print the part of the line that was moved to the right
          LD   R5_L,R5_H
_inps15   JSR__inc_ptr_lap
          JSR  print_char
          DEC  R5_L
          TST  R5_L
          JNF  _inps15
          ;increment cursor position and input length
          INC  R2
          INC  R1
          ;move cursor left to the actual cursor position
          PSH  R5_H
          JMP  _inps16
#else
          ;write character (R0) into buffer and increment cursor position
          CMP  R2
          JNF  _inps03
#endif
_inps12   INC  R2
_inps03   INC  R1
          LDA  R0
          JSR  sap_inc_ptr
          ;print character and loop
          JSR  print_char
          JMP  _inps01

_in_del   ;"Delete / Backspace" was pressed
          ;delete works only at the end of the entered line
          TST  R1
          JPF  _inps01    ; no character at left side of cursor
          LDA  R1
          CMP  R2
          JNF  _delLeft   ; do "cursor left" (or delete character)
          ;remove last character from buffer
          DEC  R1
          DEC  R2
          JSR  dec_ptr
          ;send ESC-sequence to delete a character and move cursor left
          JSR  psh_ptr
          LD   PTR_L,#<text_backsp
          LD   PTR_H,#>text_backsp
_inps04   JSR  print_str
_inps10   JSR  pop_ptr
          JMP  _inps01

_delLeft  ;delete character at left side of cursor
#ifdef BETTER_LINEINPUT
          ;move cursor left, remove one character from the buffer
          DEC  R1
          DEC  R2
          JSR  dec_ptr
          JSR  psh_ptr
          LD   PTR_L,#<text_left
          LD   PTR_H,#>text_left
          JSR  print_str
          JSR  pop_ptr
          ;Loop: Go from PTR to end of buffer (R2),
          ;copy *PTR := *(PTR+1), emit char *PTR
_inps19   LDA  R2
          SU   R1
          STA  R0
          ;R0/ACCU = number of bytes to copy and to print
          JSR  psh_ptr
          INC
          PSH  ; remember R0+1 (need to print this amount of cursor left's)
          TST  R0
          JPF  _inps20
_inps11   JSR__inc_ptr_lap
          PSH
          JSR  dec_ptr
          JSR  sap_inc_ptr
          POP
          JSR  print_char
          JLP  _inps11
          ;overwrite last character with space
_inps20   JSR  print_space
_inps16   ;move cursor left
          POP
_inps09   JSR  begin_esc_seq
          LDA  #0x44
          JSR  print_char
          JMP  _inps10
_in_delr  ;delete character under the cursor
          LDA  R1
          CMP  R2
          JPF  _inps01  ; no charcter under the cursor
          DEC  R2
          JMP  _inps19
#endif
_crsrL    ;"Cursor left"
          TST  R1
          JPF  _inps01  ; no character at left side of cursor
          DEC  R1
          JSR  dec_ptr
          JSR  psh_ptr
          LD   PTR_L,#<text_left
          LD   PTR_H,#>text_left
          JMP  _inps04

_crsrR    ;"Cursor right"
          LDA  R1
          CMP  R2
          JPF  _inps01  ; cursor is already at right most position
          INC  R1
          JSR__inc_ptr
          JSR  psh_ptr
          LD   PTR_L,#<text_right
          LD   PTR_H,#>text_right
          JMP  _inps04

#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
_inputstr_lcd:
          ;input a string on the LCD
          ;max. line length is 40 character
          ;Input:
          ;  R0 = buffer size
          ;  R4 = ptr to beginning of the buffer
          DEC  R0
          LD   R7_L,LIB_LCDPOSX ; R7_L = left x-position of input field
          LDA  #39   ;right most screen position, this is 39 on a 40x4 LCD
          SU   R7_L
          STA  R7_H  ;R7_H = maximum length of the input string
          SU   R0
          JNF  _inpl01
          LD   R7_H,R0
_inpl01   ;R7_L = left x-position of input field
          ;R7_H = max. buffer length / input length
          ;R4 = ptr to beginning of the buffer
          ;R2 = cursor position
          ;R3 = current length of the string
          JSR  ld_ptr_r4
          LDA  #0
          ;STA  R2   ;already set to zero in the code above (input_string)
          STA  R3
          SAP
         
_inpl02   ;print input buffer and position the cursor
          LDA  R7_L
          JSR  _inpl16
          JSR  ld_ptr_r4
_inpl04   JSR__lap_inc_ptr
          TST
          JPF  _inpl03
          JSR  lcd_out_ch
          JMP  _inpl04
_inpl03   LDA  #0x20
          JSR  lcd_out_ch

_inpl12   ;position the cursor
          LDA  R2
          JSR  _inpl15

_inpl05   ;read next key
          PSH  R7_L
          PSH  R7_H
          JSR  inp_readkey
          POP  R7_H
          POP  R7_L
          
          CMP  #KCODE_LEFT
          JPF  _inpl06
          CMP  #KCODE_RIGHT
          JPF  _inpl07
          CMP  #13
          JPF  _inpl08
          CMP  #8
          JPF  _inpl09
          
          ;check if character is printable
          STA  R1
          LDA  #0x60
          AND  R1
          TST
          JPF  _inpl05
          ;print it
          ;1. check if there is "space" at the end of the line
          LDA  R3
          CMP  R7_H
          JPF  _inpl05  ;no space, ignore this keypress
          ;2. move rest of the line to the right to insert space for the new character
          LDA  R3
          AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inpl10
          INC  PTR_H
_inpl10   LDA  R3
          SU   R2
          INC   ;move also the terminating zero at the end of the string
          STA  R0
_inpl11   JSR__lap_inc_ptr
          SAP
          JSR  dec_ptr
          JSR  dec_ptr
          JLP  _inpl11
          ;3. write character into memory and print out the new line
          JSR__inc_ptr
          LDA  R1
          SAP
          INC  R2
          INC  R3
          JMP  _inpl02

_inpl06   ;cursor left
          TST  R2
          JPF  _inpl05
          DEC  R2
          JMP  _inpl12

_inpl07   ;cursor right
          LDA  R2
          CMP  R3
          JPF  _inpl05
          INC  R2
          JMP  _inpl12

_inpl09   ;delete
          TST  R2
          JPF  _inpl05
          LDA  R2
          AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inpl13
          INC  PTR_H
_inpl13   LDA  R3
          SU   R2
          STA  R0
          INC  R0  ;move also the terminating zero at the end of the string
_inpl14   LAP
          JSR  dec_ptr
          JSR  sap_inc_ptr
          JSR__inc_ptr
          JLP  _inpl14
          DEC  R2
          DEC  R3
          JMP  _inpl02

_inpl15   ;set cursor to offset in accu
          AD   R7_L
_inpl16   STA  R0
          LD   R1,LIB_LCDPOSY
          JMP  lcd_gotoxy

_inpl08   ;return
          LDA  R3
          JSR  _inpl15
          RTS
#endif


;pr_nibble:
;          ; Print a single hex-nibble
;          ; In: nibble in ACCU
;          SU   #10
;          JPF  _prnib2
;          ADD  #3Ah
;          JMP  uart_xmit
;_prnib2   ADD  #40h
;          JMP  uart_xmit
;
;pr_hexbyte:
;          ;@API Printing
;          ; Print a byte in hexadecimal
;          ; In: byte in ACCU
;          ; Changes: ACCU
;          PHL
;          PSH  ACCU
;          CLC
;          ROR
;          CLC
;          ROR
;          CLC
;          ROR
;          CLC
;          ROR
;          JSR  pr_nibble
;          POP  ACCU
;          AND  #0Fh
;          JSR  pr_nibble
;          POP  LR_H
;          POP  LR_L
;          RET

SEG_PRGCODE
