
;------------------------------------------------------------------------------
; Edit
;------------------------------------------------------------------------------


ED2_WINX    SET LIB_BUF+0  ; first row of a line shown on the LCD (0-26) (LCD window top-left X-coordinate)
ED2_WINY    SET LIB_BUF+1  ; first line shown on the LCD (0 - 17) (LCD window top-left Y-coordinate)
ED2_LINE    SET LIB_BUF+2  ; current line, can be 0 - 17, 0 and 17 = head and bottom line, others = screen line
ED2_XPOS    SET LIB_BUF+3  ; position within a line (0 to 63, or 0 to 3 in head and bottom line)
ED2_SCRNUM  SET LIB_BUF+4  ; block/screen number (2 bytes)
ED2_SCRBUF  SET LIB_BUF+6  ; ptr to block buffer (2 bytes)
ED2_SXPOS   SET LIB_BUF+8  ; saved value of ED2_XPOS before activation of the menu line
ED2_LCDUPD  SET LIB_BUF+9  ; LCD update flag: 0=set only cursor, 0x80=update current line, others: update whole display,
ED2_TOUCH   SET LIB_BUF+10 ; Flag: nonzero when screen was modified

CHAR_ALEFT  SET 3
CHAR_ARIGHT SET 4


w_list    ; LIST ( n -- )
          TST  LIB_LCDOUT
          JPF  c_list
          ;update SCR
          PHL
          JSR__rom_pop_data_R5
          LD   SCR_L,R5_L
          LD   SCR_H,R5_H
          JSR__rom_push_data_R5	; push screen number back into dstack          
          JMP  _ce_entry

w_edit    ; EDIT ( n -- )
          TST  LIB_LCDOUT
          JPF  c_edit
          PHL
_ce_entry LD   PTR_L,#<text_loading
          LD   PTR_H,#>text_loading
          JSR  rom_print_str
          JSR  c_emptybu
          JSR  c_dup
          JSR  c_block
          JSR  c_dup
          JSR  mkprintable
          ;on stack: blocknmbr, buffer
          
          JSR__rom_pop_data_R4
          LD   ED2_SCRBUF+0,R4_L
          LD   ED2_SCRBUF+1,R4_H
          JSR__rom_pop_data_R4
          LD   ED2_SCRNUM+0,R4_L
          LD   ED2_SCRNUM+1,R4_H
          
          ;initialize the LCD
          LD   PTR_L,#<ed2_chars
          LD   PTR_H,#>ed2_chars
          LD   R0,#CHAR_ALEFT
          LD   R1,#2
          JSR  lcd_load_charset
          JSR  lcd_clear
          
          ; clear ED2_PASTEBUF
          LD   R4_L,#<ED2_PASTEBUF
          LD   R4_H,#>ED2_PASTEBUF          
          JSR__rom_push_data_R4		; ( from-addr )
          LD   R4_L,#64
          LD   R4_H,#0
          JSR__rom_push_data_R4		; ( from-addr length=64 )
          LD   R4_L,#0x20			; R4_H already 0
          JSR__rom_push_data_R4		; ( from-addr 64 char=SPACE )
          JSR  c_fill         
          
          ;make string from screen number
          LD   R4_L,ED2_SCRNUM+0
          LD   R4_H,ED2_SCRNUM+1
          JSR  convert_16bit_to_decimal
          LD   PTR_L,#<(NUM_BUF+3)
          LD   PTR_H,#>(NUM_BUF+3)
          LDA  LIB_BUF+2
          JSR__sap_inc_ptr
          LDA  LIB_BUF+3
          JSR__sap_inc_ptr
          LDA  LIB_BUF+4
          SAP

          ;initialize the editor
          LDA  #0
          STA  ED2_WINX
          STA  ED2_WINY
          STA  ED2_XPOS
          STA  ED2_TOUCH
          LDA  #1
          STA  ED2_LINE
          STA  ED2_LCDUPD

          ;Main loop
          ;update display and set the cursor
          ;depending on the state of the ED2_LCDUPD-flag
_cedit201 INC  ED2_LCDUPD
_cedit200 TST  ED2_LCDUPD
          JPF  _cedit219
          LDA  ED2_LCDUPD
          CMP  #0x80
          JNF  _cedit218
          LD   R0,ED2_LINE
          LD   R1,LIB_LCDPOSY
          JSR  _c_ed2_prline
          JMP  _cedit229
_cedit218 JSR  _c_ed2_updDisplay
_cedit229 LD   ED2_LCDUPD,#0
_cedit219 JSR  _c_ed2_setCursor
_cedit202 ;wait for keypress and get the key code
          JSR  rom_readkey ;blocking read-key function, reads from keyboard and UART or over a vector
          STA  R3 ;save a copy of the key code in R3
          CMP  #KCODE_PGUP			;Shift+Up: up 4 lines
          JPF  _ce_pgup
          CMP  #KCODE_PGDOWN		;Shift+Down: down 4 lines
          JPF  _ce_pgdn
          CMP  #KCODE_HOME			;Shift+Left: return to line start
          JPF  _ce_home
          CMP  #KCODE_END			;Shift+Right: go to line end
          JPF  _ce_end
          CMP  #KCODE_LEFT
          JPF  _ce_left
          CMP  #KCODE_RIGHT
          JPF  _ce_right
          CMP  #KCODE_UP
          JPF  _ce_up
          CMP  #KCODE_DOWN
          JPF  _ce_down
          JSR  _c_ed2_isMenuLine
          LDA  R3
          JPF  _ce_menu
          CMP  #KCODE_ENTER
          JPF  _ce_ent          
          CMP  #KCODE_CENTER		;Ctrl+Enter: insert line after current line
          JPF  _ce_ins_l			;Insert a line
          CMP  #KCODE_SENTER		;Shift+Enter: break current line
          JPF  _ce_brk_l			;Break a line
          
          CMP  #KCODE_CC			;Ctrl+C: Copy a line
          JPF  _ce_cpy_l
          CMP  #KCODE_CK			;Ctrl+K: Delete current line
          JPF  _ce_del_l
          CMP  #KCODE_CU			;Ctrl+U: Undelete a line
          JPF  _ce_und_l
          CMP  #KCODE_CSPACE		;Ctrl+Space: Clear current line
          JPF  _ce_clr_l
          CMP  #KCODE_CBS			;Ctrl+Backspace: merge current line with previous line
          JPF  _ce_mrg_l
          
          CMP  #KCODE_BS
          JPF  _ce_bksp
          
          ;check if character is printable
          LDA  #0xE0
          AND  R3
          TST
          JPF  _cedit202
          ;print it
          ;1. check if there is "space" at the end of the line
          LD   R1,#63
          JSR  _c_ed_calcCurMemLinePtr
          LAP
          CMP  #0x20
          JNF  _cedit202  ;no space, ignore this keypress
          ROR  ED2_TOUCH  ;set flag
          ;2. move rest of the line to the right to insert space for the new character
          LDA  #63
          SU   ED2_XPOS
          TST
          JPF  _cedit220
          STA  R0
_cedit221 JSR  dec_ptr
          JSR__lap_inc_ptr
          SAP
          JSR  dec_ptr
          JLP  _cedit221
          ;3. write character into memory
_cedit220 LDA  R3
          SAP
          ;update at least the current line in the display
          LD   ED2_LCDUPD,#0x80
          ;move cursor to the right
          JMP  _ce_right
          
_ce_menu  ;handle the MENU
          CMP  #KCODE_ENTER
          JNF  _cedit202
          LDA  ED2_XPOS
          TST
          JPF  _cedit225
          CMP  #1
          JPF  _cedit226
          CMP  #2
          JPF  _cedit227
          
          ;clear screen
          LD   R4_L,ED2_SCRBUF+0
          LD   R4_H,ED2_SCRBUF+1
          JSR__rom_push_data_R4
          JSR _c_clearScreen
          JMP  _cedit218
          
_cedit225 ;save
          JSR  _cedit228
          JMP  _cedit218
          
_cedit226 ;save + quit
          JSR  _cedit228
          JMP  _cedit300
          
_cedit228 ;save screen and return
          PHL
          JSR  lcd_clear
          LD   PTR_L,#<text_saving2
          LD   PTR_H,#>text_saving2
          JSR  rom_print_str
          JSR  print_nl
          JSR  c_update
          JSR  c_savebuf
          RTS
          
_ce_bksp  ;handle deletion of a character
          TST  ED2_XPOS
          JPF  _cedit202  ;nothing to delete, ignore this keypress. 
          LD   ED2_LCDUPD,#0x80
          LD   R1,ED2_XPOS
          JSR  _c_ed_calcCurMemLinePtr
          LDA  #63
          STA  ED2_TOUCH
          SU   ED2_XPOS
          STA  R0
          TST  R0
          INC  R0
          JNF  _cedit224
          LAP
          CMP  #0x20
          JPF  _cedit224
          LDA  #0x20
          SAP
          JMP  _cedit200
_cedit223 JSR__inc_ptr
_cedit224 LAP
          JSR  dec_ptr
          JSR__sap_inc_ptr
          JLP  _cedit223
          LDA  #0x20
          SAP
          
_ce_left  ;cursor left
          TST  ED2_XPOS
          JPF  _cedit202
          JSR  _c_ed2_isMenuLine
          LDA  ED2_XPOS
          DEC  ED2_XPOS
          JPF  _cedit201
          CMP  ED2_WINX
          JNF  _cedit200
          LD   ED2_WINX, #0
          JMP  _cedit201


_ce_home  TST  ED2_XPOS 			;Shift+Left: return to line start
          JPF  _cedit202
          JSR  _c_ed2_isMenuLine
          JPF  _cedit200
          LDA  ED2_WINX
          LD   ED2_XPOS, #0
          LD   ED2_WINX, #0
          TST
          JPF  _cedit200
          JMP  _cedit201

_ce_end   JSR  _c_ed2_isMenuLine	;Shift+Right: go to line end
          JPF  _cedit200
          
          JSR  get_curline_actual_end_pos
          TST  R1
          JPF  _cedit254			;if R1=0, do not INC R1
          LDA  #63
          CMP  R1
          JPF  _cedit254  ; if at last pos, do not INC R1
          INC  R1	; if R1!=0 and R1!=63, cursor at pos after last character

          ;last char pos in R1
_cedit254 LD   ED2_XPOS, R1
          JSR  set_winx_by_xpos
          JMP  _cedit201
          
                    
_ce_right ;cursor right
          JSR  _c_ed2_isMenuLine
          LDA  ED2_XPOS
          JNF  _cedit209
          CMP  #3
          JPF  _cedit202
          INC  ED2_XPOS
          JMP  _cedit201
_cedit209 CMP  #63
          JPF  _cedit200 ;print entered character without scrolling to the right
          INC  ED2_XPOS
          LDA  ED2_XPOS
          CMP  #37
          JNF  _cedit200
          LD   ED2_WINX, #27
          JMP  _cedit201

_ce_pgup  DEC  ED2_LINE		; Shift+Up: up 4 lines
          DEC  ED2_LINE
          DEC  ED2_LINE
          DEC  ED2_LINE
          ; ED2_LINE in #1..#16
          LDA  #1
          SU   ED2_LINE		; if 1-ED2_LINE>=0 set flag
          JPF  _cedit255	; if ED2_LINE<=1: set ED2_LINE=1
          LDA  #16
          SU   ED2_LINE		; if 16-ED2_LINE>=0 set flag
          JNF  _cedit255	; if ED2_LINE>16: set ED2_LINE=1
          JMP  _cedit251
_cedit255 LD   ED2_LINE, #1 ; if not (>1 and <=16): set ED2_LINE=1
          JMP  _cedit251
          
_ce_up    ;cursor up
          TST  ED2_LINE
          JPF  _cedit202
          JSR  _c_ed2_isMenuLine
          LDA  ED2_LINE
          DEC  ED2_LINE
          JNF  _cedit212
_cedit213 LD   ED2_XPOS,ED2_SXPOS
          JMP  _cedit201
_cedit212 CMP  ED2_WINY
          JNF  _cedit230 ;_cedit200
          
          ; scroll a page when cursor out of screen          
_cedit251 DEC  ED2_WINY
          DEC  ED2_WINY
          DEC  ED2_WINY
          DEC  ED2_WINY
          LDA  #14
          SU   ED2_WINY
          JPF  _cedit211
          LD   ED2_WINY,#0
          
_cedit211 JSR  _cedit214
          JMP  _cedit201
          
_cedit214 ;enter menu-line, return with FLAG=1 when display must be updated
          PHL
          JSR  _c_ed2_isMenuLine
          JNF  rts_opc
          LD   ED2_SXPOS,ED2_XPOS
          LD   ED2_XPOS,#1
          TST  ED2_TOUCH
          JNF  return_flag_1
          INC  ED2_XPOS
          RTS

_ce_pgdn  INC  ED2_LINE		;Shift+Down: down 4 lines
          INC  ED2_LINE
          INC  ED2_LINE
          INC  ED2_LINE
          LDA  #16
          SU   ED2_LINE		 ; if 16-ED2_LINE>=0 set flag
          JPF  _cedit252     ; if ED2_LINE<=16 goto _cedit252
          LD   ED2_LINE, #16 ; else set ED2_LINE=16
          JMP  _cedit252

_ce_mrg_l ; merge current line with previous line
          ; 1. at line #2..#16
          LDA  ED2_LINE
          CMP  #1
          JPF  _cedit200	; at line #1: exit
          STA  ED2_TOUCH
          ; 2. get sum of two line lengths
          JSR get_curline_actual_end_pos	;line length in R1, current line number in R2
          LD   R4_H, #0
          LD   R4_L, R1
          
          DEC  R2
          JSR  get_line_actual_end_pos	;line length in R1
          JSR__inc_ptr
          LD   R5_H, PTR_H
          LD   R5_L, PTR_L       
          LDA  R1
          AD   R4_L		; sum of two line lengths in ACCU, curline_actual_end in R4
          SU   #63
          JPF  _cedit201	; if f sum of two line lengths > 64, exit
          LD   ED2_XPOS, R1
          
          ; 3. if sum of two line lengths <= 64
          ; now curline_actual_end in R4, prev_line_end in R5
          ; 3.1 c_move ( from_addr=cur_line_start_pos, to_addr=prev_line_end, length=curline_actual_end )
          LD   R1,#0
          JSR  _c_ed_calcCurMemLinePtr

          JSR__push_data_PTR	; ( current_line_start_pos )
          JSR__rom_push_data_R5		; ( current_line_start_pos prev_line_end )
          INC  R4_L
          JSR__rom_push_data_R4		; ( current_line_start_pos prev_line_end curline_actual_end )
          JSR  c_move
          ; 3.2 delete current line
          JSR  del_current_line 
          
          INC  ED2_XPOS
          DEC  ED2_LINE    
          LD   ED2_WINX, #0
          LDA  ED2_XPOS
          SU   #37
          JNF  _cedit201
          LD   ED2_WINX, #27   
          JMP  _cedit201
          
_ce_cpy_l ; copy current line
          JSR  copy_current_line
          ; LD   R1,#0
          ; JSR  _c_ed_calcCurMemLinePtr
          ; JSR__push_data_PTR	; ( current_line_start_pos ) 
          ; JSR  copy_line
          JMP  _cedit200

_ce_clr_l ; clear current line
          LD   R1,#0
          JSR  _c_ed_calcCurMemLinePtr
          JSR__push_data_PTR	; ( current_line_start_pos )          
          JSR__push_data_PTR	; ( current_line_start_pos current_line_start_pos )
          JSR  copy_line
          JSR  clear_line
          JMP  _cedit201

_ce_del_l ; delete current line
          ; 1. copy current line to buffer
          JSR  copy_current_line
          JSR  del_current_line       
          JMP  _cedit201
          
_ce_und_l ; undelete(paste) a line
          JSR  is_last_line_empty
          JNF  _cedit200 ; if last line is not empty, no operation
          LDA  ED2_LINE
          STA  ED2_TOUCH
          CMP  #16
          JNF  _cund_01          ; _cund_01: not at line #16
          ; at line #16: get line start pos
          LD   R1,#0
          JSR  _c_ed_calcCurMemLinePtr  ;buffer pointer in PTR        
          JMP  _cund_02
          
          ; if not at line #16, Insert an empty line after current line
_cund_01  JSR  insert_empty_line
          LDA  ED2_LINE
          INC
          LD   R1, #0
          JSR  _c_ed_calcMemLinePtr ; get start pos of next line at PTR
          
          ; c_move: ( from-addr=ED2_PASTEBUF to-addr=next_line_start_pos  length=64 )
_cund_02  LD   R4_L,#<ED2_PASTEBUF
          LD   R4_H,#>ED2_PASTEBUF          
          JSR__rom_push_data_R4		; ( ED2_PASTEBUF )

          JSR__push_data_PTR		; ( ED2_PASTEBUF line_start_pos )

          LD   R4_L,#64
          LD   R4_H,#0
          JSR__rom_push_data_R4		; ( ED2_PASTEBUF line_start_pos 64 )
          JSR  c_move
                    
          JMP  _ceent_us
          
_ce_brk_l ; Break a line at cursor
          LDA  ED2_LINE
          STA  ED2_TOUCH
          CMP  #16			 ; if at line 16, return
          JPF  _cedit201
          JSR  is_last_line_empty
          JNF  _ce_ent ; if last line is not empty, invoke Enter
          
          
          ; 1. Insert an empty line after current line
          JSR  insert_empty_line

          
          ; 2. c_move: ( from-addr=current_cursor_pos to-addr=next_line_start_pos length=current_cursor..line_end )

          ; calculate current cursor pos
          LD   R1,ED2_XPOS
          JSR  _c_ed_calcCurMemLinePtr

          ; calculate bytes from cur-cursor-pos to line end
          LDA  #64
          SU   ED2_XPOS
          STA  R5_L
          LD   R5_H, #0

          JSR__push_data_PTR	; ( cur-cursor-pos )
          JSR__rom_push_data_R5		; ( cur-cursor-pos length )
          JSR__push_data_PTR	; ( cur-cursor-pos length cur-cursor-pos )
          
          ; calculate leading spaces of next line
          LDA  ED2_LINE
          JSR  get_line_actual_start_pos	; return start_pos in ACCU
          STA  R1
          ; If ACCU>ED2_XPOS, use ED2_XPOS, else use start_pos
          SU   ED2_XPOS
          JNF  _cbkl_01
          LD   R1, ED2_XPOS
_cbkl_01  LDA  ED2_LINE
          INC
          JSR  _c_ed_calcMemLinePtr

          JSR__push_data_PTR	; ( cur-cursor-pos length cur-cursor-pos nextl-start-pos )          
          JSR__push_data_R5		; ( cur-cursor-pos length cur-cursor-pos nextl-start-pos length )

          JSR  c_move 			; ( cur-cursor-pos length cur-cursor-pos nextl-start-pos length -- cur-cursor-pos length )

          ; 3. clear current_cursor..line_end
          LD   R4_L,#0x20
          LD   R4_H,#0
          JSR__rom_push_data_R4		; ( cur-cursor-pos length char=SPACE )
          JSR  c_fill
          
          JMP  _ceent_us
          
_ce_ins_l ; Insert line
          LDA  ED2_LINE
          SU   #15
          JPF  _ce_ent ; if at line #15 and #16, invoke Enter
          JSR  is_last_line_empty
          JNF  _ce_ent ; if last line is not empty, invoke Enter
          
          JSR  insert_empty_line
          
_ceent_us INC  ED2_LCDUPD	; update whole screen after loop
          ; continue: _ce_ent
          
_ce_ent   ; Enter
          ;LD   R3, #KCODE_ENTER	; DO NOT CHANGE R3 !
          LDA  ED2_LINE
          CMP  #16			 ; if at line 16, do not cursor down
          JPF  _cedit201
          LD   ED2_WINX,#0
          LD   ED2_XPOS,#0
          
          ; get start pos of next line
          LDA  ED2_LINE
          INC
          JSR  get_line_actual_start_pos
          JNF  _ce_ent01 ; if next line is not empty, move cursor to start position (first non-space character) of next line

          ; if next line is empty
          ; calculate leading spaces of current line
          JSR  get_curline_actual_start_pos	; number of leading spaces in ACCU
_ce_ent01 STA  ED2_XPOS
          JSR  set_winx_by_xpos
          ; continue: _ce_down
          
_ce_down  ;cursor down
          LDA  ED2_LINE
          CMP  #17
          JPF  _cedit202
          TST  ED2_LINE
          INC  ED2_LINE
          JPF  _cedit213
          SU   #3
          CMP  ED2_WINY
          JNF  _cedit216
          
          ; scroll a page when cursor out of screen
_cedit252 INC  ED2_WINY
          INC  ED2_WINY
          INC  ED2_WINY
          INC  ED2_WINY
          LDA  #14
          SU   ED2_WINY
          JPF  _cedit211
          LD   ED2_WINY,#14
          
          JMP  _cedit211
_cedit216 LDA  #KCODE_ENTER
          CMP  R3
          JPF  _cedit211
_cedit230 JSR  _cedit214
          JPF  _cedit201
          JMP  _cedit200

; ---------------------------------------------------------------------------------

_c_ed2_setCursor:
          ;set cursor to current position
          PHL
          JSR  _c_ed2_isMenuLine
          JNF  _ced2sc01
          LD   R0,R4_L
          INC  R0
          JMP  _ced2sc02
_ced2sc01 LDA  ED2_XPOS
          SU   ED2_WINX
          INC
          INC
          STA  R0
_ced2sc02 LDA  ED2_LINE
          SU   ED2_WINY
          STA  R1
          JSR  lcd_gotoxy
          RTS

_c_ed2_updDisplay:
          ;update the display, print out all lines
          PHL
          LD   R5_L,#0
          LD   R5_H,ED2_WINY
_ced2upd1 LD   R1,R5_L
          LD   R0,R5_H
          JSR  _c_ed2_prline
          INC  R5_H
          INC  R5_L
          LDA  R5_L
          CMP  #4
          JNF  _ced2upd1
          RTS

_c_ed2_isMenuLine:
          LDA  ED2_LINE
_c_ed2_isMLaccu:
          ;Check if the line number in ACCU is line 0 or line 17.
          TST
          JPF  ret_opc
          CMP  #17
          RET

_c_ed_calcCurMemLinePtr:
          LDA  ED2_LINE
          ;In:      ACCU:Line num(#1..#16), R1:x pos 
          ;Out:     buffer pointer in PTR
          ;Changes: ACCU, R0, PTR          
_c_ed_calcMemLinePtr:  ;shared code
          DEC
          STA  PTR_L
          LD   PTR_H,#0
          LD   R0,#6
          CLC
_ced2pl16 RWL  PTR_L
          JLP  _ced2pl16
          LDA  R1
          AD   PTR_L
          AD   ED2_SCRBUF+0
          STA  PTR_L
          LDA  PTR_H
          ADD  ED2_SCRBUF+1
          STA  PTR_H
          RET
            
_c_ed2_prline:
          ;Print a text line to the screen
          ;In: R0 = line 0-17, R1 = LCD Y-position 0-3
          ;Out: In line 0 and line 17, R4_L is the position of the selected '<'
          PHL
          LD   R2,R0
          LD   R0,#0
          JSR  lcd_gotoxy
          LDA  R2
          JSR  _c_ed2_isMLaccu
          JPF  _ced2pl01
          ;print text line
          LD   LIB_LCDENAS, #LCDDTMD          
          ;1. print line number 
          ;Internal line number is 1..16(0 and 17 for status line)
          ;Print 0..F in accordance with convensions
          LDA  #10
          SU   R2
          JNF  _ced2pl11
          LDA  #0x2F
          AD   R2
          JMP  _ced2pl10
_ced2pl11 LDA  #'A'-11
          AD   R2
_ced2pl10 JSR  lcd_out_fch
          ;2. print | or <-
          LDA  #'|'
          TST  ED2_WINX
          JPF  _ced2pl13
          LDA  #CHAR_ALEFT
_ced2pl13 JSR  lcd_out_fch
          ;3. print the line
          LDA  R2
          LD   R1,ED2_WINX
          JSR  _c_ed_calcMemLinePtr
          LD   R0,#37
_ced2pl17 LAP
          INC  PTR_L
          TST  PTR_L
          JNF  _ced2pl18
          INC  PTR_H
_ced2pl18 JSR  lcd_out_fch
          JLP  _ced2pl17
          ;print last character '->' only if required 
          LDA  #27
          CMP  ED2_WINX
          LDA  #'|'
          JPF  _ced2pl15
          LDA  #CHAR_ARIGHT
_ced2pl15 JSR  lcd_out_fch
          RTS
_ced2pl01 ;print head/bottom-line
          LD   R3,#7
          LD   R2,ED2_XPOS
          JSR  _c_ed2_isMenuLine
          JPF  _ced2pl09
          LD   R2,#0x80
_ced2pl09 LD   PTR_L,#<NUM_BUF
          LD   PTR_H,#>NUM_BUF
          JSR  rom_print_str
          LD   PTR_L,#<text_ed_head
          LD   PTR_H,#>text_ed_head
_ced2pl02 JSR__lap_inc_ptr
          TST
          JPF  rts_opc
          TST  R2
          JNF  _ced2pl03
          JSR  is_alpha
          JNF  _ced2pl05  ;convert abc to ABC
          CMP  #'['
          JPF  _ced2pl08
          CMP  #']'
          JNF  _ced2pl06
          DEC  R2
          JMP  _ced2pl07
_ced2pl08 LD   R4_L,R3
_ced2pl07 SU   #0x1F      ;convert [/] to </>
          JMP  _ced2pl03
_ced2pl05 AND  #0xDF
_ced2pl03 CMP  #']'
          JNF  _ced2pl06
          DEC  R2
_ced2pl06 JSR  lcd_out_fch
          INC  R3
          JMP  _ced2pl02

_cedit227 ;quit
          JSR  lcd_clear
_cedit300 JSR  c_emptybu
          RTS

_c_clearScreen  ; ( bufaddr -- )
          ;fill screen buffer with spaces
          PHL
          LD   R4_L,#0
          LD   R4_H,#4
          LD   ED2_TOUCH,R4_H
          JSR__rom_push_data_R4
          LD   R4_L,#32
          LD   R4_H,#0
          JSR__rom_push_data_R4
          JSR  c_fill
          RTS

; convert non-printable characters to '?'
mkprintable ;input: buffer-ptr on stack
          PHL
          JSR__rom_pop_data_R4
          JSR  ld_ptr_r4
          LD   R1,#4
          LD   R0,#0
          LD   PAR2,#0x20
_mkpr01   LAP
          INC
          STA  R2
          ROL
          JPF  _mkpr03
          LDA  R2
          SUB  PAR2
          JPF  _mkpr04
_mkpr03   LDA  #'?'
          SAP
_mkpr04   INC  PTR_L
          TST  PTR_L
          JNF  _mkpr02
          INC  PTR_H
_mkpr02   JLP  _mkpr01
          DEC  R1
          TST  R1
          JNF  _mkpr01
          RTS

convert_16bit_to_decimal:
          PHL
          LD   PTR_H,#>(LIB_BUF+5)
          LD   PTR_L,#<(LIB_BUF+5)
          LD   R0,#5
_cnvd01   LD   R5_L,#10
          LD   R5_H,#0
          PSH  LIB_BUF+0
          PSH  LIB_BUF+1
          PSH  LIB_BUF+2
          PSH  LIB_BUF+3
          JSR  divide_u
          POP  LIB_BUF+3
          POP  LIB_BUF+2
          POP  LIB_BUF+1
          POP  LIB_BUF+0
          LDA  #0x30
          OR   R5_L
          JSR  dec_ptr
          SAP
          JLP  _cnvd01
          RTS

divide_u:
          ; Divide a 16-bit unsigned number by an other 16-bit unsigned number.
          ; In : R4 = divident, R5 = divisor
          ; Out: R4 = 16-bit result, R5 = 16-bit reminder
          ; Changes: ACCU, R4, R5
          LD   LIB_BUF+0,#0
          LD   LIB_BUF+1,#0
          PSH  R0
          CLC
          LD   R0,#16
_divi01   RWL  R4
          RWL  LIB_BUF+0
          LDA  LIB_BUF+0
          SU   R5_L
          STA  PAR1
          LDA  LIB_BUF+1
          SUB  R5_H
          JNF  _divi02
          LD   LIB_BUF+0,PAR1
          STA  LIB_BUF+1
_divi02   RWL  LIB_BUF+2
          JLP  _divi01
          POP  R0
          LD   R4_L,LIB_BUF+2
          LD   R4_H,LIB_BUF+3
          LD   R5_L,LIB_BUF+0
          LD   R5_H,LIB_BUF+1
          RET

; ------------------------------------------------------------------------

get_curline_actual_end_pos:
          LD  R2, ED2_LINE
get_line_actual_end_pos:
          ; In:		R2: 	line number
          ;	Out:	R1:	 	actual end pos (0..63)
          ; Changes:ACCU,R0,R1,PTR
          PHL
          LD   R1,#64          		
_gepos01  DEC  R1					;get last character which is not space
          TST  R1
          JPF  _gepos02				;if R1=0 break
          LDA  R2
          JSR  _c_ed_calcMemLinePtr
          LAP
          CMP  #0x20
          JPF  _gepos01  ; if space, loop
_gepos02  RTS

calc_length:
          ; In: ACCU
          ; Out: R4=(ACCU-ED2_LINE)*64
          SU   ED2_LINE
          STA  R4_L
          LD   R4_H,#0
          LD   R0,#6
          CLC
_e_cl01   RWL  R4_L
          JLP  _e_cl01         
          RET


          ; Insert an empty line after current line
insert_empty_line:	; ( -- )

          PHL
          LDA  ED2_LINE
          INC
          STA  ED2_TOUCH
          LD   R1, #0
          JSR  _c_ed_calcMemLinePtr ; get start pos of next line at PTR
          JSR__push_data_PTR		; ( from-addr )
          JSR  c_dup				; ( from-addr from-addr )

          ; calc to-addr and push it
          LDA  ED2_LINE
          INC
          INC
          LD   R1, #0
          JSR  _c_ed_calcMemLinePtr           	
          JSR__push_data_PTR	; ( from-addr from-addr to-addr )

          ; calc length and push it
          ; length=(15-ED2_LINE)*64
          LDA  #15
          JSR  calc_length
          JSR__rom_push_data_R4		; ( from-addr from-addr to-addr length )
          
          JSR  c_move ; ( from-addr from-addr to-addr length -- from-addr )

          ; fill next line with spaces 
          ; ( from-addr )
          JMP _cll01
          
clear_line:
          ;In: line start address in DSTACK
          PHL
_cll01    LD   R4_L,#64
          LD   ED2_TOUCH, R4_L
          LD   R4_H,#0
          JSR__rom_push_data_R4		; ( from-addr length=64 )
          LD   R4_L,#0x20			; R4_H already 0
          JSR__rom_push_data_R4		; ( from-addr 64 char=SPACE )
          JSR  c_fill
          RTS


set_winx_by_xpos:
          LDA  ED2_XPOS
          SU   #37
          LD   ED2_WINX, #0
          JNF  ret_opc
          LD   ED2_WINX, #27
          RET


; If last line is empty, set flag; else clear flag
is_last_line_empty:
          LDA  #16
          JMP  get_line_actual_start_pos 

get_curline_actual_start_pos:
          LDA  ED2_LINE
get_line_actual_start_pos:	; line number in ACCU          
          PHL
          LD   R1,#0
          JSR  _c_ed_calcMemLinePtr
          JMP  _gs03
get_spaces:	
          ; get number of spaces from PTR (max 64)
          ; In: 	PTR
          ; Out:	number of spaces in ACCU; if line is empty, ACCU=0, set flag; else clear flag
          ; Changes:PTR,ACCU,R0
          PHL
_gs03     LD   R0, #64
_gs01     LAP
          CMP  #0x20	; space
          JNF  _gs02	; if ch!=0x20 break
          JSR__inc_ptr
          JLP  _gs01
_gs02     LDA  #64
          SU   R0
          CMP  #64		; 64: empty
          JNF  rts_opc	; !=64: preserve flag and return
          LDA  #0		; ==64: preserve flag, ACCU=0, return
          RTS


copy_current_line:
          ;line number in ED2_LINE
          PHL
          LD   R1,#0
          JSR  _c_ed_calcCurMemLinePtr
          JSR__push_data_PTR	; ( current_line_start_pos ) 
          JMP  _cpl01
copy_line:
          ; In: line start address in DSTACK
          PHL
          ; c_move ( from-addr=current_line_start_pos to-addr=ED2_PASTEBUF length=64 )
_cpl01    LD   R4_L,#<ED2_PASTEBUF
          LD   R4_H,#>ED2_PASTEBUF          
          JSR__rom_push_data_R4		; ( current_line_start_pos ED2_PASTEBUF )
          LD   R4_L,#64
          LD   R4_H,#0
          JSR__rom_push_data_R4		; ( current_line_start_pos ED2_PASTEBUF 64 )
          JSR  c_move
          RTS
          
del_current_line:
          PHL
          ; 1. if not at line #16, c_move (from_addr=next_line_start, to_addr=current_line_start, length=(16-ED2_LINE)*64)
          LDA  ED2_LINE
          CMP  #16
          JPF  _cdel01		; _cdel01: at line #16

          INC				; current line in ACCU
          LD   R1,#0
          JSR  _c_ed_calcMemLinePtr
          JSR__push_data_PTR	; ( next_line_start )

          JSR  _c_ed_calcCurMemLinePtr
          JSR__push_data_PTR	; ( next_line_start current_line_start )

          ; length=(16-ED2_LINE)*64
          LDA  #16
          JSR  calc_length
          JSR__rom_push_data_R4		; ( next_line_start current_line_start length )
          
          JSR c_move
          
          ; 2. fill line #16 with spaces
_cdel01   LD   R1,#0
          LDA  #16
          JSR  _c_ed_calcMemLinePtr
          JSR__push_data_PTR	; ( line_#16_start_pos )
          JSR  clear_line 
          RTS
                                 