
keyb_inputstring:
          ;input a string on the LCD
          ;max. line length is 40 character
          ;Input:
          ;  R0 = buffer size
          ;  R4 = ptr to beginning of the buffer
          PHL
          LD   R2,#0      ; R2 = entered string length
          DEC  R0
          LD   R7_L,LIB_LCDPOSX ; R7_L = left x-position of input field
          LDA  #39   ;right most screen position, this is 39 on a 40x4 LCD
          SU   R7_L
          STA  R7_H  ;R7_H = maximum length of the input string
          SU   R0
          JNF  _inpl01
          LD   R7_H,R0
_inpl01   ;R7_L = left x-position of input field
          ;R7_H = max. buffer length / input length
          ;R4 = ptr to beginning of the buffer
          ;R2 = cursor position
          ;R3 = current length of the string
          JSR  ld_ptr_r4
          LDA  #0
          ;STA  R2   ;already set to zero in the code above (input_string)
          STA  R3
          SAP
         
_inpl02   ;print input buffer and position the cursor
          LDA  R7_L
          JSR  _inpl16
          JSR  ld_ptr_r4
_inpl04   JSR__lap_inc_ptr
          TST
          JPF  _inpl03
          JSR  lcd_out_ch
          JMP  _inpl04
_inpl03   LDA  #0x20
          JSR  lcd_out_ch

_inpl12   ;position the cursor
          LDA  R2
          JSR  _inpl15

_inpl05   ;read next key
          PSH  R7_L
          PSH  R7_H
          JSR  rom_readkey ;blocking read-key function, reads from keyboard and UART or over a vector
          POP  R7_H
          POP  R7_L
          
          CMP  #KCODE_LEFT
          JPF  _inpl06
          CMP  #KCODE_RIGHT
          JPF  _inpl07
          CMP  #13
          JPF  _inpl08
          CMP  #8
          JPF  _inpl09
          
          ;check if character is printable
          STA  R1
          LDA  #0x60
          AND  R1
          TST
          JPF  _inpl05
          ;print it
          ;1. check if there is "space" at the end of the line
          LDA  R3
          CMP  R7_H
          JPF  _inpl05  ;no space, ignore this keypress
          ;2. move rest of the line to the right to insert space for the new character
          LDA  R3
          AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inpl10
          INC  PTR_H
_inpl10   LDA  R3
          SU   R2
          INC   ;move also the terminating zero at the end of the string
          STA  R0
_inpl11   JSR__lap_inc_ptr
          SAP
          JSR  dec_ptr
          JSR  dec_ptr
          JLP  _inpl11
          ;3. write character into memory and print out the new line
          JSR__inc_ptr
          LDA  R1
          SAP
          INC  R2
          INC  R3
          JMP  _inpl02

_inpl06   ;cursor left
          TST  R2
          JPF  _inpl05
          DEC  R2
          JMP  _inpl12

_inpl07   ;cursor right
          LDA  R2
          CMP  R3
          JPF  _inpl05
          INC  R2
          JMP  _inpl12

_inpl09   ;delete
          TST  R2
          JPF  _inpl05
          LDA  R2
          AD   R4_L
          STA  PTR_L
          LD   PTR_H,R4_H
          JNF  _inpl13
          INC  PTR_H
_inpl13   LDA  R3
          SU   R2
          STA  R0
          INC  R0  ;move also the terminating zero at the end of the string
_inpl14   LAP
          JSR  dec_ptr
          JSR__sap_inc_ptr
          JSR__inc_ptr
          JLP  _inpl14
          DEC  R2
          DEC  R3
          JMP  _inpl02

_inpl15   ;set cursor to offset in accu
          AD   R7_L
_inpl16   STA  R0
          LD   R1,LIB_LCDPOSY
          JMP  lcd_gotoxy

_inpl08   ;return
          LDA  R3
          JSR  _inpl15
          RTS
