;When in ROM, codes in this file is after ROM_STRINGS, before aligned_tables.
;(included in my4th-main.asm)

#ifdef WITH_I2C_LCD_KYBD
lcd_kybd_utils_functions Segment Code
ORG strings_end

rom_i2c_start_addr SET i2c_start_addr
rom_i2c_send SET i2c_send
rom_i2c_recv SET i2c_recv
rom_i2c_stop SET i2c_stop
rom_readkey SET readkey

#endif

;------------------------------------------------------------------------------
; I2C Utils
;------------------------------------------------------------------------------

;I2C write register
;In: ACCU = content
;    R0 = I2C Address (R/W bit=0)
;    R1 = register
;    changes: ACCU, R0, R1
i2c_wr:
          PHL
          PSH  ACCU
          PSH  R1
          JSR  rom_i2c_start_addr	; R0 = I2C Address
          POP  R1    	 ; pop register
          JPF  _i2c_wr2  ; if error (flag set at JSR)
      
          JSR  rom_i2c_send ; send register
          POP  R1		; pop content
          JPF  _i2c_wr3  ; if error (flag set at JSR)
          
          JSR  rom_i2c_send ; send content
          JMP  _i2c_wr3

_i2c_wr2  POP	; pop unused content
_i2c_wr3  JSR  rom_i2c_stop     
          RTS

;I2C read register
;In: R0 = I2C Address (R/W bit=0)
;    R1 = register
;Return:
;    ACCU and R0 = content
;    changes: ACCU, R0, R1
i2c_rr:
          PHL
          PSH  R0
          PSH  R1
          JSR  rom_i2c_start_addr	; R0 = I2C Address
          POP  R1   	; pop register          
          JPF  _i2c_wr2	; if error (flag set at JSR, reuse routines in i2c_wr)

          JSR  rom_i2c_send ; send register
          POP  R0		; pop i2c address
          JPF  _i2c_wr3	; if error (flag set at JSR, reuse routines in i2c_wr)

          ; set R/W bit=1
          LDA  R0
          OR   #1
          STA  R0
          JSR  rom_i2c_start_addr	; R0 = I2C Address
          JPF  _i2c_wr3  ; if error (flag set at JSR, reuse routines in i2c_wr)
          LD   R1, #1
          JSR  rom_i2c_recv ; receive content in ACCU and R0

_i2c_rr1  JSR  rom_i2c_stop
          LDA  R0 ; ACCU changed in rom_i2c_stop
          RTS

; CH453 write register
;In: ACCU = content
;    R0 = CH453 reg address (R/W bit=0)
;    changes: ACCU, R0, R1
ch453_wr:
          PHL
          PSH  ACCU
          JSR  rom_i2c_start_addr	; R0 = CH453 reg address
          POP  R1					; pop content
          JPF  _i2c_wr3  			; error
          JSR  rom_i2c_send
          JMP  _i2c_wr3

;Read CH453 key register
;Return:
;    ACCU and R0 = content
;Changes: ACCU, R0, R1
read_ch453_key:
          PHL
          LD   R0, #A_CH453_RKEY
          JSR  rom_i2c_start_addr	; R0 = I2C Address
          JPF  _i2c_rr1  ; if error (flag set at JSR); re-use _i2c_rr1
          
          LD   R1, #1
          JSR  rom_i2c_recv ; receive content in ACCU and R0
          JMP  _i2c_rr1		; re-use _i2c_rr1
          

; Some LCD utils

lcdSel:	  ;select LCD. In: R0<-#LCDENAx. Changes ACCU, R0
          PHL
          PSH  R1
          LDA  LIB_CTRLOUT
          AND  #01110000B	; LCD select bits
          CMP  R0
          JPF  _lsel1		; if not changed, exit
          LDA  LIB_CTRLOUT
          AND  #10001111B        
          OR   R0			; new LIB_CTRLOUT in ACCU
          STA  LIB_CTRLOUT
          LD   R0, #A_LCD_CTRL
          LD   R1, #0x01
 		  JSR  i2c_wr
_lsel1    POP  R1
          RTS

lcdSendE:	; send falling edge on E1 or E2 without set I2C out data. for lcd_newline
          PHL
          PSH  R0
          JMP  _lcdsb1
lcdSendR1:
          LDA  R1
lcdSendByte:
          ; Send a data byte to the LCD in 8-bit mode
          ; Input: ACCU = data byte
          ; Changes: ACCU, R1
          
          PHL
          PSH  R0

          ; I2C Out data
          LD   R0, #A_LCD_DB
          LD   R1, #0x01
 		  JSR  i2c_wr          
 		  
 		  ; set RS
_lcdsb1   LDA  OUTP			; OUTP initial state is E=1, RS=1 (set in lcd_kybd_i2c_init)
          AND  LIB_LCDENAS  ; set RS
          OUT
          
          ;set E=0 (make a falling edge, ensure enable pulse width)
          AND  #LCDEN  ; set E
          OUT
          
          ;return to initial state          
          OR   #LCDDTDE		;set E=1, RS=1
          OUT
 		  
 		  POP R0
 		  RTS          



lcd_cursor_on:
          ; Switch cursor on
          ; Changes: ACCU, R0, R1
          LD   LIB_LCDCRSR,#1
          JMP  lcd_rst_crsr


lcd_cursor_off:
          ; Switch cursor off
          ; Changes: ACCU, R0, R1
          LD   LIB_LCDCRSR,#0

sendCrsrOffCmd:
          LDA  #0x0C

sendCmdToAllLCD:
          ; Send command in ACCU to all available LCD controller chips
          ; command in ACCU
          PHL
          PSH  ACCU
          PSH  ACCU
          
          LD   LIB_LCDENAS, #LCDDTMR
          
          LD   R0, #LCDENA2
          JSR  lcdSel
          POP  ACCU
          JSR  lcdSendByte

          LD   R0, #LCDENA1
          JSR  lcdSel
          POP  ACCU
          JSR  lcdSendByte
          RTS
          