;When in ROM, following codes are after uart_functions, before transfer_functions.
; (included in my4th-main.asm)

#ifdef WITH_I2C_LCD_KYBD ; if compiled in ROM

lcdWait2ms:
          LDA  #2
          JMP  delay_ms

#endif
;------------------------------------------------------------------------------
; PCA9557 and CH453 Init
;------------------------------------------------------------------------------

lcd_kybd_i2c_init:
          PHL
          ;CLC
          LD   LIB_BIGKEYB, #0
                    
          LD   LIB_CTRLOUT, #0
          LD   LIB_LCDENAS, #LCDDTMD	; RS=1
          
 		  LDA  OUTP			
          OR   #LCDDTDE		; set E=1, RS=1
          OUT
          STA  OUTP			; save initial state
          
          ; set PCA9557 polarity
		  LDA  #0
          LD   R0, #A_LCD_DB
		  LD   R1, #0x02
		  JSR  i2c_wr
          JPF  _lki_i2  ; error
          		  
		  LDA  #0
		  LD   R0, #A_LCD_CTRL
		  LD   R1, #0x02
  		  JSR  i2c_wr
          JPF  _lki_i2  ; error
          		  
		  ; set PCA9557 A_LCD_DB to out
		  LDA  #0
		  LD   R0, #A_LCD_DB
		  LD   R1, #0x03
		  JSR  i2c_wr
		  
		  ; set PCA9557 A_LCD_CTRL bit 6,5,4,3,2 to out, bit 7,1,0 to in
		  LDA  #10000011B
		  LD   R0, #A_LCD_CTRL
		  LD   R1, #0x03
		  JSR  i2c_wr
		  
		  ; setup CH453
          LD   LIB_KEYREPF,#0
          
          LDA  #00101011B
		  LD   R0, #A_CH453_SET
		  JSR  ch453_wr
          JPF  _lki_i2  ; error
          
          LD   LIB_BIGKEYB,#1
_lki_i2	  RTS	;if error, LIB_BIGKEYB=0


lcd_clear_t: ; if at terminal, do nothing; if at LCD, clear lcd
          TST  LIB_LCDOUT
          JPF  ret_opc
lcd_clear:
          ; Clear the LCD display.
          ; The cursor will be set to upper left edge.
          ; Changes: ACCU, R0, R1
          PHL
          ;send clear-display-command
          LDA  #0x01
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms
          ;reset cursor position
          LD   LIB_LCDPOSX,#0
          LD   LIB_LCDPOSY,#0
          JSR  lcd_rst_crsr
          LD   LIB_LCDENAS, #LCDDTMD        
_lc_rts   RTS


          