; When in ROM, codes in this file is at the end of SEG_PRGCODE
; (included in my4th-main.asm)

; if at terminal, print newline; if at LCD, pause every page and bypass when LIB_FIRSTLINE!=0; clear LIB_FIRSTLINE when called 
print_nl_w:
          PHL
          TST  LIB_LCDOUT
          JPF  _pnlw_01
          TST  LIB_FIRSTLINE
          JPF  _pnlw_02
          LD   LIB_FIRSTLINE, #0
          RTS
_pnlw_02  LDA  LIB_LCDPOSY
          CMP  #3
          JNF  _pnlw_01
          
          ;if at LCD screen end, press any key to continue...
          JSR  kb_waitkey
_pnlw_01  JSR  print_nl
          RTS

          
lcd_out_ch:
lcd_out_fch:
          ; Same like lcd_out_fast, but corrects special characters
          CMP  #'~'
          JNF  _lcdofc1
          LDA  #0
_lcdofc1  CMP  #'\\'
          JNF  lcd_out_fast
          LDA  #1

lcd_out_fast:
          ; Print a character on the LCD *fast*.
          ; This function does no safety checkings and
          ; does not support special control characters.
          ; It also does not write to the LCD backlog
          ; buffer, so scrolling the LCD up is not possible.
          ; In: ACCU = character
          ; Changes: ACCU
          PHL
          PSH  R1
          STA  R1
          INC  LIB_LCDPOSX
          JSR  lcdSendR1
          POP  R1
          RTS


