
;------------------------------------------------------------------------------
; Word List
;------------------------------------------------------------------------------

#ifndef WITH_I2C_LCD_KYBD
#define WORDS_LEN_3
#define WORDS_LEN_4
#define WORDS_LEN_6
#define WORDS_LEN_8
#define WORDS_LEN_9
#endif

#ifdef WITH_I2C_LCD_KYBD

rom_print_str SET print_str
rom_lcd_term SET unimpl
#endif


#ifndef WITH_I2C_LCD_KYBD          
push_flag:
            JNF  push_data_zero

push_data_ffff:
            LD   R4_L,#0xFF
            LD   R4_H,R4_L
            PHD  R4
            RET

push_data_zero:
            LD   R4_L,#0
_pushR4LR4L LD   R4_H,R4_L
            PHD  R4
            RET
#endif


#ifdef WORDS_LEN_3
#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_lcd
          DB   3,"lcd"
#endif
w_lcd:    ; LCD  ( -- )
          PHL
          TST  LIB_LCDOUT
          JNF  rts_opc
          JSR  lcd_kybd_i2c_init
          TST  LIB_BIGKEYB	; if no i2c lcd keyboard, LIB_BIGKEYB=0
          JPF  rts_opc
          JSR  lcd_init
          RTS
e_w_lcd  ;------------------------------------------------------------------
#endif ;WORDS_LEN_3

#ifdef WORDS_LEN_4

#ifndef WITH_I2C_LCD_KYBD	; if WITH_I2C_LCD_KYBD defined, use KEY? in forth_words_basis.asm
w_keyq:   ; KEY?  ( -- flag )  If a character is available, return true.  Otherwise, return false.
          TST  LIB_LCDOUT
          JPF  c_key
          PHL
          TST  NEXTINCHR
          JNF  ret_true
          JSR  keyb_readkey
          STA  NEXTINCHR
          TST
          JPF  ret_false
ret_true  LD   R4_L,#0xFF
          JMP  _rettf
ret_false LD   R4_L,#0
_rettf    LD   R4_H,R4_L
          JSR__push_data_R4
          RTS
e_w_keyq  ;------------------------------------------------------------------
#endif ;WITH_I2C_LCD_KYBD



#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_cr_w
          DB   4,"cr-w"
#endif
w_cr_w:   ; CR-W  ( -- ) 
          ; if at terminal, print newline; if at LCD, pause every page and bypass when LIB_FIRSTLINE!=0; clear LIB_FIRSTLINE when called 
          JMP  print_nl_w
e_w_cr_w  ;------------------------------------------------------------------

#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_cold
          DB   4,"cold"
#endif
w_cold:   ; COLD  ( -- ) 
          ; cold restart
          RST
e_w_cold  ;------------------------------------------------------------------


#endif ;WORDS_LEN_4


#ifdef WORDS_LEN_6
#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_i2c_wr
          DB   6,"i2c-wr"
#endif 
w_i2c_wr:		; I2C-WR  ( content regnum addr -- flag ) successful: flag=0
          PHL
          JSR__pop_data_R4	; get addr in R4_L
          LD   R0, R4_L
          JSR__pop_data_R4	; get regnum in R4_L
          LD   R1, R4_L
          JSR__pop_data_R4	; get content in R4_L
          LDA  R4_L
          JSR  i2c_wr
          JSR  push_flag
          RTS
e_w_i2c_wr ;------------------------------------------------------------------

#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_i2c_rr
          DB   6,"i2c-rr"
#endif           
w_i2c_rr:		; I2C-RR ( regnum addr -- val flag ) successful: flag=0
          PHL
          JSR__pop_data_R4	; get addr in R4_L
          LD   R0, R4_L
          JSR__pop_data_R4	; get regnum in R4_L
          LD   R1, R4_L
          JSR  i2c_rr
          LD   R4_H, #0
          STA  R4_L
          JSR__push_data_R4	; return val
          JSR  push_flag
          RTS
e_w_i2c_rr ;------------------------------------------------------------------
#endif ;WORDS_LEN_6


#ifdef WORDS_LEN_8
#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_ch453_wr
          DB   8,"ch453-wr"
#endif 
w_ch453_wr:		; CH453-WR ( content regaddr -- flag ) successful: flag=0        
          PHL
          JSR__pop_data_R4	; get regaddr in R4_L
          LD   R0, R4_L
          JSR__pop_data_R4	; get content in R4_L
          LDA  R4_L
          JSR  ch453_wr
          JSR  push_flag
          RTS
e_w_ch453_wr ;------------------------------------------------------------------

#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_ctrloutp
          DB   8,"ctrloutp"
#endif 
w_ctrloutp:		; CTRLOUTP ( -- addr_of_ctrloutp ) use with C!/C@        
          LD   R4_L, #LIB_CTRLOUT
          JMP  ret_regadr			; return addr of ctrloutp: $803D
e_w_ctrloutp  ;------------------------------------------------------------------         

#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_terminal
          DB   8,"terminal"
#endif            
w_terminal: ; TERMINAL ( -- )
          PHL
          TST  LIB_LCDOUT
          JPF  rts_opc
          JSR  lcd_clear
          LD   PTR_L,#<text_useterm
          LD   PTR_H,#>text_useterm
          JSR  rom_print_str
          JSR  keyboard_term
          JSR  lcd_cursor_off
#ifdef WITH_I2C_LCD_KYBD
          JSR  terminal_init
#else          
          JSR  rom_lcd_term  ;vector for "terminal_init"
#endif          
          LD   LIB_LCDOUT,#0
          RTS
e_w_terminal ;------------------------------------------------------------------          
#endif ;WORDS_LEN_8


#ifdef WORDS_LEN_9

#ifdef WITH_I2C_LCD_KYBD
          DW   e_w_firstline
          DB   9,"firstline"
#endif 
w_firstline:		; FIRSTLINE ( -- addr_of_firstline ) use with C!/C@        
          LD   R4_L, #LIB_FIRSTLINE
          JMP  ret_regadr
e_w_firstline  ;------------------------------------------------------------------         


#endif ;WORDS_LEN_9