;------------------------------------------------------------------------------
; LCD Functions
;------------------------------------------------------------------------------

_lcdinit2: ;initialize LCD (E1 and E2)
          PHL
          LDA  #00111000B		    ; instruction: 8-bit interface, 2-line, 5*8 dots
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms
          
          LDA  #00111000B		    ; instruction: 8-bit interface, 2-line, 5*8 dots
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms
          
          LDA  #00001100B		; instruction: entire display on, cursor off, cursor blink off
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms
          
          LDA  #0x01			; instruction: display clear
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms
          
          LDA  #00000110B	    	; instruction: entry mode increment, no shift
          JSR  sendCmdToAllLCD
          JSR  lcdWait2ms

          LD   R0,#0
          LD   R1,#2
          LD   PTR_L,#<tab_lcd_chr
          LD   PTR_H,#>tab_lcd_chr
          JSR  lcd_load_charset
          RTS


lcd_print:
          ; Print a character on the LCD
          ; In: ACCU = character
          ; Changes: ACCU
          STA  PAR2
          AND  #0xE0
          TST
          JPF  _lcdpr1  ; value is below < 0x20
_lcdpr0   LDA  LIB_LCDPOSX
          INC
          CMP  LIB_LCDMAXX
          JNF  _lcdpr7
          ;next printed character will result
          ;in moving the cursor outside the view area:
          ;the cursor must then be set to the next
          ;valid position
          PHL
          LDA  PAR2
          JSR  lcd_out_ch
          PSH  R0
          PSH  R1
          JSR  lcd_newline  
          POP  R1
          POP  R0
          RTS


_lcdpr7   ;continue with outputting the character
          LDA  PAR2
          JMP  lcd_out_ch


_lcdpr1   ;test for special characters
          LDA  PAR2
          CMP  #0x0D  ;CR '\r'
          JPF  _lcdpr2
          CMP  #0x0A  ;LF '\n'
          JPF  _lcdpr4
          CMP  #0x08  ;Backspace
          JNF  _lcdpr0
          ;Backspace
          PHL
          TST  LIB_LCDPOSX
          JPF  rts_opc
          PSH  R0
          PSH  R1
          DEC  LIB_LCDPOSX
          JSR  lcd_rst_crsr
          JMP  _lcdpr3
_lcdpr4   ;LF
          PHL
          PSH  R0
          PSH  R1
          JSR  lcd_newline
_lcdpr3   POP  R1
          POP  R0
          RTS
_lcdpr2   ;CR
          PHL
          PSH  R0
          PSH  R1
          JSR  lcd_return
          JMP  _lcdpr3

lcd_rst_crsr:
          ; Reset cursor position to position stored in LIB_LCDPOSX/Y
          LD   R0,LIB_LCDPOSX
          LD   R1,LIB_LCDPOSY
          JMP  lcd_gotoxy


lcd_return:
          ; Move cursor to beginning of current line.
          ; Changes: ACCU, R0, R1
          LD   R1,LIB_LCDPOSY
          LD   R0,#0
          JMP  lcd_gotoxy


lcd_newline:
          ; Move cursor to beginning of next line.
          ; Changes: ACCU, R0, R1
          PHL
          ; calculate next line
          LDA  LIB_LCDPOSY
          INC
          AND  #11B
          STA  LIB_LCDPOSY

          ;clear line
          STA  R1
          LD   R0,#0
          JSR  lcd_gotoxy
          
          LDA  #20h
          JSR  lcdSendByte
          LD   R0,LIB_LCDMAXX
          DEC  R0
_lcdnl1   JSR  lcdSendE
          JLP  _lcdnl1 

          LD   R0,#0
          LD   R1,LIB_LCDPOSY
          JSR  lcd_gotoxy          
          RTS
          
lcd_gotoxy:
          ; Set the cursor to the next position to print to.
          ; In: R0 = X-position, R1 = Y-position
          ; Changes: ACCU, R1
          PHL
          LD   LIB_LCDPOSX,R0
          LD   LIB_LCDPOSY,R1
          ;gotoxy on a big 4x40 LCD
          TST  LIB_LCDCRSR
          JPF  _lgt12
          JSR  sendCrsrOffCmd
          LD   R1,LIB_LCDPOSY
_lgt12    LD   R0, #LCDENA1
          JSR  lcdSel
          LDA  #0x80
          TST  R1
          JPF  _lgt11
          DEC  R1
          LDA  #0xC0
          TST  R1
          JPF  _lgt11
          DEC  R1
          LD   R0, #LCDENA2
          JSR  lcdSel
          LDA  #0x80
          TST  R1
          JPF  _lgt11
          LDA  #0xC0
_lgt11    AD   LIB_LCDPOSX
          STA  R1
          LD   LIB_LCDENAS, #LCDDTMR
          JSR  lcdSendR1
          TST  LIB_LCDCRSR
          JPF  _lgt13       
          LDA  #CRSR_ON_CMD          
          JSR  lcdSendByte
_lgt13    LD   LIB_LCDENAS, #LCDDTMD
          RTS


lcd_load_charset:
          ; Load a custom character set (up to 8 characters)
          ; into the LCD. Custom characters can be displayed
          ; with character codes 0-7.
          ; In: R0 = ID of first character to load (0-7),
          ;     R1 = count of characters to load (1-8),
          ;     PTR = pointer to bitmap data (8 byte per character),
          ;     note: set R0=0, R1=8 to load all 8 characters at once
          ; Changes: ACCU, R0, R1, PTR
          PHL
          PSH  R0
          PSH  R1
          PSH  PTR_L
          PSH  PTR_H
          PSH  R0
          LD   R0, #LCDENA1
          JSR  lcdSel
          POP  R0
          JSR  _lcdlcs3
          POP  PTR_H
          POP  PTR_L
          POP  R1
          LD   R0, #LCDENA2
          JSR  lcdSel
          POP  R0
          JSR  _lcdlcs3
          RTS
_lcdlcs3  PHL
          PSH  R1
          LDA  R0
          CLC
          ROL
          ROL
          ROL
          OR   #0x40
          STA  R1
          LD   LIB_LCDENAS, #LCDDTMR
          JSR  lcdSendR1
          LD   LIB_LCDENAS, #LCDDTMD
          POP  R0
_lcdlcs2  PSH  R0
          LD   R0,#8
_lcdlcs1  JSR__lap_inc_ptr
          JSR  lcdSendByte
          JLP  _lcdlcs1
          POP  R0
          JLP  _lcdlcs2
          JSR  lcd_rst_crsr
          RTS



;------------------------------------------------------------------------------
; Keyboard Functions
;------------------------------------------------------------------------------

keyboard_term:
          ;small or no keyboard installed
          LD   LIB_BIGKEYB,#0
          RET

keyb_readkey:
          ; Read the keyboard (if any is installed).
          ; Out: ACCU = key code or 0 if no button was pressed.
          ; Changes: ACCU, R0, PTR
          INC  RANDVAR

          ;read the big keyboard here
          PHL
          PSH  R4_L		; SHIFT STATUS. R4_L=0->SHIFT PRESSED
          PSH  R4_H		; CTRL STATUS.  R4_H=0->CTRL PRESSED
          PSH  R1
          
          TST  LIB_KEYREPF	; if LIB_KEYREPF=0 set flag
          JNF  _rdbk02		; LIB_KEYREPF=1: key in repeat mode

          ; if not in repeat mode, test if any key is pressed. Exit early if not.
          IN
          AND  #10000000B
          TST	; IF IN7=0 set flag
          JNF  _rdbk06	; if IN7=1 set ACCU=0 and return

          ;get ctrl and shift status
_rdbk02   LD   R0, #A_LCD_CTRL
          LD   R1, #0x00
          JSR i2c_rr
          AND  #01B
          STA  R4_L
          LDA  R0
          AND  #10B
          STA  R4_H
          
          ; get scan code, wait for:
          ; 1. key released, set LIB_KEYREPF=0
          ; 2. first pressed(LIB_KEYREPF=0) and timeout(loop limit #K_REPT_FIRST)
          ; 3. press continues(LIB_KEYREPF=1) and timeout(loop limit #K_REPT_CONT)
          
_rdbk01   LD   R0,#K_REPT_FIRST
          TST  LIB_KEYREPF	; if LIB_KEYREPF=0 set flag
          JPF  _rdbk08		; if first pressed, use loop limit #K_REPT_FIRST
          LD   R0,#K_REPT_CONT ; press continues, use loop limit #K_REPT_CONT
          LD   LIB_KEYREPF,#0 	; if not timeout (key released), clear pressed flag
          
_rdbk08   PSH  R0				; delay_ms uses R0, so push R0 first
          LDA  #10
          JSR  delay_ms			
          JSR  read_ch453_key	; value in ACCU and R0
          STA  R1				; save scan code in R1
          POP  R0
          AND  #01000000B
          TST	; if bit6=0 set flag
          JPF  _rdbk05 ; if bit6=0 (key released) break
          JLP  _rdbk08
          LD   LIB_KEYREPF,#1 ; timeout, set pressed flag

          ; convert scan code (in R1) to ASCII code
_rdbk05   LD   PTR_L,#<TAB_KEYSHIFT
          LD   PTR_H,#>TAB_KEYSHIFT
          TST  R4_L  ;if SHIFT pressed, set flag
          JPF  _rdbk04
          LD   PTR_L,#<TAB_KEYCTRL
          LD   PTR_H,#>TAB_KEYCTRL          
          TST  R4_H  ;if SHIFT not pressed, test CTRL; if CTRL pressed, set flag
          JPF  _rdbk04
          LD   PTR_L,#<TAB_KEYNORM
          LD   PTR_H,#>TAB_KEYNORM
          
_rdbk04   ;translate the code
          LDA  R1
          AND  #00111111B  ; bit 6 is pressed flag
          AD   PTR_L
          STA  PTR_L
          JNF  _rdbk11
          INC  PTR_H
_rdbk11   LAP			;key-code in ACCU

          CMP  #KCODE_C0		;if not Ctrl-0, return key-code
          JNF  _rdbk07          
          ;if Ctrl-0, toggle backlight and return 0
          LDA  LIB_CTRLOUT  
          XOR  #LCDBLIO		;toggle BL
          STA  LIB_CTRLOUT
          LD   R0, #A_LCD_CTRL
          LD   R1, #0x01
 		  JSR  i2c_wr
          
_rdbk06   LDA  #0
_rdbk07   POP  R1
          POP  R4_H
          POP  R4_L
          RTS


