#include <my4th/binmod.hsm>

lcd_out_fch SET rom_lcd_out_ch
lcd_load_charset SET rom_lcd_load_charset
lcd_clear SET rom_display_clear
lcd_gotoxy SET rom_display_gotoxy

#include "fast-ptr-instrs.hsm"
#include "lcd-kybd-defs.hsm"

;------------------------------------------------------------------------------
; Exported Words
;------------------------------------------------------------------------------

EXPORTS:  ;List of exported words.
          ;The list must be terminated with EEND.
          ;An empty list contains nothing but the end marker EEND.

          EXPORT  w_edit,     "edit"
          EXPORT  w_list,     "list"

          EEND


;------------------------------------------------------------------------------
; Imported Words
;------------------------------------------------------------------------------

IMPORTS:  ;List of imported words.
          ;Each line starts with a label that can be called from the
          ;assembly program. The list must be terminated with IEND.
          ;An empty list contains nothing but the end marker IEND.

c_list    IMPORT  "list"
c_edit    IMPORT  "edit"
c_key     IMPORT  "key"
c_dup     IMPORT  "dup"
c_block   IMPORT  "block"
c_update  IMPORT  "update"
c_savebuf IMPORT  "save-buffers"
c_emptybu IMPORT  "empty-buffers"
c_fill    IMPORT  "fill"
c_move    IMPORT  "move"
          IEND


;------------------------------------------------------------------------------
; Data Section
;------------------------------------------------------------------------------

; Important note:
; Everything in this section must be referenced with a pair of
; LD PTR_L,# / LD PTR_H,# instructions. Otherwise, the BLOAD word cannot
; translate the memory addresses correctly, which can lead to incorrect
; runtime behavior of this module.

#include "edit-data.asm"

;------------------------------------------------------------------------------
; Code Section. This section must be placed last, after all other sections.
;------------------------------------------------------------------------------

CODE:  ; marker for start of program code


init_module:
          ;This function is mandatory, it initializes this module.
          PHL

          ;You can add init-code here (or leave this function empty)

rts_opc   RTS


#include "lcd-kybd-edit-libs.asm"

#include "edit.asm"


;------------------------------------------------------------------------------
END_MODULE  ; This line terminates the code section of this binary module
