;------------------------------------------------------------------------------
; Misc Functions
;------------------------------------------------------------------------------


return_flag_0:
          ;@API Misc
          ; Pull return-address from stack and return to caller. Set FLAG to 0.
          ; Changes: LR
          CLC

return:   ;@API Misc
          ; Pull return-address from stack and return to caller
          ; Changes: LR

rts_opc:  ;@API Misc
          ; Return to caller (single RTS OP-Code)
          RTS

return_flag_1:
          ;@API Misc
          ; Pull return-address from stack and return to caller. Set FLAG to 1.
          ; Changes: LR
          SEC
          RTS

lap_inc_ptr:
          ;@API Registers
          ; Load ACCU and increment PTR afterwards
          ; In:  PTR = pointer to data
          ; Out: ACCU = value from memory where PTR has pointed to
          ;      PTR = old pointer incremented by one
          ; Changes ACCU, PTR
          LAP
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  ret_opc
          INC  PTR_H
#endif
ret_opc:  RET

sap_inc_ptr:
          ;@API Registers
          ; Store ACCU and increment PTR afterwards
          ; In:  PTR = pointer to memory cell where data shall be written to
          ;      ACCU = data byte
          ; Out: PTR = old pointer incremented by one
          ; Changes PTR
          SAP

inc_ptr:  ;@API Registers
          ; Increment PTR register by one
          ; In:  PTR
          ; Out: PTR = old pointer incremented by one
          ; Changes PTR
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  ret_opc
          INC  PTR_H
#endif
          RET

inc_ptr_lap:
          ;@API Registers
          ; Increment PTR first and then load ACCU
          ; In:  PTR = memory pointer
          ; Out: PTR = old pointer incremented by one
          ;      ACCU = data from memory cell where incremented PTR points to
          ; Changes PTR
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  _incptla
          INC  PTR_H
#endif
_incptla  LAP
          RET


dec_ptr:  ;@API Registers
          ; Decrement PTR register by one
          ; In:  PTR
          ; Out: PTR = old pointer decremented by one
          ; Changes PTR
          TST  PTR_L
          JNF  _decpt1
          DEC  PTR_H
_decpt1   DEC  PTR_L
          RET

inc_r4:   ;@API Registers
          ; Increment R4 register (16-bit) by one
          ; In:  R4
          ; Out: R4 = old R4 incremented by one
          ; Changes: R4
          INC  R4_L
          TST  R4_L
          JNF  ret_opc
          INC  R4_H
          RET

inc_r5:   ;@API Registers
          ; Increment R5 register (16-bit) by one
          ; In:  R5
          ; Out: R5 = old R5 incremented by one
          ; Changes: R5
          INC  R5_L
          TST  R5_L
          JNF  ret_opc
          INC  R5_H
          RET

inc_r6:   ;@API Registers
          ; Increment R6 register (16-bit) by one
          ; In:  R6
          ; Out: R6 = old R6 incremented by one
          ; Changes: R6
          INC  R6_L
          TST  R6_L
          JNF  ret_opc
          INC  R6_H
          RET

inc_r7:   ;@API Registers
          ; Increment R7 register (16-bit) by one
          ; In:  R7
          ; Out: R7 = old R7 incremented by one
          ; Changes: R7
          INC  R7_L
          TST  R7_L
          JNF  ret_opc
          INC  R7_H
          RET


ld_ptr_r4:
          ;@API Registers
          ; Load PTR with value in R4
          ; In:  R4
          ; Out: PTR = R4
          ; Changes: PTR
          LD   PTR_L,R4_L
          LD   PTR_H,R4_H
          RET


ld_ptr_r5:
          ;@API Registers
          ; Load PTR with value in R5
          ; In:  R5
          ; Out: PTR = R5
          ; Changes: PTR
          LD   PTR_L,R5_L
          LD   PTR_H,R5_H
          RET

ld_ptr_r6:
          ;@API Registers
          ; Load PTR with value in R6
          ; In:  R6
          ; Out: PTR = R6
          ; Changes: PTR
          LD   PTR_L,R6_L
          LD   PTR_H,R6_H
          RET

ld_ptr_r7:
          ;@API Registers
          ; Load PTR with value in R7
          ; In:  R7
          ; Out: PTR = R7
          ; Changes: PTR
          LD   PTR_L,R7_L
          LD   PTR_H,R7_H
          RET

psh_ptr:  ;@API Registers
          ; Push PTR on the stack
          ; In: PTR
          PSH  PTR_L
          PSH  PTR_H
          RET

psh_r4:   ;@API Registers
          ; Push R4 (16-bit) on the stack
          ; In: R4
          PSH  R4_L
          PSH  R4_H
          RET

psh_r5:   ;@API Registers
          ; Push R5 (16-bit) on the stack
          ; In: R5
          PSH  R5_L
          PSH  R5_H
          RET

psh_r6:   ;@API Registers
          ; Push R6 (16-bit) on the stack
          ; In: R6
          PSH  R6_L
          PSH  R6_H
          RET

psh_r7:   ;@API Registers
          ; Push R7 (16-bit) on the stack
          ; In: R7
          PSH  R7_L
          PSH  R7_H
          RET

pop_ptr:  ;@API Registers
          ; Poll PTR from the stack
          ; Out: PTR
          ; Changes: PTR
          POP  PTR_H
          POP  PTR_L
          RET

pop_r4:   ;@API Registers
          ; Poll R4 (16-bit) from the stack
          ; Out: R4
          ; Changes: R4
          POP  R4_H
          POP  R4_L
          RET

pop_r5:   ;@API Registers
          ; Poll R5 (16-bit) from the stack
          ; Out: R5
          ; Changes: R5
          POP  R5_H
          POP  R5_L
          RET

pop_r6:   ;@API Registers
          ; Poll R6 (16-bit) from the stack
          ; Out: R6
          ; Changes: R6
          POP  R6_H
          POP  R6_L
          RET

pop_r7:   ;@API Registers
          ; Poll R7 (16-bit) from the stack
          ; Out: R7
          ; Changes: R7
          POP  R7_H
          POP  R7_L
          RET


is_digit:
          ;@API Checkers
          ; Check if ACCU contains a valid digit ('0' - '9')
          ; In:  ACCU = ASCII character
          ; Out: Returns with cleared FLAG when ACCU contains a digit.
          PSH  ACCU
          SU   #'0'
          JNF  _isdig01
          SUB  #10
          POP  ACCU
          RET
_isdig01  SEC
          POP  ACCU
          RET
          

is_alpha:
          ;@API Checkers
          ; Check if ACCU contains a valid letter ('a' - 'z', 'A' - 'Z')
          ; In:  ACCU = ASCII character
          ; Out: Returns with cleared FLAG when ACCU contains a letter.
          PSH  ACCU
          SU   #'A'
          JNF  _isalp01
          SUB  #'Z'+1-'A'
          JNF  _isalp02
          SUB  #'a'-('Z'+1)
          JNF  _isalp01
          SUB  #'z'+1-'a'
_isalp02  POP  ACCU
          RET
_isalp01  SEC
          POP  ACCU
          RET

#ifndef ROM_16KB
is_hexchar:
          ;@API Checkers
          ; Check if ACCU contains a hex character ('0' - '9', 'A' - 'F')
          ; In:  ACCU = ASCII character
          ; Out: Returns with cleared FLAG when ACCU contains a hex character.
          ;      The ACCU contains the converted number (0x00 - 0x0F)
          ; Changes: ACCU
          SU   #'0'
          JNF  _ishex01
          LD   PAR2,ACCU
          SUB  #10
          JPF  _ishex02
          LD   ACCU,PAR2
          RET  ; FLAG = 0, ACCU = number 0-9
_ishex02  SUB  #7
          JNF  _ishex01
          SUB  #6
          JPF  _ishex03
_ishex04  ADD  #16
          CLC
          RET  ; FLAG = 0, ACCU = number 10-15
_ishex03  SUB  #0x1A
          JNF  _ishex01
          SUB  #6
          JNF  _ishex04
_ishex01  SEC
          RET

          
to_upper:
          ;@API Conversion
          ; Convert character in ACCU to upper case.
          ; In:  ACCU = any ASCII character
          ; Out: ACCU = upper case letter if ACCU contains a letter
          ; Changes: ACCU
          PHL
          JSR  is_alpha
          JPF  _toup1
          AND  #0xDF
_toup1    RTS


to_lower:
          ;@API Conversion
          ; Convert character in ACCU to lower case.
          ; In:  ACCU = any ASCII character
          ; Out: ACCU = lower case letter if ACCU contains a letter
          ; Changes: ACCU
          PHL
          JSR  is_alpha
          JPF  _tolo1
          OR   #0x20
_tolo1    RTS
#endif

skip_space:
          ;@API Strings
          ; Skip leading space characters in a text string.
          ; In:  PTR = pointer to string in memory
          ; Out: PTR = pointer to first non-space character in the string
          ; Changes: ACCU, PTR
          LAP
          CMP  #' '
          JNF  ret_opc
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  skip_space
          INC  PTR_H
#endif
          JMP  skip_space

#ifndef ROM_16KB
strcpy:
          ;@API Strings
          ; Copy a string (zero-terminated)
          ; In: R4 = source address, R5 = destination address
          ; Changes: ACCU, PTR, R4, R5
          PHL
_stcp01   JSR  ld_ptr_r4
          JSR  inc_r4
          LAP
          JSR  ld_ptr_r5
          JSR  inc_r5
          SAP
          TST
          JNF  _stcp01
          RTS
#endif

strlen:
          ;@API Strings
          ; Get the length of a string (zero-terminated)
          ; In : PTR = pointer to string
          ; Out: R0 = string length
          ; Changes: ACCU, R0, PTR
          PHL
          LD   R0,#0xFF
_stln01   INC  R0
          JSR__lap_inc_ptr
          TST
          JNF  _stln01
          RTS


memclr:   ; Clear a region of memory (write zeros)
          LDA  #0
memset:
          ;@API Strings
          ; Initialize memory with a constant value
          ; In : PTR = pointer to memory,
          ;      R0 = number of bytes to write,
          ;      ACCU = value to write
          ; Changes: ACCU, R0, PTR
          TST  R0
          DEC  R0
          JPF  ret_opc
          SAP
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  memset
          INC  PTR_H
#endif
          JMP  memset

