;------------------------------------------------------------------------------
; Special functions and defines for My4TH NFD
;------------------------------------------------------------------------------

#include "my4th-nfd-defs.hsm"
#include "ptr-ops.hsm"

;------------------------------------------------------------------------------
; Define special OP-codes that are only available in the My4TH NFD firmware

nfd_ucode Segment Code
ORG 0x7100


#define StkErrL   <Error_Stack
#define StkErrH   >Error_Stack

; OP-Code 0x71:
          ; does: IN / ROR / OUT LIB_I2C_C0D1 / STA FLAG / ROL R0
          DB 0x48,0x4E,0x3F,0x00,0x48,0x0C,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x0C
          DB 0x5D,0x00,0x49,0x00,0x4A,0x29,0x54,0x00,0x48,0xC6,0x7F,0x00,0x4A,0x80,0x48,0x0D
          DB 0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x0D,0x5D,0x00,0x48,0xC6,0x3F,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4A,0xC0,0x96,0x00,0x47,0x00,0x49,0x00,0x4A,0x2B,0x56,0x00,0x48,0x0F
          DB 0x4A,0x80,0x5D,0x00,0x48,LIB_I2C_C0D1,0x56,0x00,0x47,0x00,0x43,0x00,0x48,0x10,0x4A,0x80
          DB 0x58,0x00,0x4A,0x2A,0x44,0x01,0x56,0x00,0x48,0x0F,0x4A,0x80,0x54,0x00,0x47,0x00
          DB 0x07,0x00,0x48,0x10,0x5D,0x00,0x4A,0x80,0x48,0x08,0x58,0x00,0x4A,0x27,0x16,0x00
          DB 0x4A,0x80,0x48,0x08,0x5D,0x00,0x4A,0x29,0x49,0x00,0x54,0x00,0x48,0xF0,0x7F,0x00
          DB 0x4A,0x80,0x48,0x09,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x09,0x5D,0x00
          DB 0x4A,0x80,0x48,0x08,0x16,0x00,0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x50,0x00

; OP-Code 0x72:
          ; I2C-byte-transmitter
          DB 0x48,0x11,0x4A,0x80,0x58,0x00,0x4A,0x2A,0x16,0x00,0x47,0x00,0x48,0x11,0x4A,0x80
          DB 0x5D,0x00,0x45,0x00,0x48,0x84,0x7F,0x00,0x48,OUTP,0x16,0x00,0x47,0x00,0x43,0x00
          DB 0x48,LIB_I2C_C0D1,0x56,0x00,0x47,0x00,0x43,0x00,0x48,OUTP,0x4A,0x80,0x5D,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x48,LIB_I2C_C1D1,0x56,0x00,0x47,0x00,0x43,0x00
          DB 0x48,0xFE,0x3F,0x00,0x48,OUTP,0x16,0x00,0x47,0x00,0x43,0x00,0x48,LIB_I2C_C0D0,0x56,0x00
          DB 0x47,0x00,0x43,0x00,0x48,OUTP,0x4A,0x80,0x5D,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x48,LIB_I2C_C1D0,0x56,0x00,0x47,0x00,0x43,0x00,0x48,0xFE,0x3F,0x00
          DB 0x48,0x00,0x3F,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x40,OPCODE_I2T+1
          ; I2C-byte-transmitter, part 2
          DB 0x48,0x10,0x4A,0x80,0x58,0x00,0x4A,0x28,0x16,0x00,0x48,0x10,0x4A,0x80,0x5D,0x00
          DB 0x49,0x00,0x4A,0x29,0x54,0x00,0x48,0xE4,0x7F,0x00,0x4A,0x80,0x48,0x08,0x58,0x00
          DB 0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x08,0x5D,0x00,0x4A,0x29,0x49,0x00,0x54,0x00
          DB 0x48,0x44,0x7F,0x00,0x4A,0x80,0x48,0x09,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80
          DB 0x48,0x09,0x5D,0x00,0x48,0xF0,0x3F,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x40,OPCODE_I2T
          DB 0x4A,0x80,0x48,0x08,0x16,0x00,0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x50,0x00

; OP-Code 0x74:  Push a 16-bit register to the Forth data stack
          DB 0x4A,0x80,0x48,0x08,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x08,0x5D,0x00
          DB 0x4A,0x29,0x49,0x00,0x54,0x00,0x48,0x2A,0x7F,0x00,0x4A,0x80,0x48,0x09,0x58,0x00
          DB 0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x09,0x5D,0x00,0x4A,0x80,0x48,0x08,0x16,0x00
          DB 0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x56,0x00,0x47,0x00,0x4A,0x80,0x48,0x00
          DB 0x5D,0x00,0x49,0x00,0x56,0x00,0x47,0x00,0x48,fPSP,0x58,0x00,0x4A,0x81,0x5D,0x00
          DB 0x4A,0x80,0x48,fPSP,0x58,0x00,0x4A,0x27,0x56,0x00,0x4A,0x80,0x48,fPSP,0x5D,0x00
          DB 0x4A,0x80,0x48,0x00,0x58,0x00,0x4A,0x27,0x56,0x00,0x49,0x00,0x4A,0x80,0x56,0x00
          DB 0x47,0x00,0x48,fPSP,0x58,0x00,0x4A,0x81,0x5D,0x00,0x4A,0x80,0x48,fPSP,0x58,0x00
          DB 0x4A,0x27,0x56,0x00,0x4A,0x80,0x48,fPSP,0x5D,0x00,0x4A,0x80,0x48,0x08,0x58,0x00
          DB 0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x08,0x5D,0x00,0x4A,0x29,0x49,0x00,0x54,0x00
          DB 0x48,0xB4,0x7F,0x00,0x4A,0x80,0x48,0x09,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80
          DB 0x48,0x09,0x5D,0x00,0x48,0xF0,0x3F,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
          DB 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
          DB 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
          DB 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
          DB 0x4A,0x80,0x48,0x08,0x16,0x00,0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x50,0x00

; OP-Code 0x75:  Pop a 16-bit register from the Forth data stack
          DB 0x4A,0x80,0x48,0x08,0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x08,0x5D,0x00
          DB 0x4A,0x29,0x49,0x00,0x54,0x00,0x48,0x2A,0x7F,0x00,0x4A,0x80,0x48,0x09,0x58,0x00
          DB 0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x09,0x5D,0x00,0x4A,0x80,0x48,0x08,0x16,0x00
          DB 0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x56,0x00,0x47,0x00,0x4A,0x80,0x48,0x00
          DB 0x5D,0x00,0x48,fPSP,0x58,0x00,0x4A,0x29,0x54,0x00,0x48,0x64,0x7F,0x00,0x4A,0x80
          DB 0x48,0x08,0x06,StkErrL,0x47,0x00,0x5D,0x00,0x48,0x09,0x06,StkErrH,0x47,0x00,0x5D,0x00
          DB 0x48,0xF0,0x3F,0x00,0x4A,0x80,0x48,fPSP,0x58,0x00,0x4A,0x28,0x16,0x00,0x4A,0x80
          DB 0x48,fPSP,0x5D,0x00,0x49,0x00,0x4A,0x81,0x56,0x00,0x47,0x00,0x4A,0x80,0x48,0x00
          DB 0x58,0x00,0x5D,0x00,0x4A,0x28,0x56,0x00,0x48,0x00,0x4A,0x80,0x5D,0x00,0x48,fPSP
          DB 0x58,0x00,0x4A,0x28,0x56,0x00,0x4A,0x80,0x48,fPSP,0x5D,0x00,0x49,0x00,0x4A,0x81
          DB 0x56,0x00,0x47,0x00,0x4A,0x80,0x48,0x00,0x58,0x00,0x5D,0x00,0x4A,0x80,0x48,0x08
          DB 0x58,0x00,0x4A,0x27,0x16,0x00,0x4A,0x80,0x48,0x08,0x5D,0x00,0x4A,0x29,0x49,0x00
          DB 0x54,0x00,0x48,0xD6,0x7F,0x00,0x4A,0x80,0x48,0x09,0x58,0x00,0x4A,0x27,0x16,0x00
          DB 0x4A,0x80,0x48,0x09,0x5D,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00,0x4E,0x00
          DB 0x4A,0x80,0x48,0x08,0x16,0x00,0x47,0x00,0x48,0x09,0x5A,0x00,0x49,0x00,0x50,0x00

; OP-Code 0x76:  Increment 16-bit PTR (PTR_L and PTR_H), microcode continues in code of OPCODE_I2R
          DB 0x4A,0x80,0x40,OPCODE_I2R


SEG_PRGCODE



#ifndef WITH_I2C_LCD_KYBD
;------------------------------------------------------------------------------
; Define Jump-Vectors for connecting to an externel Forth Deck support driver

FDVECT_LCDINIT  SET 0x8440  ; initialize LCD
FDVECT_LCDCLR   SET 0x8443  ; clear LCD
FDVECT_LCDXY    SET 0x8446  ; set cursor
FDVECT_LCDCON   SET 0x8449  ; cursor on
FDVECT_LCDCOFF  SET 0x844C  ; cursor off
FDVECT_LCDPR    SET 0x844F  ; print a character
FDVECT_LCDOUT   SET 0x8452  ; output a character
FDVECT_LCDOUTF  SET 0x8455  ; output a character fast
FDVECT_LCDCSET  SET 0x8458  ; load charset
FDVECT_READKEY  SET 0x845B  ; read key
FDVECT_READSTR  SET 0x845E  ; read a string
#endif

#ifdef WITH_I2C_LCD_KYBD

#include "m4-i2c-lcd-kybd-fast/lcd-kybd-defs.hsm"
#include "m4-i2c-lcd-kybd-fast/lcd-kybd.asm"

detect_i2c_lcd_kybd:
          PHL
          JSR  lcd_kybd_i2c_init	;init PCA9557 and CH453
          TST  LIB_BIGKEYB	
          JPF  _dilk_01	;if i2c lcd kybd not found, return
          ;initialize the LCD
          JSR  lcd_init 
_dilk_01  RTS
          

#endif

#ifndef NO_DETECT_FORTHDECK
;------------------------------------------------------------------------------
; Detect the Forth Deck and print a message

LCDENA1   SET  0x12|UART_TXD_DEFAULT  ;bit0 = UART, bit1 (sda) = 1, bit2 (scl) = 0, bit3 (E) = 0, bit4/5 = lcd enable
LCDENA2   SET  0x22|UART_TXD_DEFAULT  ;bit0 = UART, bit1 (sda) = 1, bit2 (scl) = 0, bit3 (E) = 0, bit4/5 = lcd enable
LCDDTMD   SET  0x06|UART_TXD_DEFAULT  ;bit0 = UART, bit1 (sda) = 1, bit2 (scl) = 1, bit3 (E) = 0, bit4/5 = don't care
LCDDTMR   SET  0x02|UART_TXD_DEFAULT  ;bit0 = UART, bit1 (sda) = 1, bit2 (scl) = 0, bit3 (E) = 0, bit4/5 = don't care

CRSR_ON_CMD  SET 0x0F  ;0x0E = underline, 0x0F = blinking cursor


detect_fourthdeck:
          ; Detect the installed keyboard
          PHL
          LD   LIB_BIGKEYB,#0
          LD   R4_L,#0xF0
          LD   R4_H,#0x3F
          JSR  output_m
          IN
          ROL
          JPF  rts_opc
          LD   R4_H,#0xBF
          JSR  output_m
          IN
          ROL
          JNF  rts_opc

          ;Successfully detected the big keyboard with 4x40 LCD.
          ;This is a problem, because this firmware version has
          ;no support for the Forth Deck. Thus we must print a message.
          
          ;initialize the LCD
          JSR  lcd_init
          
          ;print a warning message
          LD   PTR_L,#<text_fdwarning
          LD   PTR_H,#>text_fdwarning
          LD   LIB_LCDENAS,#LCDENA1
_dfd01    JSR  lap_inc_ptr
          TST
          JPF  rts_opc
          JSR  lcd_out_fast
          JMP  _dfd01


print_boot_message:
          TST  LIB_LCDOUT
          JNF  terminal_init
          PHL
          JSR  lcd_init
          LD   PTR_L,#<text_fdbooting
          LD   PTR_H,#>text_fdbooting
          JMP  _dfd01


output_m:
          ; Output the eight M-bits on the additional 74HC574 on the keyboard
          ; and output OUT3-OUT7 on the output port.
          ; In: R4_L bits 3-7 = OUT3-OUT7, R4_H bits 0-7 = M-bits
          ; Changes: ACCU
          LDA  #0xF0
          AND  R4_H
          STA  PAR1
          LDA  #0x0B  ;SCL = low 
          AND  OUTP
          STA  OUTP
          OR   PAR1
          OUT
          OR   #0x04  ;SCL = high
          OUT
          LDA  R4_H
          CLC
          ROL
          CLC
          ROL
          CLC
          ROL
          CLC
          ROL
          OR   OUTP   ;SCL = low 
          OUT
          OR   #0x04  ;SCL = high
          OUT
          LDA  R4_L
          OR   OUTP   ;SCL = low 
          OUT
          STA  OUTP
          RET


lcd_init: ; Initialize LCD display.
          PHL
          JSR  _lcdinit1
          JSR  _lcdinit1  ; call init1 two times, sometimes it is needed
          RTS

_lcdinit1: ;initialize both chips of the LCD
          PHL
          LD   LIB_LCDENAS,#LCDENA1  ; start with first half of the LCD
          JSR  _lcdinit2
          LD   LIB_LCDENAS,#LCDENA2  ; then initialize the second half of the LCD
          JSR  _lcdinit2
          RTS

_lcdinit2: ;initialize the currently selected chip (E1/E2)
          PHL
          ;configure interface (set to 4-bit)
          JSR  lcdSetCmdReg
          OUT  OUTP
          LDA  #0
          JSR  lcdSendByte
          LDA  #3
          JSR  lcdSendByte
          JSR  lcdWait2ms
          LDA  #3
          JSR  lcdSendByte
          JSR  lcdWait2ms
          LDA  #3
          JSR  lcdSendByte
          JSR  lcdWait2ms
          LDA  #2
          JSR  lcdSendByte
          JSR  lcdWait2ms
          LDA  #0x28        ;4-bit mode
          JSR  lcdSendByte
          LDA  #0x0C        ;switch display on (and cursor off)
          JSR  lcdSendByte
          LDA  #0x01        ;clear the LCD
          JSR  lcdSendByte
          JSR  lcdWait2ms
          LDA  #0x06        ;entry mode: increment, no shift
          JSR  lcdSendByte
          JSR  lcdWait2ms
          RTS


lcdWait2ms:
          LDA  #2
          JMP  delay_ms


lcdSetDataReg:
          LDA  LIB_LCDENAS
          OUT
          OR   #0x04 ; SCL high, clock in the E-bits
          OUT
          LD   OUTP,#LCDDTMD
          RET


lcdSetCmdReg:
          LDA  LIB_LCDENAS
          OUT
          OR   #0x04 ; SCL high, clock in the E-bits
          OUT
          LD   OUTP,#LCDDTMR
          RET


lcdSendNibble:
          ; Send a data nibble to the LCD
          ; Input: ACCU = data nibble in bits 4-7
          OR   OUTP
          OUT  ACCU
          STA  PAR2
          LD   PAR1,#0x08
          OR   PAR1
          OUT  ACCU   ; E=1
          OUT  PAR2   ; E=0
          RET


lcdSendByte:
          ; Send a data byte to the LCD in 4-bit mode
          ; Input: ACCU = data byte
          ; Changes: ACCU, R1
          STA  R1
lcdSendR1:
          LDA  #0xF0
          AND  R1
          OR   OUTP
          OUT  ACCU
          STA  PAR2
          LD   PAR1,#0x08
          OR   PAR1
          OUT  ACCU   ; E=1
          OUT  PAR2   ; E=0
          LDA  R1
          CLC
          ROL
          CLC
          ROL
          CLC
          ROL
          CLC
          ROL
          OR   OUTP
          OUT  ACCU
          STA  PAR2
          OR   PAR1
          OUT  ACCU   ; E=1
          OUT  PAR2   ; E=0
          RET


sendCmdToAllLCD:
          ; Send command in ACCU to all available LCD controller chips
          PHL
          PSH
          LD   LIB_LCDENAS,#LCDENA1
          JSR  lcdSetCmdReg
          POP
          PSH
          JSR  lcdSendByte
_sctal1   LD   LIB_LCDENAS,#LCDENA2
          JSR  lcdSetCmdReg
          POP
          JSR  lcdSendByte
          RTS


lcd_out_fast:
          ; Print a character on the LCD *fast*.
          ; This function does no safety checkings and
          ; does not support special control characters.
          ; It also does not write to the LCD backlog
          ; buffer, so scrolling the LCD up is not possible.
          ; In: ACCU = character
          ; Changes: ACCU, R1
          STA  R1
          LDA  LIB_LCDENAS
          OUT
          OR   #0x04 ; SCL high, clock in the E-bits
          OUT
          LD   OUTP,#LCDDTMD
          JMP  lcdSendR1

#endif		;NO_DETECT_FORTHDECK
