#ifndef _CPU_H
#define _CPU_H

#include <stdint.h>

#define CPU_MIN_MEMORY_ADDR   0x0000
#define CPU_MAX_MEMORY_ADDR   0xFFFF

#define UC_MY4TH     0
#define UC_MY4TH_XS  1
#define UC_MYNOR     2


extern uint64_t exectime_g;  // execution time in [ns]


/** Write data into the CPU memory space.
 *  @param addr  memory address: 0x0000-0x7FFF = EPROM, 0x8000-0xFFFF = RAM
 *  @param data  data byte to write
 */
void cpu_memory_write(uint16_t addr, uint8_t data);


/** Read data out of the CPU space.
 *  @param addr  memory address: 0x0000-0x7FFF = EPROM, 0x8000-0xFFFF = RAM
 *  @return  data byte
 */
uint8_t cpu_memory_read(uint16_t addr);


/** Clock the CPU. Each call to this function simulates one clock cycle.
 */
void cpu_clock(void);


/** Enable the generation of a VCD file.
 *  @param vcdfile  name of the vcd file to generate or NULL
 */
void cpu_enable_vcd(char *vcdfile);


/** Enable or disable real timing simulation.
 *  @param enable  flag: if nonzero, real timing simulation is enabled (but it is slow).
 */
void cpu_set_real_timing(int enable);

  
/** Initialize the CPU simulation.
 *  @param  ucode  can be UC_MY4TH or UC_MY4TH
 *                 Simulation of ARCH_MYNOR is not yet supported.
 */
void cpu_init(int ucode);


/** Terminate the CPU simulation
 */
void cpu_term(void);


#endif /* _CPU_H */
