#ifndef _EEPROM_H
#define _EEPROM_H

#include <stdint.h>


/** Simulate EEPROMs
 *  @param scl  ptr to SCL wire variable
 *  @param sda  ptr to SDA wire variable
 *  @note This function must be called when ever
 *        the SCL or the SDA wire changes its state.
 */
void i2c_eeprom(int *scl, int *sda);


/** Configure the two EEPROMs on the Board.
 *  @param socket1 :  String "24LC512" / "24LC1025" / "24LC1026"
 *  @param socket2 :  String "24LC512" / "24LC1025" / "24LC1026"
 *  @return zero on success
 */
int i2c_eeprom_setup(char *socket1, char *socket2);


#endif /* _EEPROM_H */
