#ifdef _LINUX
/*------------- LINUX --------------*/

#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include "input.h"


int keyboard_getch(void)
{
  unsigned char c;
  return (read(STDIN_FILENO, &c, 1) == 1) ? ((int)c)&0xFF : 0;
}


static void changemode(int dir)
{
  static struct termios oldt, newt;

  if ( dir == 1 )
  {
    tcgetattr( STDIN_FILENO, &oldt);
    newt = oldt;
    newt.c_lflag &= ~( ICANON | ECHO );
    tcsetattr(STDIN_FILENO, TCSANOW, &newt);
  }
  else
    tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
}


static void kbhit_atexit(void)
{
  changemode(0);
}


int keyboard_hit(void)
{
  static int kbhit_inited = 0;
  struct timeval tv;
  fd_set rdfs;

  if (!kbhit_inited)
  {
    changemode(1);
    atexit(kbhit_atexit);
    kbhit_inited = 1;
  }
  
  tv.tv_sec = 0;
  tv.tv_usec = 0;

  FD_ZERO(&rdfs);
  FD_SET (STDIN_FILENO, &rdfs);

  select(STDIN_FILENO+1, &rdfs, NULL, NULL, &tv);
  return FD_ISSET(STDIN_FILENO, &rdfs);
}


#else
/*------------- WINDOWS ------------*/

#include <conio.h>

int keyboard_getch(void)
{
  return getch();
}

int keyboard_hit(void)
{
  return kbhit();
}

#endif
