#ifndef _IOPORTS_H
#define _IOPORTS_H

#include <stdint.h>


typedef enum iodisplay {
  iodisp_simple = 0,  // display each change in a separate line
  iodisp_inline,      // display all I/Os in a single line
  iodisp_uarttiming,  // show debug information for uart timing adjustment
  iodisp_none,        // do not display writes to I/O-Ports
} iodisplay_t;

extern iodisplay_t iodisplay_g;


/** Set new value for output port 3
 *  @param value  new port data value
 */
void set_outport(uint8_t value);


/** Get value from input port 1
 */
uint8_t get_inport(void);


/** Get the level of the TxD signal at Output Port 1
 *  @return TxD signal level in bit0
 */
uint8_t get_txd(void);


/** Set the level of the RxD signal at Input Port 1
 *  @param level  new RxD input level at bit0
 */
void set_rxd(uint8_t level);


/** This function must be called periodically.
 *  @param readkeyboard   set to true to read keyboard as input for Input Port 1
 */
void ioports_poll(uint8_t readkeyboard);


/** Initialize IO-Ports
 *  @param display    type of display
 */
void ioports_init(iodisplay_t display);


/** Terminate IO-Ports
 */
void ioports_term(void);


#endif /* _IOPORTS_H */
