
#ifndef OPSYSTEM_H
#define OPSYSTEM_H

#if !defined(_WIN32) && !defined(_LINUX)
#define _LINUX
#endif

#include <stdint.h>


/****************************************************************************
 *  DATA TYPES                                                              *
 ****************************************************************************/

typedef int (*OSTASKFUNC_t)(void *pArgs);

struct _sOSSEMAHANDLE;
struct _sOSTASKHANDLE;
typedef struct _sOSSEMAHANDLE *OSSEM_t;
typedef struct _sOSTASKHANDLE *OSTASK_t;


/****************************************************************************
 *  FUNCTION PROTOTYPES                                                     *
 ****************************************************************************/

OSSEM_t  OsSemaCreate(int count);
int      OsSemaDelete(OSSEM_t hsem);
int      OsSemaSignal(OSSEM_t hsem);
int      OsSemaWait(OSSEM_t hsem);
int      OsSemaWaitTimeout(OSSEM_t hsem, int milliseconds);
OSTASK_t OsTaskCreate(OSTASKFUNC_t pFunc, void* pArgs);
void     OsTaskExit(int exitcode);


#endif /* OPSYSTEM_H */
