/*
 *  Generate a VCD wave output file
 */

#ifndef _VCD_H
#define _VCD_H

#include <stdint.h>
#include "simulation.h"


/** Add a wire to the VCD view
 *  @param name   display name of the wire
 *  @param sig    ptr to the signal wire
 */
void vcd_add_wire(const char *name, signal_t *sig);


/** Add a 8-bit data bus to the VCD view
 *  @param name   display name of the bus
 *  @param bus    ptr to the data bus
 */
void vcd_add_dbus(const char *name, dbus_t *bus);


/** Add a 16-bit address bus to the VCD view
 *  @param name   display name of the bus
 *  @param bus    ptr to the address bus
 */
void vcd_add_abus(const char *name, abus_t *bus);


/** Open a new VCD file for wave output
 *  @param filename   name of the new file
 *  @param comment    comment for the header
 *  @param timescale  timescale (in nanoseconds)
 *  @note Call vcd_add_wire / vcd_add_dbus / vcd_add_abus functions
 *        to register all signals that shall be recorded
 *        _before_ you call this function to create a new vcd file!
 */
int vcd_newfile(char *filename, char *comment, unsigned timescale);


/** Close / finish a VCD file
 */
void vcd_closefile(void);


/** Execute a new timestep with timescale resolution
 *  given in call to vcd_newfile.
 */
void vcd_timestep(void);


#endif /* _VCD_H */
