;------------------------------------------------------------------------------
; Printing
;------------------------------------------------------------------------------

SEG_LOWCODE

display_clear:
          ;@API Printing
          ; Clears the screen (LCD or terminal window)
          ; Changes: ACCU, R0, R1, PTR
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  lcd_clear
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  FDVECT_LCDCLR
#endif
#endif
          LD   PTR_L,#<text_clear
          LD   PTR_H,#>text_clear
          JMP  print_str


display_cursor_on:
          ;@API Printing
          ; Switch cursor on (only applicable with LCD)
          ; Changes: ACCU
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  lcd_cursor_on
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  FDVECT_LCDCON
#endif
#endif
          RET


display_cursor_off:
          ;@API LCD
          ; Switch cursor off (only applicable with LCD)
          ; Changes: ACCU
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  lcd_cursor_off
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  FDVECT_LCDCOFF
#endif
#endif
          RET


display_gotoxy:
          ;@API Printing
          ; Set the cursor to the next position to print to.
          ; In: R0 = X-position, R1 = Y-position
          ; Changes: ACCU, R0, R1, R4, R5
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  lcd_gotoxy
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  FDVECT_LCDXY
#endif
#endif
          PHL
          PSH  R1
          PSH  R0
          LD   PTR_L,#<text_home
          LD   PTR_H,#>text_home
          JSR  print_str
          POP
          TST
          JPF  _digxy1
          JSR  _digxy2
          LDA  #'C'
          JSR  print_char
_digxy1   POP
          TST
          JPF  return
          JSR  _digxy2
          LDA  #'B'
          JSR  print_char
          RTS
_digxy2   PHL
          STA  R4_L
          LDA  #27
          JSR  print_char
          LDA  #'['
          JSR  print_char
          LD   R4_H,#0
          LD   R5_L,#10
          LD   R5_H,#0
          JSR  divide_u
          TST  R4_L
          JPF  _digxy3
          LDA  #0x30
          OR   R4_L
          JSR  print_char
_digxy3   LDA  #0x30
          OR   R5_L
          JSR  print_char
          RTS


print_space:
          ;@API Printing
          ; Print only a space character.
          ; Changes: ACCU
          LDA  #32
          JMP  print_char

print_cr:
          ;@API Printing
          ; Print only a CR character.
          ; Changes: ACCU
          LDA  #13
          JMP  print_char

print_nl:
          ;@API Printing
          ; Print New-Line characters CR/NL.
          ; Changes: ACCU
          LDA  #10

print_char:
          ;@API Printing
          ; Print a character.
          ; In: ACCU = character to print
          ; Changes: ACCU
          TST  VECT_OUTPUT+2
          JNF  OUTPUT_VECTOR
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  lcd_print
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  FDVECT_LCDPR
#endif
#endif
          CMP  #10
          JNF  uart_xmit
_prCrLf   PHL
          LDA  #13
          JSR  uart_xmit
          POP  LR_H
          POP  LR_L
_prLf     XOR  ACCU  ;insert "waitstates", this will insert a 2nd stop-bit so a serial connection with 8n2 will be possible
          XOR  ACCU
          LDA  #10
          JMP  uart_xmit


print_str:
          ;@API Printing
          ; Print a string.
          ; In: PTR = pointer to zero-terminated string.
          ; Changes: ACCU, PTR
          PHL
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
          TST  LIB_LCDOUT
          JNF  _prstlp1
#else
#ifdef MY4TH_NFD
          TST  LIB_LCDOUT
          JNF  _prstlp1
#endif
#endif
          TST  VECT_OUTPUT+2
          JNF  _prstlp1
_prstlp2  ;UART
          LAP
          TST
          JPF  return
          CMP  #10
          JNF  _prstlp3
          JSR  _prCrLf
          JMP  _prstlp4
_prstlp3  JSR  uart_xmit
_prstlp4
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  _prstlp2
          INC  PTR_H
#endif
          JMP  _prstlp2

_prstlp1  ;print on LCD or other device
          LAP
          TST
          JPF  return
          JSR  print_char
#ifdef FAST_PTR
          IPT
#else
          INC  PTR_L
          TST  PTR_L
          JNF  _prstlp1
          INC  PTR_H
#endif
          JMP  _prstlp1


printstrm:
          ;Print a string, the pointer to the string
          ;follows the JSR instruction to this routine.
          ;Only use together with the PRINT macro.
          PHL
          JSR  pop_ptr
          JSR  lap_inc_ptr
          STA  PAR2
          JSR  lap_inc_ptr
          JSR  psh_ptr
          LD   PTR_L,PAR2
          STA  PTR_H
          JSR  print_str
          RTS

#ifndef ROM_16KB
print_nibble:
          ; Print a single hex-nibble
          ; In: nibble in ACCU
          SU   #10
          JPF  _prnib1
          ADD  #3Ah
          JMP  print_char
_prnib1   ADD  #40h
          JMP  print_char


print_hexbyte:
          ;@API Printing
          ; Print a byte in hexadecimal
          ; In: byte in ACCU
          ; Changes: ACCU
          PHL
          PSH  ACCU
          CLC
          ROR
          CLC
          ROR
          CLC
          ROR
          CLC
          ROR
          JSR  print_nibble
          POP  ACCU
          AND  #0Fh
          JSR  print_nibble
          RTS


print_hexword:
          ;@API Printing
          ; Print a word (16-bit) in hexadecimal
          ; In: word in R4
          ; Changes: ACCU
          PHL
          LDA  R4_H
          JSR  print_hexbyte
          LDA  R4_L
          JSR  print_hexbyte
          RTS


;-------------------------------------------------


print_decword:
          ;@API Printing
          ; Print a word (16-bit unsigned) in decimal notation
          ; In: word in R4
          ; Changes: ACCU
          PHL
print_decword_rts:
          PSH  R0
          PSH  R1
          PSH  R2
          JSR  psh_r4
          JSR  psh_r5
          JSR  psh_ptr
          JSR  convert_16bit_to_decimal
          LD   R0,#4
_prdw01   LAP
          INC  PTR_L
          CMP  #0x30
          JNF  _prdw02
          JLP  _prdw01
_prdw06   LAP
          INC  PTR_L
_prdw02   JSR  print_char
          TST  R0
          DEC  R0
          JNF  _prdw06
          JSR  pop_ptr
          JSR  pop_r5
          JSR  pop_r4
          POP  R2
          POP  R1
          POP  R0
          RTS


convert_16bit_to_decimal:
          ;@API Printing
          ; Convert a 16-bit binary number into a 5 digits decimal number.
          ; In : 16-bit number in R4
          ; Out: 5 digits decimal number in LIB_BUF. PTR points to LIB_BUF.
          ; Changes: R0, R1, R2, R4, R5, PTR
          PHL
          LD   LIB_BUF+5,#0
          LD   PTR_H,#>ZEROPAGE
          LD   PTR_L,#LIB_BUF+5
          LD   R0,#5
_cnvd01   LD   R5_L,#10
          LD   R5_H,#0
          PSH  LIB_BUF+0
          PSH  LIB_BUF+1
          PSH  LIB_BUF+2
          PSH  LIB_BUF+3
          JSR  divide_u
          POP  LIB_BUF+3
          POP  LIB_BUF+2
          POP  LIB_BUF+1
          POP  LIB_BUF+0
          LDA  #0x30
          OR   R5_L
          JSR  dec_ptr
          SAP
          JLP  _cnvd01
          LD   PTR_H,#>ZEROPAGE
          LD   PTR_L,#LIB_BUF
          RTS

#endif

SEG_PRGCODE
