;------------------------------------------------------------------------------
; Define Text Strings
;------------------------------------------------------------------------------

_strings Segment Code

ORG ROM_STRINGS

;the following strings must all fit into one 256-byte-page
forth_strings_start:
text_errQuote   DB " ? missing ",0x22,0
text_errSyntax  DB " ? syntax",0
text_errValue   DB " ? value",0
text_errStack   DB " ? stack",0
text_errTooLong DB " ? too long",0
#ifndef NO_BLOCK_WORDS
text_errInOut   DB " ? I/O error",0
#endif
text_errMem     DB " ? out of memory",0
text_errWord    DB " ? unknown word ",0
text_errNumber  DB " ? number too large",0
#ifdef WITH_I2C_LCD_KYBD
text_errUnavailforLcd DB " ? unavailable for lcd", 0
#endif

;these strings can wrap over a 256-byte-boundary:
#ifndef NO_BLOCK_WORDS
text_errCmd     DB " ? unknown command",0
text_runerr     DB " ? RUN word not found\n",0
text_errImport  DB " ? unknown import word ",0
#endif
text_abort      DB "\naborted\n",0
text_compiled   DB " compiled\n",0
#ifndef NO_BLOCK_WORDS
text_run        DB "run",0
text_wrongver   DB " ? wrong My4TH version\n",0
#endif
text_forth_ok   DB " ok\n",0
#ifndef NO_BLOCK_WORDS
text_saving1    DB "  "
text_saving2    DB "saving...",0
text_loading    DB "\nloading screen...",0
#ifndef NO_LCD
text_ed_headln  DB "[save] [save+quit] [quit] [clear]",0
#endif
text_savedto    DB " saved to blocks ",0
text_to         DB " to ",0
text_error      DB " ERROR\n",0
text_autostart1 DB "Press any key to stop autostart\n",0
text_autostart2 DB "Executing screen ",0
#endif
#if !defined(NO_LCD) || defined(WITH_I2C_LCD_KYBD)
text_useterm    DB "Please use the serial terminal",0
#endif

text_heading1   DB "My4TH"

#ifdef WITH_I2C_LCD_KYBD
                DB " ilk"
#else

#ifdef MY4TH_NFD
                DB " nfd"
#endif

#endif

#ifdef ALTERNATIVE_EEPROM_SEARCH
                DB " altes"
#endif

#if defined(BAUD14400)
                DB " b144"
#elif defined(BAUD19200)
                DB " b192"                
#endif
                
#ifdef PLATFORM_MYNOR
                DB " for MyNOR"
#endif
#ifdef PLATFORM_XS
#ifdef ROM_16KB
                DB " XS v"
#else
                DB " light v"
#endif
                DB ROMVERSION_STRING
                DB "\n",0
#else
                DB " v"
                DB ROMVERSION_STRING
                DB " / ",0
text_heading2   DB " MHz\n",0
#endif

text_backsp     DB 27,"[D ",
text_left       DB 27,"[D",0
text_right      DB 27,"[C",0
text_home       DB 27,"[1;1H",0
text_clear      DB 27,"[1;1H",27,"[J",0

#ifndef NO_BLOCK_WORDS
text_eeproms1   DB "EEPROMs: ",0
#if !defined(PLATFORM_XS) && !defined(ALTERNATIVE_EEPROM_SEARCH)
text_eeproms2   DB " blocks)\n",0
#endif
text_eeproms3   DB " KB ",0
#if !defined(PLATFORM_XS) && !defined(ALTERNATIVE_EEPROM_SEARCH)
text_eeplist    DB "none",0,"24LC512",0,"24LC1025",0,"24LC1026",0
#endif
#endif

#if defined(MY4TH_NFD) && !defined(WITH_I2C_LCD_KYBD)
text_fdwarning  DB "This ROM does not support the Forth Deck",0
text_fdbooting  DB "Booting ...",0
#endif

