;------------------------------------------------------------------------------
; Lots of tables
;------------------------------------------------------------------------------

#ifdef WITH_I2C_LCD_KYBD
#include "m4-i2c-lcd-kybd-fast/lcd-kybd-defs.hsm"
#else
#include "keydefs.hsm"
#endif

aligned_tables Segment Code


ORG ROM_TABLES1+00E0h  ;(7AE0h) Lower 5 bits must be zero
tab_vt100keys:
    DB  0,KCODE_UP,KCODE_DOWN,KCODE_RIGHT,KCODE_LEFT,0x82,KCODE_END,0
    DB  KCODE_HOME,0,0,0,0,0,0,0
    DB  KCODE_F4,KCODE_F1,KCODE_F2,KCODE_F3,KCODE_F4,KCODE_F5,KCODE_F5,KCODE_F6,KCODE_F7  ; geht mit putty
    DB  KCODE_F8,KCODE_INSERT,KCODE_DEL,KCODE_END,KCODE_PGUP,KCODE_PGDOWN,0


#ifndef ROM_16KB
ORG 7B00h

;Table for machine-code relocation (it decodes the length of OP-codes)
;MSB is 1: opcode followed by an address, or LD# (for LD PTR_L,# and LD PTR_H,#)
tab_opcode:
    DB  0x01,0x83,0x03,0x02,0x02,0x01,0x02,0x01  ; RST / LD# / LD  / LDA#/ LDA / LAP / STA / SAP
    DB  0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02  ; rsv / INC / DEC / ROL / ROR / AND / OR  / XOR
    DB  0x02,0x02,0x01,0x02,0x02,0x02,0x83,0x83  ; ADD / SUB / ICO / CMP#/ CMP / TST / JPF / JNF
    DB  0x83,0x83,0x01,0x02,0x02,0x01,0x01,0x01  ; JMP / JSR / RET / PSH / POP / IN  / PHL / RTS
    DB  0x83,0x02,0x01,0x01,0x02,0x02,0x02,0x01  ; JPL / RWL / SEC / CLC / AD  / SU  / OUT / ICL
    DB  0x01,0x01,0x03,0x01,0x01,0x01,0x01,0x01  ; ICL / ICH / SSV / SRT / TJZ / rsv / rsv / rsv

#include "m4-i2c-lcd-kybd-fast/lcd-kybd-table-keynorm.asm"

#ifdef MY4TH_NFD
ORG 7B71h
	; for BLOAD, tab_opcode(nfd), opcode 71h~76h
    DB 1,1,0,2,2,1	; I2R / I2T / rsv / PHD / PLD / IPT 
#endif

#include "m4-i2c-lcd-kybd-fast/lcd-kybd-table-keyshift.asm"

#include "text_gitcommit.asm"

ORG 7BE0h  ;Lower 5 bits must be zero (table for S\" word (formatted string))
tab_formatstr
    DB 0,7,8,'c','d',27,12,'g','h','i','j','k',10,'n','n','o','p',
    DB 34,13,'s',9,'u',11,'w','x','y',0,0,0,0,0,0

#endif

ORG ROM_TABLES2

;Table for converting characters to lower case (aligned to address 7C00h, the lower 8 bits are zero):
tab_lowerCase:
tab_dict: ;this table sits inside the "lower case" table and is used to find the correct dictionary pointer
    DB  DICTA+0,DICTA+2,DICTA+4,DICTA+6,DICTA+8,DICTA+10,DICTA+12,DICTA+14
    DB  0,0,0,0,0,0,0,0
    DB  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    DB  0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F
    DB  0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F
    DB  0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F
    DB  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F
    DB  0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F
    DB  0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F


tab_fthVarInit:
    DW  HEAP_START   ; CP
    DW  dictionary_8, dictionary_1, dictionary_2, dictionary_3  ; DICTA+0 - DICTA+7
    DW  dictionary_4, dictionary_5, dictionary_6, dictionary_7  ; DICTA+8 - DICTA+15
    DW  USER_MEMORY  ; UP
    DB  0,0,0xFF,0xFF,0  ; BLKSTRUCT
    DB  OPCODE_JSR, 0, 0, OPCODE_JMP, <return, >return      ; JSRSPACE
    DB  OPCODE_JSR, 0, 0, OPCODE_JMP, <itp_loop, >itp_loop  ; IPRSPACE
    DW  10  ; BASE
    DB  0   ; EEP_STATE
    DB  0   ; NEXTINCHR
    DW  0   ; BLK
    DW  0   ; SCR
    DB  INDEV_LOCAL  ; INPUTDEV
    DB  0   ; REFILL

ORG ROM_TABLES2+00C0h

;Table for conversion from binary to hex or any other base. Lower 6 bits must be zero.
tab_num2asc:
    DB  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"

#ifdef ROM_16KB
;ROM version for My4TH XS
ORG ROM_TABLES2+00FFh
    DB  <(ROMVERSION_BINARY - 0x11)
#endif

#ifndef ROM_16KB
#ifndef NO_DETECT_FORTHDECK		; free 7D00~7DFD for use
ORG 7D00h  ;low-byte must have bits 0-6 = zero
TAB_KEYNORM  ; for big keyboard with 54 keys, not shifted, the table has a size of 72 bytes
    DB  KCODE_DOWN,KCODE_UP,KCODE_RIGHT,0x0D,0x5C,KCODE_BS, 0,0  ; M4
    DB  0x5D,0x3D,KCODE_LEFT,0x27,0x5B,0x2D, 0,0  ; M3
    DB  0x2E,0x6C,0x2F,0x3B,0x70,0x30, 0,0  ; M2
    DB  0x6F,0x39,0x2C,0x6B,0x69,0x38, 0,0  ; M1
    DB  0x6E,0x68,0x6D,0x6A,0x75,0x37, 0,0  ; M0
    DB  0x79,0x36,0x62,0x67,0x74,0x35, 0,0  ; OUT7
    DB  0x63,0x64,0x76,0x66,0x72,0x34, 0,0  ; OUT6
    DB  0x65,0x33,0x78,0x73,0x77,0x32, 0,0  ; OUT5
    DB  0x20,0x1B,0x7A,0x61,0x71,0x31, 0,0  ; OUT4

;[0]    ;[1]
;.....  ;.....
;.....  ;#....
;.#..#  ;.#...
;#.##.  ;..#..
;.....  ;...#.
;.....  ;....#
;.....  ;.....
;.....  ;.....

tab_lcd_chr DB  0x00,0x00,0x09,0x16,0x00,0x00,0x00,0x00  ;[0]:~
            DB  0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00  ;[1]:\


ORG 7D80h  ;low-byte must have bits 0-6 = zero
TAB_KEYSHIFT ; for big keyboard with 54 keys, shifted, the table has a size of 72 bytes
    DB  KCODE_DOWN,KCODE_UP,KCODE_RIGHT,0x0D,0x7C,KCODE_DEL, 0,0  ; M4
    DB  0x7D,0x2B,KCODE_LEFT,0x22,0x7B,0x5F, 0,0  ; M3
    DB  0x3E,0x4C,0x3F,0x3A,0x50,0x29, 0,0  ; M2
    DB  0x4F,0x28,0x3C,0x4B,0x49,0x2A, 0,0  ; M1
    DB  0x4E,0x48,0x4D,0x4A,0x55,0x26, 0,0  ; M0
    DB  0x59,0x5E,0x42,0x47,0x54,0x25, 0,0  ; OUT7
    DB  0x43,0x44,0x56,0x46,0x52,0x24, 0,0  ; OUT6
    DB  0x45,0x23,0x58,0x53,0x57,0x40, 0,0  ; OUT5
    DB  0x20,0x7E,0x5A,0x41,0x51,0x21, 0,0  ; OUT4

; Special LCD characters for the editor:
;[2]    ;[3]    ;[4]
;#.###  ;..#..  ;..#..
;#.#.#  ;..#..  ;..#..
;#.#.#  ;.#...  ;...#.
;#.#.#  ;#....  ;....#
;#.#.#  ;.#...  ;...#.
;#.#.#  ;..#..  ;..#..
;#.###  ;..#..  ;..#..
;.....  ;..#..  ;..#..

ed2_chars   DB  0x00,0x17,0x15,0x15,0x15,0x15,0x17,0x00  ;[2]:10
            DB  0x00,0x04,0x04,0x08,0x10,0x08,0x04,0x04  ;[3]:<
            DB  0x00,0x04,0x04,0x02,0x01,0x02,0x04,0x04  ;[4]:>
#endif

#ifdef WITH_I2C_LCD_KYBD
#include "m4-i2c-lcd-kybd-fast/lcd-kybd-table-lcd-chr.asm"	;7cf0h
#endif

ORG 7D00h

;Table with supported environment strings
tab_envstrings:
    DB  20,"/COUNTED-STRING",0,1
    DW  255
    DB  10,"/HOLD",0,1
    DW  NUMBUF_SZ
    DB  9,"/PAD",0,1
    DW  PAD_SIZE
    DB  22,"ADDRESS-UNIT-BITS",0,1
    DW  8
    DB  12,"FLOORED",0,1
    DW  0
    DB  13,"MAX-CHAR",0,1
    DW  255
    DB  12,"MAX-D",0,2
    DW  0xFFFF,0x7FFF   ; push 0xFFFF first to stack, than push 0x7FFF
    DB  10,"MAX-N",0,1
    DW  0x7FFF
    DB  10,"MAX-U",0,1
    DW  0xFFFF
    DB  13,"MAX-UD",0,2
    DW  0xFFFF,0xFFFF
    DB  23,"RETURN-STACK-CELLS",0,1
    DW  50
    DB  16,"STACK-CELLS",0,1
    DW  128
    DB  0

#ifdef WITH_I2C_LCD_KYBD
#include "m4-i2c-lcd-kybd-fast/lcd-kybd-table-keyctrl.asm"
#include "m4-i2c-lcd-kybd-fast/lcd-kybd-utils2.asm"
#endif

ORG 7DFEh
    DB  CPUCLOCK
    DB  <(ROMVERSION_BINARY - 0x11)


ORG 7E00h
TAB_CRC16HI    DB  000h, 010h, 020h, 030h, 040h, 050h, 060h, 070h
               DB  081h, 091h, 0a1h, 0b1h, 0c1h, 0d1h, 0e1h, 0f1h
               DB  012h, 002h, 032h, 022h, 052h, 042h, 072h, 062h
               DB  093h, 083h, 0b3h, 0a3h, 0d3h, 0c3h, 0f3h, 0e3h
               DB  024h, 034h, 004h, 014h, 064h, 074h, 044h, 054h
               DB  0a5h, 0b5h, 085h, 095h, 0e5h, 0f5h, 0c5h, 0d5h
               DB  036h, 026h, 016h, 006h, 076h, 066h, 056h, 046h
               DB  0b7h, 0a7h, 097h, 087h, 0f7h, 0e7h, 0d7h, 0c7h
               DB  048h, 058h, 068h, 078h, 008h, 018h, 028h, 038h
               DB  0c9h, 0d9h, 0e9h, 0f9h, 089h, 099h, 0a9h, 0b9h
               DB  05ah, 04ah, 07ah, 06ah, 01ah, 00ah, 03ah, 02ah
               DB  0dbh, 0cbh, 0fbh, 0ebh, 09bh, 08bh, 0bbh, 0abh
               DB  06ch, 07ch, 04ch, 05ch, 02ch, 03ch, 00ch, 01ch
               DB  0edh, 0fdh, 0cdh, 0ddh, 0adh, 0bdh, 08dh, 09dh
               DB  07eh, 06eh, 05eh, 04eh, 03eh, 02eh, 01eh, 00eh
               DB  0ffh, 0efh, 0dfh, 0cfh, 0bfh, 0afh, 09fh, 08fh
               DB  091h, 081h, 0b1h, 0a1h, 0d1h, 0c1h, 0f1h, 0e1h
               DB  010h, 000h, 030h, 020h, 050h, 040h, 070h, 060h
               DB  083h, 093h, 0a3h, 0b3h, 0c3h, 0d3h, 0e3h, 0f3h
               DB  002h, 012h, 022h, 032h, 042h, 052h, 062h, 072h
               DB  0b5h, 0a5h, 095h, 085h, 0f5h, 0e5h, 0d5h, 0c5h
               DB  034h, 024h, 014h, 004h, 074h, 064h, 054h, 044h
               DB  0a7h, 0b7h, 087h, 097h, 0e7h, 0f7h, 0c7h, 0d7h
               DB  026h, 036h, 006h, 016h, 066h, 076h, 046h, 056h
               DB  0d9h, 0c9h, 0f9h, 0e9h, 099h, 089h, 0b9h, 0a9h
               DB  058h, 048h, 078h, 068h, 018h, 008h, 038h, 028h
               DB  0cbh, 0dbh, 0ebh, 0fbh, 08bh, 09bh, 0abh, 0bbh
               DB  04ah, 05ah, 06ah, 07ah, 00ah, 01ah, 02ah, 03ah
               DB  0fdh, 0edh, 0ddh, 0cdh, 0bdh, 0adh, 09dh, 08dh
               DB  07ch, 06ch, 05ch, 04ch, 03ch, 02ch, 01ch, 00ch
               DB  0efh, 0ffh, 0cfh, 0dfh, 0afh, 0bfh, 08fh, 09fh
               DB  06eh, 07eh, 04eh, 05eh, 02eh, 03eh, 00eh, 01eh

TAB_CRC16LO    DB  000h, 021h, 042h, 063h, 084h, 0a5h, 0c6h, 0e7h
               DB  008h, 029h, 04ah, 06bh, 08ch, 0adh, 0ceh, 0efh
               DB  031h, 010h, 073h, 052h, 0b5h, 094h, 0f7h, 0d6h
               DB  039h, 018h, 07bh, 05ah, 0bdh, 09ch, 0ffh, 0deh
               DB  062h, 043h, 020h, 001h, 0e6h, 0c7h, 0a4h, 085h
               DB  06ah, 04bh, 028h, 009h, 0eeh, 0cfh, 0ach, 08dh
               DB  053h, 072h, 011h, 030h, 0d7h, 0f6h, 095h, 0b4h
               DB  05bh, 07ah, 019h, 038h, 0dfh, 0feh, 09dh, 0bch
               DB  0c4h, 0e5h, 086h, 0a7h, 040h, 061h, 002h, 023h
               DB  0cch, 0edh, 08eh, 0afh, 048h, 069h, 00ah, 02bh
               DB  0f5h, 0d4h, 0b7h, 096h, 071h, 050h, 033h, 012h
               DB  0fdh, 0dch, 0bfh, 09eh, 079h, 058h, 03bh, 01ah
               DB  0a6h, 087h, 0e4h, 0c5h, 022h, 003h, 060h, 041h
               DB  0aeh, 08fh, 0ech, 0cdh, 02ah, 00bh, 068h, 049h
               DB  097h, 0b6h, 0d5h, 0f4h, 013h, 032h, 051h, 070h
               DB  09fh, 0beh, 0ddh, 0fch, 01bh, 03ah, 059h, 078h
               DB  088h, 0a9h, 0cah, 0ebh, 00ch, 02dh, 04eh, 06fh
               DB  080h, 0a1h, 0c2h, 0e3h, 004h, 025h, 046h, 067h
               DB  0b9h, 098h, 0fbh, 0dah, 03dh, 01ch, 07fh, 05eh
               DB  0b1h, 090h, 0f3h, 0d2h, 035h, 014h, 077h, 056h
               DB  0eah, 0cbh, 0a8h, 089h, 06eh, 04fh, 02ch, 00dh
               DB  0e2h, 0c3h, 0a0h, 081h, 066h, 047h, 024h, 005h
               DB  0dbh, 0fah, 099h, 0b8h, 05fh, 07eh, 01dh, 03ch
               DB  0d3h, 0f2h, 091h, 0b0h, 057h, 076h, 015h, 034h
               DB  04ch, 06dh, 00eh, 02fh, 0c8h, 0e9h, 08ah, 0abh
               DB  044h, 065h, 006h, 027h, 0c0h, 0e1h, 082h, 0a3h
               DB  07dh, 05ch, 03fh, 01eh, 0f9h, 0d8h, 0bbh, 09ah
               DB  075h, 054h, 037h, 016h, 0f1h, 0d0h, 0b3h, 092h
               DB  02eh, 00fh, 06ch, 04dh, 0aah, 08bh, 0e8h, 0c9h
               DB  026h, 007h, 064h, 045h, 0a2h, 083h, 0e0h, 0c1h
               DB  01fh, 03eh, 05dh, 07ch, 09bh, 0bah, 0d9h, 0f8h
               DB  017h, 036h, 055h, 074h, 093h, 0b2h, 0d1h, 0f0h

#endif
