;------------------------------------------------------------------------------
; UART Functions for sending / receiving with 4800/9600 baud
;------------------------------------------------------------------------------

;Put UART code into a special segment so it never crosses a 256-byte boundary
#ifndef WITH_I2C_LCD_KYBD
uart_functions Segment Code
ORG ROM_HI+0x0020
#else
;ORG ROM_HI+(delay_end-delay_ms)
#endif

UART_TXD_DEFAULT  SET 0x01   ; TXD is high by default


#ifdef PLATFORM_XS

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 4800 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU
#ifndef NO_I2C
          TST  I2C_BUSY
          JNF  ret_opc
#endif
          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay

          INC
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          JPF  _rcvch2
_rcvch4   ;delay
          INC
          INC
          INC
          INC
          INC
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          INC
          INC
          INC
          INC
          INC
          INC
          ;receive next bit
          IN
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET


SEG_PRGCODE

uart_unlock:
          TST  I2C_BUSY
          JPF  ret_opc
          LD   I2C_BUSY,#0
          LD   OUTP,#0x03   ; SCL=low,SDA=high,TXD=high
          OUT  OUTP
          RET

#else
;------------------------------------------------------------------------------

;UART routines for 8 MHz and 16 MHz CPU clock frequency:
#if (CPUCLOCK == 8) || (CPUCLOCK == 16)

#ifdef BAUD14400	; 14400 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 14400 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          ;LD   PAR1,R0
          PSH  R0
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          ;ROR  ACCU
          ;ROR  ACCU
          ;INC
          ;INC
          ;output bits
          LD   R0,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;output next bit
          JLP  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          POP  R0
          ;LD   R0,PAR1
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 14400 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
          PSH  R0
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          ;INC
          ;receive 8 bits
          LD   R0,#8
_rcvch3   ;delay
          OR  ACCU
          INC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          JLP  _rcvch3
          ;return
          LDA  PAR2
          POP  R0
          RET

#else ; 9600 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 4800/9600 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          ROR  ACCU
          ROR  ACCU
          INC
          INC
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          INC
          LD   ACCU,ACCU
          LD   ACCU,ACCU
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          INC
          INC
          INC
          INC
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          XOR  ACCU
          INC
          CLC
          CLC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET

#endif ; FASTBAUD

#endif ; 8/16 MHz

;------------------------------------------------------------------------------

;UART routines for 10 MHz and 20 MHz CPU clock frequency:
#if (CPUCLOCK == 10) || (CPUCLOCK == 20)

#ifdef BAUD14400	; 14400 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 14400 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          INC
          INC
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          INC
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET

uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 14400 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          INC
          INC
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          OR   ACCU
          INC
          INC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET
          
#else	; 9600 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 4800/9600 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          OR   ACCU
          ROR  ACCU
          ROR  ACCU
          INC
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          AND  ACCU
          INC
          LDA  ACCU
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          OR   ACCU
          ROL
          INC
          INC
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          XOR  ACCU
          OR   ACCU
          INC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET
          
#endif ; FASTBAUD

#endif ; 10/20 MHz

;------------------------------------------------------------------------------

;UART routines for 22.1184 MHz CPU clock frequency:
#if (CPUCLOCK == 22)

#if defined(BAUD14400)	; 14400 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 9600 baud (6944Hz @ 16MHz)
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          ROR  ACCU
          ROR  ACCU
          INC
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          ROR  ACCU
          INC
 
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          OR  ACCU
          ROR  ACCU
          ROR  ACCU
          INC
                   
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          ROR  ACCU
          ROR  ACCU
          LD   ACCU,ACCU
          LD   ACCU,ACCU
          LD   ACCU,ACCU
          INC
                 
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET

#elif defined(BAUD19200)	; 19200 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 14400 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          ;LD   PAR1,R0
          PSH  R0
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          INC
          INC
          CLC
          ;INC
          ;output bits
          LD   R0,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          ;INC
          ;output next bit
          JLP  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          POP  R0
          ;LD   R0,PAR1
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 14400 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
          PSH  R0
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          INC
          ;receive 8 bits
          LD   R0,#8
_rcvch3   ;delay
          OR  ACCU
          INC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          JLP  _rcvch3
          ;return
          LDA  PAR2
          POP  R0
          RET

#else ; 9600 baud

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 9600 baud (6944Hz @ 16MHz)
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          OR   ACCU
          AND  ACCU
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay

          XOR  ACCU
          LD   ACCU,ACCU
          LD   ACCU,ACCU 
 
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          
          OR   ACCU
          INC
                   
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          XOR  ACCU
          DEC
          OR  ACCU
          INC
          INC       
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET

#endif ; FASTBAUD

#endif ; 22 MHz

;------------------------------------------------------------------------------

;UART routines for 12 MHz and 24 MHz CPU clock frequency:
#if (CPUCLOCK == 12) || (CPUCLOCK == 24)

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 4800/9600 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          XOR  ACCU
          AND  ACCU
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          AND  ACCU
          AND  ACCU
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          OR   ACCU
          OR   ACCU
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          XOR  ACCU
          XOR  ACCU
          INC
          INC
          INC
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET

#endif ; 12/24 MHz

;------------------------------------------------------------------------------

;UART routines for 14 MHz and 28 MHz CPU clock frequency:
#if (CPUCLOCK == 14) || (CPUCLOCK == 28)

uart_xmit:
          ;@API UART
          ; Send a character / byte over the UART TxD line with 4800/9600 baud
          ; In: ACCU = character, OUTP = bits 0-6 of Output Port 3
          ; Changes: ACCU

          ;send start-bit
          STA  PAR2
          LDA  OUTP
          AND  #0xFE
          OUT
          STA  OUTP
          ;delay
          XOR  ACCU
          XOR  ACCU
          ROL
          ROL
          ;output bits
          LD   PAR1,#8
_sndbit   LDA  OUTP
          ROR  PAR2
          OR   FLAG
          OUT
          ;delay
          XOR  ACCU
          XOR  ACCU
          INC
          CLC
          ;output next bit
          DEC  PAR1
          TST  PAR1
          JNF  _sndbit
          ;send stop-bit
          LDA  OUTP
          OR   #0x01
          OUT
          STA  OUTP
          ;correct R0L
          ROR  PAR2
          ;return
          RET


uart_recv:
          ;@API UART
          ; Receive a character / byte over the UART RxD line with 4800/9600 baud
          ; Out: ACCU = received byte
          ; Changes: ACCU
          ;
          ;wait for start-bit (falling edge on RxD)
_rcvch1   IN
          STA  FLAG
          JNF  _rcvch1
_rcvch2   INC  RANDVAR
          IN
          STA  FLAG
          JPF  _rcvch2
          ;delay
          XOR  ACCU
          AND  ACCU
          ;receive 8 bits
          LD   PAR1,#8
_rcvch3   ;delay
          XOR  ACCU
          XOR  ACCU
          XOR  ACCU
          ;receive next bit
          IN
          STA  FLAG
          ROR  PAR2
          DEC  PAR1
          TST  PAR1
          JNF  _rcvch3
          ;return
          LDA  PAR2
          RET

#endif ; 14/28 MHz
#endif ; ! PLATFORM_XS

;  IO-Speedtest mit ./my4th -t -d timing -c 2000000 -f 16


