;------------------------------------------------------------------------------
; Variables and Registers are defined here
;------------------------------------------------------------------------------

SEG_ZEROPAGE


; Common system / library variables
LIB_BUF       DS 14 ; 14 character universal buffer
;#ifdef PLATFORM_XS
;LIB_BUF2      DS 2  ; on the xs-platform the LIB_BUF buffer is 16 bytes long
;#endif
LIB_TFDATA    DS 6  ; 6 bytes for the transfer functions in transfer.asm
LIB_BIGKEYB   DS 1  ; flag: if set to 1, the big keyboard with 4x40 LCD is installed
LIB_KEYREPC   DS 2  ; keyboard key repeat counter
LIB_DISPMAXX  DS 1  ; X size (width) of the current display
LIB_DISPMAXY  DS 1  ; Y size (height) of the current display
LIB_LCDMAXX   DS 1  ; max. X-position on the LCD (20 or 40)
LIB_LCDOUT    DS 1  ; flag: if set to 1, all print-functions are printing on LCD instead over UART
LIB_LCDENAS   DS 1  ; LCD enable bits: bit4 = LCD1, bit5 = LCD2, bit1 = always 1, all other bits must be 0!
LIB_LCDCRSR   DS 1  ; flag: nonzero when the cursor is on
LIB_KBNOKEYB  DS 1  ; for keyboard input: Key-Debounce-"Counter"
LIB_LCDPOSX   DS 1  ; cursor X-position on the display
LIB_LCDPOSY   DS 1  ; cursor Y-position on the display
LIB_LCDBUFP   DS 1  ; ptr into LCD_BUFFER (lower 8-bit of the buffer address)
LIB_EEPADDR   DS 1  ; address of currently selected EEPROM
LIB_EEADDRS   DS 8  ; addresses of all detected EEPROMs (0=no EEPROM)
LIB_NUMPAGES  DS 2  ; count of 1kb pages the EEPROMs can store
LIB_I2C_C0D0  DS 1  ; I2C: SCL=0, SDA=0  (R6_L)
LIB_I2C_C0D1  DS 1  ; I2C: SCL=0, SDA=1  (R7_L)
LIB_I2C_C1D0  DS 1  ; I2C: SCL=1, SDA=0  (R6_H)
LIB_I2C_C1D1  DS 1  ; I2C: SCL=1, SDA=1  (R7_H)
LIB_MYNOR_OUT DS 2  ; shadow values for MyNOR output ports 1 and 2


;------------------------------------------------------------------------
; Forth Variables
;------------------------------------------------------------------------


;------------------------------------------

; Memory for program header (contains the variables CP and DICTA, and system vectors, UP )
PRGHDR_SIZE SET 3*6 + 2 + 2*8 + 2 + 5 ; 43 bytes
PRGHEADER   DS  PRGHDR_SIZE

; System vectors
VECT_OUTPUT SET PRGHEADER+0  ; if not NULL, vector for printing characters on external device
VECT_INPUT  SET PRGHEADER+3  ; if not NULL, external function for keyboard input (non-blocking 'readkey')
VECT_OK     SET PRGHEADER+6  ; this vector gets called to print the OK text
VECT_PROMPT SET PRGHEADER+9  ; vector to print the prompt 
VECT_INPSTR SET PRGHEADER+12 ; vector for custom input string function (see input_string in input.asm)
VECT_GETNBR SET PRGHEADER+15 ; vector for converting numbers from a string

VECTOR1       SET VECT_OUTPUT
OUTPUT_VECTOR SET REGPAGE + VECT_OUTPUT ;JSR to address OUTPUT_VECTOR to call the vector
INPUT_VECTOR  SET REGPAGE + VECT_INPUT  ;JSR to address INPUT_VECTOR to call the vector
OK_VECTOR     SET REGPAGE + VECT_OK     ;JSR to address OK_VECTOR to call the vector
PROMPT_VECTOR SET REGPAGE + VECT_PROMPT ;JSR to address PROMPT_VECTOR to call the vector
INPSTR_VECTOR SET REGPAGE + VECT_INPSTR ;JSR to address INPSTR_VECTOR to call the vector
GETNBR_VECTOR SET REGPAGE + VECT_GETNBR ;JSR to address GETNBR_VECTOR to call the vector

; start of pre-initialized variables
VAR_INIT_START  SET CP_L

; pointer to beginning of free memory (the "heap") (this is also the Forth variable "HERE")
CP_L        SET PRGHEADER+18
CP_H        SET PRGHEADER+19

; 8 dictionary pointers
DICTA       SET PRGHEADER+20

; Forth user pointer
UP          SET PRGHEADER+36
UP_L        SET UP
UP_H        SET UP+1

; Storage for the block structure
BLKSTR_SIZE SET 5
BLKSTRUCT   SET PRGHEADER+38
BLKSTR_BUF  SET BLKSTRUCT
BLKSTR_BLK  SET BLKSTRUCT+2
BLKSTR_UPD  SET BLKSTRUCT+4

;space for JSR via pointer
JSRSPACE      DS 6   ;contains JSR x, JMP return
JSRSPACE_JMP  SET REGPAGE + JSRSPACE

;space for JSR/JMP instruction for the interpreter
IPRSPACE      DS 6   ;contains JSR x, JMP interpreterloop
IPRSPACE_JMP  SET REGPAGE + IPRSPACE

; Forth BASE variable
BASE        DS  2

; state of the EEPROM (1=active read transfer)
EEP_STATE   DS 1

;storage for next input char (if available)
NEXTINCHR   DS 1

; Storage for block number
BLK         DS 2
BLK_L       SET BLK
BLK_H       SET BLK+1

; Storage for the block most recently listed
SCR         DS 2
SCR_L       SET SCR
SCR_H       SET SCR+1

INPUTDEV    DS 1  ; current input device for string command execution
INDEV_LOCAL   SET 0  ; the input device is the local keyboard or a terminal connected to the UART
INDEV_FILE    SET 1  ; the input device is a screen loaded from EEPROM
INDEV_REMOTE  SET 2  ; the input device is a remote host

; Flag for REFILL
REFILL      DS 1

VAR_INIT_END    SET REFILL+1
; end of pre-initialized variables
;------------------------------------------


; Helper pointer for DOES>
DOESH       DS 2
DOESH_L     SET DOESH
DOESH_H     SET DOESH+1

; Forth parameter stack pointer (0x8100 - 0x817F)
fPSP        DS 1

; System data stack pointer
SYSSP       DS 1

; Return stack stack pointer
RETSP       DS 1

; Control flow stack pointer for conditional jumps and other compiler constructs
CCFSP       DS 1

; Control flow stack pointer for loop control
LCFSP       DS 1

; Buffer for mathematical calculations: shares two bytes space with "JSRSPACE"
MATH_BUF    SET JSRSPACE+1

; interpreter state: 0 = execute words, 1 = compile word address to dictionary
STATE       DS 2

; pointer to start of code of current word that is getting compiled
CW          DS 2
CW_L        SET CW
CW_H        SET CW+1

; pointer to the last added word
DICTL       DS 2
DICTL_L     SET DICTL
DICTL_H     SET DICTL+1

; pointer to list head pointer of the selected dictionary
DICTLH      DS 1

; current parser input data pointer. This is the Forth variable >IN (but it does not start with 0).
INPTR       DS 2
INPTR_L     SET INPTR
INPTR_H     SET INPTR+1

; temporary storage for the return stack pointer
;RSP         DS 1    - replaced by PAR1 since v1.4

; flag for I2C activity  (only used on XS platforms)
I2C_BUSY    DS 1

; Storage for random number generator
RANDVAR     DS 3

; buffer pointer for pictured numeric output string
NB          DS 2
NB_L        SET NB
NB_H        SET NB+1

; the terminal input buffer
TIBUF_SZ    SET 80
TIBUF       SET FORTH_INPBUF  ;DS TIBUF_SZ

; if screen is loaded from EEPROM, this is the current line number 0-15
FILE_LNBR   DS 2  ; must be 2 bytes although only one byte is needed

#ifdef INCLUDE_IOBOARD_WORDS
GPIO_BOARD  DS 1  ; I/O board ID
GPIO_ADDR   DS 1  ; I2C address of selected I/O board
GPIO_VALUE  DS 2  ; 16-bit gpout value
LCD_ADDR    DS 1  ; I2C address of the LCD
LCD_IFTYPE  DS 1  ; LCD interface type. 0 = PCF8574
LCD_WIDTH   DS 1  ; LCD line length
LCD_HEIGHT  DS 1  ; number of lines on the LCD
LCD_MEMOFS  DS 4  ; memory offset for each LCD line (up to 4)
LCD_BLIGHT  DS 1  ; flag for backlight
LCD_POSX    DS 1  ; x-position
LCD_POSY    DS 1  ; y-position
UART_ADDR   DS 1  ; I2C address of the SC16IS750 uart
UART_HWHS   DS 1  ; flag: nonzero if hardware-handshake is enabled
UART_RXRDY  DS 1  ; flag: nonzero if one byte is available for receive
KMX_SIZE    DS 1  ; flag for keyboard matrix size: 0 = 4x4, 1 = 8x8 (PCF8575)
KMX_ADDR    DS 1  ; I2C address of the used PCF8574/5 chip
KMX_OUTP    DS 1  ; value of the optional output on bits D8-D15 of the PCF8575
KMX_IS8575  DS 1  ; flag: nonzero if PCF8575 is used
KMX_DEBNCE  DS 1  ; debounce counter
#endif


;------------------------------------------------------------------------
; Binary Driver Variables
;------------------------------------------------------------------------

SEG_ZPBINMOD

DRIVER_VARS DS 32   ; dummy: allocate 32 bytes for external driver code



;------------------------------------------------------------------------
; Buffer memory 0x8200 - 0x83FF
;------------------------------------------------------------------------

;_buffermem Segment Data
;ORG 0x8200

SEG_RAM  ;starts at 0x8200

LCD_BUFFER    DS 4*40
FORTH_INPBUF  DS TIBUF_SZ  ;buffer for keyboard input
FILE_LINEBUF  DS 65  ;used as input buffer for the LOAD command (SCREEN lines)
UART_BUFFER   DS 170 ;minimum size for command execution, but buffer can occupy more memory
;no more buffers are allowed to follow here, because they are overwritten
;by data received via UART


;Define a dummy-segment for FORTH user program data. This is a "memory barrier" and
;will issue a warning in the list file when the variables defined above will overwrite
;the beginning of the FORTH data area.
forth_program  Segment Data
ORG FORTH_START

